/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.TargetApi;
import android.view.ViewTreeObserver;
import com.amazon.device.ads.AdController;
import com.amazon.device.ads.AmazonOnGlobalFocusChangeListenerFactory;
import com.amazon.device.ads.AmazonOnGlobalLayoutListenerFactory;
import com.amazon.device.ads.AmazonOnScrollChangedListenerFactory;
import com.amazon.device.ads.AmazonOnWindowFocusChangeListenerFactory;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.SDKEvent;
import com.amazon.device.ads.ViewUtils;
import com.amazon.device.ads.ViewabilityChecker;
import com.amazon.device.ads.ViewabilityCheckerFactory;
import com.amazon.device.ads.ViewabilityInfo;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

class ViewabilityObserver {
    private static final String LOGTAG = ViewabilityObserver.class.getSimpleName();
    public static final String VIEWABLE_PARAMS_KEY = "VIEWABLE_PARAMS";
    public static final String IS_VIEWABLE_KEY = "IS_VIEWABLE";
    private static long VIEWABLE_INTERVAL = 200L;
    private final AdController adController;
    private final MobileAdsLogger logger;
    private final ViewUtils viewUtils;
    private ViewTreeObserver viewTreeObserver;
    private final ViewabilityChecker viewabilityChecker;
    private final ViewTreeObserver.OnGlobalFocusChangeListener onGlobalFocusChangeListener;
    private final ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
    private final ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
    private ViewTreeObserver.OnWindowFocusChangeListener onWindowFocusChangeListener;
    private boolean firedOnlyOnce = false;
    private boolean observersAdded = false;
    private final AtomicInteger viewabilityInterestCount;
    private final AtomicBoolean isScrollListenerAdded;
    private long lastTimeViewableEventFired = 0L;
    private final DebugProperties debugProperties;
    private final Configuration configuration;

    public ViewabilityObserver(AdController adController) {
        this(adController, new ViewabilityCheckerFactory(), new MobileAdsLoggerFactory(), new AmazonOnGlobalFocusChangeListenerFactory(), new AmazonOnGlobalLayoutListenerFactory(), new AmazonOnScrollChangedListenerFactory(), new AmazonOnWindowFocusChangeListenerFactory(), new AtomicInteger(0), new AtomicBoolean(false), new ViewUtils(), DebugProperties.getInstance(), Configuration.getInstance());
    }

    ViewabilityObserver(AdController adController, ViewabilityCheckerFactory viewabilityCheckerFactory, MobileAdsLoggerFactory mobileAdsLoggerFactory, AmazonOnGlobalFocusChangeListenerFactory amazonOnGlobalFocusChangeListenerFactory, AmazonOnGlobalLayoutListenerFactory amazonOnGlobalLayoutListenerFactory, AmazonOnScrollChangedListenerFactory amazonOnScrollChangedListenerFactory, AmazonOnWindowFocusChangeListenerFactory amazonOnWindowFocusChangeListenerFactory, AtomicInteger viewabilityInterestCount, AtomicBoolean isScrollListenerAdded, ViewUtils viewUtils, DebugProperties debugProperties, Configuration configuration) {
        this.adController = adController;
        this.logger = mobileAdsLoggerFactory.createMobileAdsLogger(LOGTAG);
        this.viewabilityChecker = viewabilityCheckerFactory.buildViewabilityChecker(this.adController);
        this.onGlobalFocusChangeListener = amazonOnGlobalFocusChangeListenerFactory.buildAmazonOnGlobalFocusChangedListener(this);
        this.onGlobalLayoutListener = amazonOnGlobalLayoutListenerFactory.buildAmazonOnGlobalLayoutListener(this);
        this.onScrollChangedListener = amazonOnScrollChangedListenerFactory.buildAmazonOnScrollChangedListenerFactory(this);
        if (AndroidTargetUtils.isAtLeastAndroidAPI(18)) {
            this.onWindowFocusChangeListener = amazonOnWindowFocusChangeListenerFactory.buildOnWindowFocusChangeListener(this);
        }
        this.viewabilityInterestCount = viewabilityInterestCount;
        this.isScrollListenerAdded = isScrollListenerAdded;
        this.viewUtils = viewUtils;
        this.debugProperties = debugProperties;
        this.configuration = configuration;
        VIEWABLE_INTERVAL = this.debugProperties.getDebugPropertyAsLong("debug.viewableInterval", this.configuration.getLongWithDefault(Configuration.ConfigOption.VIEWABLE_INTERVAL, 200L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerViewabilityInterest() {
        int count = this.viewabilityInterestCount.incrementAndGet();
        this.logger.d("Viewability Interest Registered. Current number of objects interested in viewability: %d", count);
        ViewabilityObserver viewabilityObserver = this;
        synchronized (viewabilityObserver) {
            this.addObserversIfNeeded();
        }
    }

    @TargetApi(value=18)
    private void addObserversIfNeeded() {
        if (this.viewTreeObserver == null) {
            this.viewTreeObserver = this.adController.getAdContainer().getViewTreeObserver();
        }
        if (!this.isViewTreeObserverAlive() || this.observersAdded) {
            return;
        }
        this.viewTreeObserver.addOnGlobalLayoutListener(this.onGlobalLayoutListener);
        this.viewTreeObserver.addOnGlobalFocusChangeListener(this.onGlobalFocusChangeListener);
        if (AndroidTargetUtils.isAtLeastAndroidAPI(18)) {
            this.viewTreeObserver.addOnWindowFocusChangeListener(this.onWindowFocusChangeListener);
        }
        this.observersAdded = true;
        this.fireViewableEvent(false);
    }

    protected void addOnScrollChangedListenerIfNeeded() {
        if (!this.isScrollListenerAdded.get()) {
            if (this.viewTreeObserver == null || !this.viewTreeObserver.isAlive()) {
                this.viewTreeObserver = this.adController.getAdContainer().getViewTreeObserver();
            }
            this.viewTreeObserver.addOnScrollChangedListener(this.onScrollChangedListener);
            this.isScrollListenerAdded.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterViewabilityInterest() {
        ViewabilityObserver viewabilityObserver = this;
        synchronized (viewabilityObserver) {
            int listenerCount = this.viewabilityInterestCount.decrementAndGet();
            if (listenerCount < 0) {
                this.logger.w("No Viewability Interest was previously registered. Ignoring request to deregister.");
                this.viewabilityInterestCount.incrementAndGet();
                return;
            }
            this.logger.d("Viewability Interest Deregistered. Current number of objects interested in viewability: %d", listenerCount);
            if (listenerCount == 0) {
                this.removeObservers();
            }
        }
    }

    @TargetApi(value=18)
    private void removeObservers() {
        if (this.viewTreeObserver == null) {
            this.logger.w("Root view tree observer is null");
            return;
        }
        if (!this.viewUtils.removeOnGlobalLayoutListener(this.viewTreeObserver, this.onGlobalLayoutListener)) {
            this.logger.w("Root view tree observer is not alive");
            return;
        }
        this.viewTreeObserver.removeOnScrollChangedListener(this.onScrollChangedListener);
        this.viewTreeObserver.removeOnGlobalFocusChangeListener(this.onGlobalFocusChangeListener);
        if (AndroidTargetUtils.isAtLeastAndroidAPI(18)) {
            this.viewTreeObserver.removeOnWindowFocusChangeListener(this.onWindowFocusChangeListener);
        }
        this.observersAdded = false;
        this.isScrollListenerAdded.set(false);
    }

    public void fireViewableEvent(boolean isScrollEvent) {
        long difference;
        long currentTime = System.currentTimeMillis();
        if (isScrollEvent && (difference = currentTime - this.lastTimeViewableEventFired) < VIEWABLE_INTERVAL) {
            return;
        }
        this.lastTimeViewableEventFired = currentTime;
        ViewabilityInfo viewabilityInfo = this.viewabilityChecker.getViewabilityInfo();
        if (viewabilityInfo == null) {
            this.logger.w("Viewable info is null");
            return;
        }
        JSONObject viewableParams = viewabilityInfo.getJsonObject();
        boolean isAdOnScreen = viewabilityInfo.isAdOnScreen();
        SDKEvent viewableSDKEvent = new SDKEvent(SDKEvent.SDKEventType.VIEWABLE);
        viewableSDKEvent.setParameter(VIEWABLE_PARAMS_KEY, viewableParams.toString());
        viewableSDKEvent.setParameter(IS_VIEWABLE_KEY, isAdOnScreen ? "true" : " false");
        if (!isAdOnScreen) {
            if (!this.firedOnlyOnce) {
                this.adController.fireSDKEvent(viewableSDKEvent);
                this.firedOnlyOnce = true;
            }
        } else {
            this.adController.fireSDKEvent(viewableSDKEvent);
            this.firedOnlyOnce = false;
        }
    }

    private boolean isViewTreeObserverAlive() {
        if (!this.viewTreeObserver.isAlive()) {
            this.logger.w("Root view tree observer is not alive");
            return false;
        }
        return true;
    }

    public boolean isViewable() {
        ViewabilityInfo viewabilityInfo = this.viewabilityChecker.getViewabilityInfo();
        if (viewabilityInfo == null) {
            this.logger.w("Viewable info is null");
            return false;
        }
        return viewabilityInfo.isAdOnScreen();
    }
}

