/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.AppEventRegistrationHandler;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.RegistrationInfo;
import com.amazon.device.ads.SISDeviceRequest;
import com.amazon.device.ads.SISGenerateDIDRequest;
import com.amazon.device.ads.SISRequest;
import com.amazon.device.ads.SISUpdateDeviceInfoRequest;
import com.amazon.device.ads.WebRequest;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SISRegisterEventRequest
implements SISRequest {
    private static final String LOGTAG = "SISRegisterEventRequest";
    private static final Metrics.MetricType CALL_METRIC_TYPE = Metrics.MetricType.SIS_LATENCY_REGISTER_EVENT;
    private static final String PATH = "/register_event";
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger("SISRegisterEventRequest");
    private final AdvertisingIdentifier.Info advertisingIdentifierInfo;
    private final MobileAdsInfoStore infoStore;
    private final Configuration configuration;
    private final AppEventRegistrationHandler appEventRegistrationHandler;
    private final JSONArray appEvents;

    public SISRegisterEventRequest(AdvertisingIdentifier.Info advertisingIdentifierInfo, JSONArray appEvents) {
        this(advertisingIdentifierInfo, appEvents, MobileAdsInfoStore.getInstance(), Configuration.getInstance(), AppEventRegistrationHandler.getInstance());
    }

    SISRegisterEventRequest(AdvertisingIdentifier.Info advertisingIdentifierInfo, JSONArray appEvents, MobileAdsInfoStore infoStore, Configuration configuration, AppEventRegistrationHandler appEventRegistrationHandler) {
        this.advertisingIdentifierInfo = advertisingIdentifierInfo;
        this.appEvents = appEvents;
        this.infoStore = infoStore;
        this.configuration = configuration;
        this.appEventRegistrationHandler = appEventRegistrationHandler;
    }

    @Override
    public String getLogTag() {
        return LOGTAG;
    }

    @Override
    public Metrics.MetricType getCallMetricType() {
        return CALL_METRIC_TYPE;
    }

    @Override
    public String getPath() {
        return PATH;
    }

    @Override
    public WebRequest.QueryStringParameters getQueryParameters() {
        WebRequest.QueryStringParameters queryStringParameters = new WebRequest.QueryStringParameters();
        queryStringParameters.putUrlEncoded("adId", this.advertisingIdentifierInfo.getSISDeviceIdentifier());
        queryStringParameters.putUrlEncoded("dt", this.infoStore.getDeviceInfo().getDeviceType());
        RegistrationInfo registrationInfo = this.infoStore.getRegistrationInfo();
        queryStringParameters.putUrlEncoded("app", registrationInfo.getAppName());
        queryStringParameters.putUrlEncoded("appId", registrationInfo.getAppKey());
        queryStringParameters.putUrlEncoded("aud", this.configuration.getString(Configuration.ConfigOption.SIS_DOMAIN));
        queryStringParameters.putUnencoded("pkg", this.infoStore.getAppInfo().getPackageInfoJSONString());
        return queryStringParameters;
    }

    @Override
    public HashMap<String, String> getPostParameters() {
        HashMap<String, String> eventsMap = new HashMap<String, String>();
        eventsMap.put("events", this.appEvents.toString());
        return eventsMap;
    }

    @Override
    public void onResponseReceived(JSONObject payload) {
        int statusCode = JSONUtils.getIntegerFromJSON(payload, "rcode", 0);
        if (statusCode == 1) {
            this.logger.d("Application events registered successfully.");
            this.appEventRegistrationHandler.onAppEventsRegistered();
        } else {
            this.logger.d("Application events not registered. rcode:" + statusCode);
        }
    }

    @Override
    public MobileAdsLogger getLogger() {
        return this.logger;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SISRequestType {
        GENERATE_DID,
        UPDATE_DEVICE_INFO,
        REGISTER_EVENT;

    }

    static class SISRequestFactory {
        SISRequestFactory() {
        }

        public SISDeviceRequest createDeviceRequest(SISRequestType requestType) {
            switch (requestType) {
                case GENERATE_DID: {
                    return new SISGenerateDIDRequest();
                }
                case UPDATE_DEVICE_INFO: {
                    return new SISUpdateDeviceInfoRequest();
                }
            }
            throw new IllegalArgumentException("SISRequestType " + (Object)((Object)requestType) + " is not a SISDeviceRequest");
        }

        public SISRegisterEventRequest createRegisterEventRequest(AdvertisingIdentifier.Info advertisingIdentifierInfo, JSONArray appEvents) {
            return new SISRegisterEventRequest(advertisingIdentifierInfo, appEvents);
        }
    }
}

