/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.BitmapFactory;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.amazon.device.ads.AdActivity;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.Assets;
import com.amazon.device.ads.LayoutFactory;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.WebUtils2;
import com.amazon.device.ads.WebViewFactory;
import java.util.concurrent.atomic.AtomicBoolean;

class InAppBrowser
implements AdActivity.AdActivityAdapter {
    protected static final String LOGTAG = InAppBrowser.class.getSimpleName();
    protected static final String URL_EXTRA = "extra_url";
    protected static final String SHOW_OPEN_EXTERNAL_BROWSER_BTN = "extra_open_btn";
    protected static final int BUTTON_SIZE_DP = 50;
    protected static final int HORIZONTAL_RULE_SIZE_DP = 3;
    private static final String CONTENT_DESCRIPTION_BUTTON_LAYOUT = "inAppBrowserButtonLayout";
    private static final String CONTENT_DESCRIPTION_HORZ_RULE = "inAppBrowserHorizontalRule";
    private static final String CONTENT_DESCRIPTION_WEB_VIEW = "inAppBrowserWebView";
    private static final String CONTENT_DESCRIPTION_RELATIVE_LAYOUT = "inAppBrowserRelativeLayout";
    private static final String CONTENT_DESCRIPTION_MAIN_LAYOUT = "inAppBrowserMainLayout";
    private static final String CONTENT_DESCRIPTION_BACK_BUTTON = "inAppBrowserBackButton";
    private static final String CONTENT_DESCRIPTION_FORWARD_BUTTON = "inAppBrowserForwardButton";
    private static final String CONTENT_DESCRIPTION_CLOSE_BUTTON = "inAppBrowserCloseButton";
    private static final String CONTENT_DESCRIPTION_OPEN_EXT_BRWSR_BUTTON = "inAppBrowserOpenExternalBrowserButton";
    private static final String CONTENT_DESCRIPTION_REFRESH_BUTTON = "inAppBrowserRefreshButton";
    private final WebUtils2 webUtils;
    private final WebViewFactory webViewFactory;
    private WebView webView;
    private ImageButton browserBackButton;
    private ImageButton browserForwardButton;
    private ImageButton refreshButton;
    private ImageButton closeButton;
    private ImageButton openExternalBrowserButton;
    private final AtomicBoolean buttonsCreated = new AtomicBoolean(false);
    private Activity activity;
    private boolean showOpenExternalBrowserButton;
    private final MobileAdsLogger logger;
    private final MobileAdsInfoStore infoStore;
    private final Settings settings;
    private final Assets assets;
    private final LayoutFactory layoutFactory;
    private final WebViewFactory.MobileAdsCookieManager cookieManager;
    private final ThreadUtils.ThreadRunner threadRunner;

    InAppBrowser() {
        this(new WebUtils2(), WebViewFactory.getInstance(), new MobileAdsLoggerFactory(), MobileAdsInfoStore.getInstance(), Settings.getInstance(), Assets.getInstance(), new LayoutFactory(), new WebViewFactory.MobileAdsCookieManager(), ThreadUtils.getThreadRunner());
    }

    InAppBrowser(WebUtils2 webUtils, WebViewFactory webViewFactory, MobileAdsLoggerFactory loggerFactory, MobileAdsInfoStore infoStore, Settings settings, Assets assets, LayoutFactory layoutFactory, WebViewFactory.MobileAdsCookieManager cookieManager, ThreadUtils.ThreadRunner threadRunner) {
        this.webUtils = webUtils;
        this.webViewFactory = webViewFactory;
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.infoStore = infoStore;
        this.settings = settings;
        this.assets = assets;
        this.layoutFactory = layoutFactory;
        this.cookieManager = cookieManager;
        this.threadRunner = threadRunner;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public void onCreate() {
        this.activity.getWindow().requestFeature(2);
        this.activity.getWindow().setFeatureInt(2, -1);
        Intent intent = this.activity.getIntent();
        this.showOpenExternalBrowserButton = intent.getBooleanExtra(SHOW_OPEN_EXTERNAL_BROWSER_BTN, false);
        this.initialize(intent);
        this.initializeWebView(intent);
        this.enableCookies();
    }

    @SuppressLint(value={"InlinedApi"})
    private void initialize(Intent intent) {
        DisplayMetrics metrics = new DisplayMetrics();
        this.getMetrics(metrics);
        float mDensity = metrics.density;
        int buttonHeight = (int)(50.0f * mDensity + 0.5f);
        int ruleSize = (int)(3.0f * mDensity + 0.5f);
        int buttonCount = this.showOpenExternalBrowserButton ? 5 : 4;
        int buttonWidth = Math.min(metrics.widthPixels / buttonCount, 2 * buttonHeight);
        ViewGroup layout = this.layoutFactory.createLayout((Context)this.activity, LayoutFactory.LayoutType.RELATIVE_LAYOUT, CONTENT_DESCRIPTION_BUTTON_LAYOUT);
        layout.setId(10280);
        RelativeLayout.LayoutParams rp = new RelativeLayout.LayoutParams(-1, buttonHeight + ruleSize);
        rp.addRule(12);
        layout.setLayoutParams((ViewGroup.LayoutParams)rp);
        layout.setBackgroundColor(-986896);
        this.threadRunner.executeAsyncTask(new LoadButtonsTask(intent, layout, buttonWidth, buttonHeight), new Void[0]);
        View rule = new View((Context)this.activity);
        rule.setContentDescription((CharSequence)CONTENT_DESCRIPTION_HORZ_RULE);
        rule.setBackgroundColor(-3355444);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, ruleSize);
        params.addRule(10);
        rule.setLayoutParams((ViewGroup.LayoutParams)params);
        layout.addView(rule);
        this.webView = this.webViewFactory.createWebView((Context)this.activity);
        this.webView.getSettings().setUserAgentString(this.infoStore.getDeviceInfo().getUserAgentString() + "-inAppBrowser");
        this.webView.setContentDescription((CharSequence)CONTENT_DESCRIPTION_WEB_VIEW);
        RelativeLayout.LayoutParams wrp = new RelativeLayout.LayoutParams(-1, -1);
        wrp.addRule(2, layout.getId());
        this.webView.setLayoutParams((ViewGroup.LayoutParams)wrp);
        ViewGroup rl = this.layoutFactory.createLayout((Context)this.activity, LayoutFactory.LayoutType.RELATIVE_LAYOUT, CONTENT_DESCRIPTION_RELATIVE_LAYOUT);
        rl.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        rl.addView((View)this.webView);
        rl.addView((View)layout);
        LinearLayout mainll = (LinearLayout)this.layoutFactory.createLayout((Context)this.activity, LayoutFactory.LayoutType.LINEAR_LAYOUT, CONTENT_DESCRIPTION_MAIN_LAYOUT);
        mainll.setOrientation(1);
        mainll.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        mainll.addView((View)rl);
        this.activity.setContentView((View)mainll);
    }

    private ImageButton createButton(String src, int verb, int anchor, int buttonWidth, int buttonHeight) {
        ImageButton button = new ImageButton((Context)this.activity);
        button.setImageBitmap(BitmapFactory.decodeFile((String)src));
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(buttonWidth, buttonHeight);
        params.addRule(verb, anchor);
        params.addRule(12);
        button.setLayoutParams((ViewGroup.LayoutParams)params);
        button.setBackgroundColor(0);
        button.setScaleType(ImageView.ScaleType.FIT_CENTER);
        return button;
    }

    private void initializeWebView(Intent intent) {
        this.webViewFactory.setJavaScriptEnabledForWebView(true, this.webView, LOGTAG);
        this.webView.loadUrl(intent.getStringExtra(URL_EXTRA));
        this.webView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                InAppBrowser.this.logger.w("InApp Browser error: %s", description);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (StringUtils.isNullOrWhiteSpace(url)) {
                    return false;
                }
                String scheme = InAppBrowser.this.webUtils.getScheme(url);
                if (scheme.equals("http") || scheme.equals("https")) {
                    return false;
                }
                return InAppBrowser.this.webUtils.launchActivityForIntentLink(url, (Context)InAppBrowser.this.activity);
            }
        });
        this.webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int progress) {
                InAppBrowser.this.activity.setTitle((CharSequence)"Loading...");
                InAppBrowser.this.activity.setProgress(progress * 100);
                if (progress == 100) {
                    InAppBrowser.this.activity.setTitle((CharSequence)view.getUrl());
                }
                InAppBrowser.this.updateNavigationButtons(view);
            }
        });
    }

    private void initializeButtons(Intent intent) {
        this.browserBackButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (InAppBrowser.this.webView.canGoBack()) {
                    InAppBrowser.this.webView.goBack();
                }
            }
        });
        this.browserForwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (InAppBrowser.this.webView.canGoForward()) {
                    InAppBrowser.this.webView.goForward();
                }
            }
        });
        this.refreshButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                InAppBrowser.this.webView.reload();
            }
        });
        this.closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                InAppBrowser.this.activity.finish();
            }
        });
        if (this.showOpenExternalBrowserButton) {
            final String originalUrl = intent.getStringExtra(URL_EXTRA);
            this.openExternalBrowserButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    String currentUrl = InAppBrowser.this.webView.getUrl();
                    if (currentUrl == null) {
                        String msg = "The current URL is null. Reverting to the original URL for external browser.";
                        InAppBrowser.this.logger.w("The current URL is null. Reverting to the original URL for external browser.");
                        currentUrl = originalUrl;
                    }
                    InAppBrowser.this.webUtils.launchActivityForIntentLink(currentUrl, InAppBrowser.this.webView.getContext());
                }
            });
        }
    }

    private void updateNavigationButtons(WebView view) {
        if (this.browserBackButton != null && this.browserForwardButton != null) {
            if (view.canGoBack()) {
                AndroidTargetUtils.setImageButtonAlpha(this.browserBackButton, 255);
            } else {
                AndroidTargetUtils.setImageButtonAlpha(this.browserBackButton, 102);
            }
            if (view.canGoForward()) {
                AndroidTargetUtils.setImageButtonAlpha(this.browserForwardButton, 255);
            } else {
                AndroidTargetUtils.setImageButtonAlpha(this.browserForwardButton, 102);
            }
        }
    }

    private void enableCookies() {
        this.cookieManager.createCookieSyncManager((Context)this.activity);
        this.cookieManager.startSync();
    }

    protected boolean getShouldPauseWebViewTimers() {
        return this.settings.getBoolean("shouldPauseWebViewTimersInWebViewRelatedActivities", false);
    }

    protected boolean canPauseWebViewTimers() {
        return this.webView != null && this.getShouldPauseWebViewTimers();
    }

    public void onPause() {
        this.logger.d("onPause");
        this.pauseWebView();
        if (this.canPauseWebViewTimers()) {
            this.webView.pauseTimers();
        }
        this.cookieManager.stopSync();
    }

    void pauseWebView() {
        this.webView.onPause();
    }

    protected boolean canResumeWebViewTimers() {
        return this.webView != null && this.getShouldPauseWebViewTimers();
    }

    public void onResume() {
        this.logger.d("onResume");
        this.resumeWebView();
        if (this.canResumeWebViewTimers()) {
            this.webView.resumeTimers();
        }
        this.cookieManager.startSync();
    }

    void resumeWebView() {
        this.webView.onResume();
    }

    public void onStop() {
    }

    public void preOnCreate() {
    }

    void getMetrics(DisplayMetrics metrics) {
        WindowManager wm = (WindowManager)this.activity.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
    }

    public void onConfigurationChanged(Configuration configuration) {
        DisplayMetrics metrics = new DisplayMetrics();
        this.getMetrics(metrics);
        float mDensity = metrics.density;
        int buttonHeight = (int)(50.0f * mDensity + 0.5f);
        int buttonCount = this.showOpenExternalBrowserButton ? 5 : 4;
        int buttonWidth = Math.min(metrics.widthPixels / buttonCount, 2 * buttonHeight);
        this.logger.d("Width: " + metrics.widthPixels + " ButtonWidth: " + buttonWidth);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(buttonWidth, buttonHeight);
        if (this.browserBackButton != null) {
            params.addRule(9);
            params.addRule(12);
            this.browserBackButton.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        if (this.browserForwardButton != null) {
            params = new RelativeLayout.LayoutParams(buttonWidth, buttonHeight);
            params.addRule(1, this.browserBackButton.getId());
            params.addRule(12);
            this.browserForwardButton.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        if (this.closeButton != null) {
            params = new RelativeLayout.LayoutParams(buttonWidth, buttonHeight);
            params.addRule(11);
            params.addRule(12);
            this.closeButton.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        if (this.openExternalBrowserButton != null) {
            params = new RelativeLayout.LayoutParams(buttonWidth, buttonHeight);
            params.addRule(1, this.browserForwardButton.getId());
            params.addRule(12);
            this.openExternalBrowserButton.setLayoutParams((ViewGroup.LayoutParams)params);
            if (this.refreshButton != null) {
                params = new RelativeLayout.LayoutParams(buttonWidth, buttonHeight);
                params.addRule(1, this.openExternalBrowserButton.getId());
                params.addRule(12);
                this.refreshButton.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        } else if (this.refreshButton != null) {
            params = new RelativeLayout.LayoutParams(buttonWidth, buttonHeight);
            params.addRule(1, this.browserForwardButton.getId());
            params.addRule(12);
            this.refreshButton.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public boolean onBackPressed() {
        return false;
    }

    public void onWindowFocusChanged() {
    }

    public static class InAppBrowserBuilder {
        private static final String LOGTAG = InAppBrowserBuilder.class.getSimpleName();
        private final MobileAdsLogger logger;
        private final Assets assets;
        private Context context;
        private String url;
        private boolean showOpenExternalBrowserButton;

        public InAppBrowserBuilder() {
            this(Assets.getInstance(), new MobileAdsLoggerFactory());
        }

        InAppBrowserBuilder(Assets assets, MobileAdsLoggerFactory loggerFactory) {
            this.assets = assets;
            this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        }

        public InAppBrowserBuilder withContext(Context context) {
            this.context = context;
            return this;
        }

        public InAppBrowserBuilder withUrl(String url) {
            this.url = url;
            return this;
        }

        public InAppBrowserBuilder withExternalBrowserButton() {
            this.showOpenExternalBrowserButton = true;
            return this;
        }

        public void show() {
            if (this.context == null) {
                throw new IllegalArgumentException("Context must not be null");
            }
            if (StringUtils.isNullOrWhiteSpace(this.url)) {
                throw new IllegalArgumentException("Url must not be null or white space");
            }
            if (!this.assets.ensureAssetsCreated()) {
                this.logger.e("Could not load application assets, failed to open URI: %s", this.url);
                return;
            }
            Intent intent = new Intent(this.context, AdActivity.class);
            intent.putExtra("adapter", InAppBrowser.class.getName());
            intent.putExtra(InAppBrowser.URL_EXTRA, this.url);
            intent.putExtra(InAppBrowser.SHOW_OPEN_EXTERNAL_BROWSER_BTN, this.showOpenExternalBrowserButton);
            intent.addFlags(0x10000000);
            this.context.startActivity(intent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoadButtonsTask
    extends ThreadUtils.MobileAdsAsyncTask<Void, Void, Void> {
        private final ViewGroup layout;
        private final int buttonWidth;
        private final int buttonHeight;
        private final Intent intent;

        public LoadButtonsTask(Intent intent, ViewGroup layout, int buttonWidth, int buttonHeight) {
            this.intent = intent;
            this.layout = layout;
            this.buttonWidth = buttonWidth;
            this.buttonHeight = buttonHeight;
        }

        protected Void doInBackground(Void ... params) {
            InAppBrowser.this.browserBackButton = InAppBrowser.this.createButton(InAppBrowser.this.assets.getFilePath("amazon_ads_leftarrow.png"), 9, -1, this.buttonWidth, this.buttonHeight);
            InAppBrowser.this.browserBackButton.setContentDescription((CharSequence)InAppBrowser.CONTENT_DESCRIPTION_BACK_BUTTON);
            InAppBrowser.this.browserBackButton.setId(10537);
            InAppBrowser.this.browserForwardButton = InAppBrowser.this.createButton(InAppBrowser.this.assets.getFilePath("amazon_ads_rightarrow.png"), 1, InAppBrowser.this.browserBackButton.getId(), this.buttonWidth, this.buttonHeight);
            InAppBrowser.this.browserForwardButton.setContentDescription((CharSequence)InAppBrowser.CONTENT_DESCRIPTION_FORWARD_BUTTON);
            InAppBrowser.this.browserForwardButton.setId(10794);
            InAppBrowser.this.closeButton = InAppBrowser.this.createButton(InAppBrowser.this.assets.getFilePath("amazon_ads_close.png"), 11, -1, this.buttonWidth, this.buttonHeight);
            InAppBrowser.this.closeButton.setContentDescription((CharSequence)InAppBrowser.CONTENT_DESCRIPTION_CLOSE_BUTTON);
            if (InAppBrowser.this.showOpenExternalBrowserButton) {
                InAppBrowser.this.openExternalBrowserButton = InAppBrowser.this.createButton(InAppBrowser.this.assets.getFilePath("amazon_ads_open_external_browser.png"), 1, InAppBrowser.this.browserForwardButton.getId(), this.buttonWidth, this.buttonHeight);
                InAppBrowser.this.openExternalBrowserButton.setContentDescription((CharSequence)InAppBrowser.CONTENT_DESCRIPTION_OPEN_EXT_BRWSR_BUTTON);
                InAppBrowser.this.openExternalBrowserButton.setId(10795);
                InAppBrowser.this.refreshButton = InAppBrowser.this.createButton(InAppBrowser.this.assets.getFilePath("amazon_ads_refresh.png"), 1, InAppBrowser.this.openExternalBrowserButton.getId(), this.buttonWidth, this.buttonHeight);
            } else {
                InAppBrowser.this.refreshButton = InAppBrowser.this.createButton(InAppBrowser.this.assets.getFilePath("amazon_ads_refresh.png"), 1, InAppBrowser.this.browserForwardButton.getId(), this.buttonWidth, this.buttonHeight);
            }
            InAppBrowser.this.refreshButton.setContentDescription((CharSequence)InAppBrowser.CONTENT_DESCRIPTION_REFRESH_BUTTON);
            return null;
        }

        @Override
        protected void onPostExecute(Void param) {
            this.layout.addView((View)InAppBrowser.this.browserBackButton);
            this.layout.addView((View)InAppBrowser.this.browserForwardButton);
            this.layout.addView((View)InAppBrowser.this.refreshButton);
            this.layout.addView((View)InAppBrowser.this.closeButton);
            if (InAppBrowser.this.showOpenExternalBrowserButton) {
                this.layout.addView((View)InAppBrowser.this.openExternalBrowserButton);
            }
            InAppBrowser.this.initializeButtons(this.intent);
            InAppBrowser.this.buttonsCreated.set(true);
        }
    }
}

