/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

abstract class FileHandler
implements Closeable {
    private static final String LOGTAG = FileHandler.class.getSimpleName();
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    File file;

    FileHandler() {
    }

    public boolean setFile(File parent, String child) {
        return this.setFile(new File(parent, child));
    }

    public boolean setFile(String fileName) {
        return this.setFile(new File(fileName));
    }

    public boolean setFile(File file) {
        if (this.isFileSet()) {
            if (file.getAbsolutePath().equals(this.file.getAbsolutePath())) {
                return true;
            }
            this.logger.e("Another file is already set in this FileOutputHandler. Close the other file before opening a new one.");
            return false;
        }
        this.file = file;
        return true;
    }

    public boolean isFileSet() {
        return this.file != null;
    }

    public long getFileLength() {
        if (!this.isFileSet()) {
            throw new IllegalStateException("A file has not been set, yet.");
        }
        return this.file.length();
    }

    public boolean doesFileExist() {
        if (!this.isFileSet()) {
            throw new IllegalStateException("A file has not been set, yet.");
        }
        return this.file.exists();
    }

    public abstract boolean isOpen();

    public abstract void close();

    protected void closeCloseables() {
        Closeable readerWriter = this.getCloseableReaderWriter();
        if (readerWriter != null) {
            try {
                readerWriter.close();
            }
            catch (IOException e) {
                this.logger.e("Could not close the %s. %s", readerWriter.getClass().getSimpleName(), e.getMessage());
                this.closeStream();
            }
        } else {
            this.closeStream();
        }
    }

    private void closeStream() {
        Closeable stream = this.getCloseableStream();
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                this.logger.e("Could not close the stream. %s", e.getMessage());
            }
        }
    }

    protected abstract Closeable getCloseableStream();

    protected abstract Closeable getCloseableReaderWriter();
}

