/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.amazon.device.ads.AdControlAccessor;
import com.amazon.device.ads.AdSDKBridge;
import com.amazon.device.ads.AdSDKBridgeFactory;
import com.amazon.device.ads.AdSDKBridgeList;
import com.amazon.device.ads.AmazonDeviceLauncher;
import com.amazon.device.ads.AndroidBuildInfo;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.BridgeSelector;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.WebUtils;
import com.amazon.device.ads.WebUtils2;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

class AdWebViewClient
extends WebViewClient {
    private static final String LOGTAG = AdWebViewClient.class.getSimpleName();
    protected static final String AAX_REDIRECT_PROD = "aax-us-east.amazon-adsystem.com";
    protected static final String AAX_REDIRECT_GAMMA = "aax-us-east.amazon-adsystem.com";
    protected static final String AAX_REDIRECT_BETA = "aax-beta.integ.amazon.com";
    protected static final String CORNERSTONE_BEST_ENDPOINT_PROD = "pda-bes.amazon.com";
    protected static final String CORNERSTONE_BEST_ENDPOINT_BETA = "d16g-cornerstone-bes.integ.amazon.com";
    public static final String AMAZON_MOBILE = "amazonmobile";
    public static final String TELEPHONE = "tel";
    public static final String VOICEMAIL = "voicemail";
    public static final String SMS = "sms";
    public static final String MAILTO = "mailto";
    public static final String GEO = "geo";
    public static final String GOOGLE_STREETVIEW = "google.streetview";
    protected static final HashSet<String> intentSchemes = new HashSet();
    private final WebUtils2 webUtils;
    private final MobileAdsLoggerFactory loggerFactory;
    private final MobileAdsLogger logger;
    private final Context context;
    private final HashMap<String, UrlExecutor> urlExecutors;
    private AdWebViewClientListener listener;
    private final AdSDKBridgeList bridgeList;
    private final AdControlAccessor adControlAccessor;
    private final AndroidBuildInfo androidBuildInfo;
    private CopyOnWriteArrayList<String> resourceList = new CopyOnWriteArrayList();
    protected static Set<String> redirectHosts;

    public AdWebViewClient(Context context, AdSDKBridgeList bridgeList, AdControlAccessor adControlAccessor, WebUtils2 webUtils, MobileAdsLoggerFactory loggerFactory, AndroidBuildInfo androidBuildInfo) {
        this.context = context;
        this.urlExecutors = new HashMap();
        this.bridgeList = bridgeList;
        this.adControlAccessor = adControlAccessor;
        this.webUtils = webUtils;
        this.loggerFactory = loggerFactory;
        this.logger = this.loggerFactory.createMobileAdsLogger(LOGTAG);
        this.androidBuildInfo = androidBuildInfo;
        this.setupUrlExecutors();
    }

    public void setListener(AdWebViewClientListener listener) {
        this.listener = listener;
    }

    private void setupUrlExecutors() {
        this.urlExecutors.put(AMAZON_MOBILE, new AmazonMobileExecutor(this.context, this.loggerFactory, new AmazonDeviceLauncher(), this.webUtils));
        DefaultExecutor intentExecutor = new DefaultExecutor(this.context);
        for (String scheme : intentSchemes) {
            this.putUrlExecutor(scheme, intentExecutor);
        }
    }

    public void putUrlExecutor(String scheme, UrlExecutor executor) {
        this.urlExecutors.put(scheme, executor);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        this.logger.e("Error: %s", description);
        super.onReceivedError(view, errorCode, description, failingUrl);
        this.listener.onReceivedError(view, errorCode, description, failingUrl);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        return this.openUrl(url);
    }

    public boolean openUrl(String url) {
        Uri uri = Uri.parse((String)url);
        boolean ret = true;
        if (redirectHosts.contains(uri.getHost()) && !this.isHoneycombVersion()) {
            ret = false;
        }
        if (this.interpretScheme(url, this.getScheme(url))) {
            return true;
        }
        return ret;
    }

    protected String getScheme(String url) {
        return this.webUtils.getScheme(url);
    }

    protected boolean interpretScheme(String url, String scheme) {
        if (scheme != null) {
            if (scheme.equals("about") && url.equalsIgnoreCase("about:blank")) {
                return false;
            }
            if (this.urlExecutors.containsKey(scheme)) {
                return this.urlExecutors.get(scheme).execute(url);
            }
            this.logger.d("Scheme %s unrecognized. Launching as intent.", scheme);
            return this.webUtils.launchActivityForIntentLink(url, this.context);
        }
        return false;
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.listener.onPageStarted(view, url);
    }

    public void onPageFinished(WebView view, String url) {
        this.logger.d("Page Finished %s", url);
        if (this.checkResources()) {
            return;
        }
        if (this.listener == null) {
            this.logger.w("Call to onPageFinished() ignored because listener is null.");
            return;
        }
        this.listener.onPageFinished(view, url);
    }

    public void onLoadResource(WebView view, String url) {
        this.resourceList.add(url);
        this.logger.d("Loading resource: %s", url);
        this.listener.onLoadResource(view, url);
    }

    private boolean checkResources() {
        boolean shouldReload = false;
        for (String resource : this.resourceList) {
            Set<AdSDKBridgeFactory> bridges = BridgeSelector.getInstance().getBridgeFactoriesForResourceLoad(resource);
            if (bridges.size() <= 0) continue;
            for (AdSDKBridgeFactory factory : bridges) {
                AdSDKBridge bridge = factory.createAdSDKBridge(this.adControlAccessor);
                if (this.bridgeList.contains(bridge)) continue;
                shouldReload = true;
                this.bridgeList.addBridge(bridge);
            }
        }
        if (shouldReload) {
            ThreadUtils.executeOnMainThread(new Runnable(){

                public void run() {
                    AdWebViewClient.this.adControlAccessor.reload();
                }
            });
        }
        return shouldReload;
    }

    boolean isHoneycombVersion() {
        return AndroidTargetUtils.isBetweenAndroidAPIs(this.androidBuildInfo, 11, 13);
    }

    static {
        intentSchemes.add(TELEPHONE);
        intentSchemes.add(VOICEMAIL);
        intentSchemes.add(SMS);
        intentSchemes.add(MAILTO);
        intentSchemes.add(GEO);
        intentSchemes.add(GOOGLE_STREETVIEW);
        redirectHosts = new HashSet<String>();
        redirectHosts.add("aax-us-east.amazon-adsystem.com");
        redirectHosts.add("aax-us-east.amazon-adsystem.com");
        redirectHosts.add(AAX_REDIRECT_BETA);
        redirectHosts.add(CORNERSTONE_BEST_ENDPOINT_PROD);
        redirectHosts.add(CORNERSTONE_BEST_ENDPOINT_BETA);
    }

    static interface AdWebViewClientListener {
        public void onPageFinished(WebView var1, String var2);

        public void onPageStarted(WebView var1, String var2);

        public void onLoadResource(WebView var1, String var2);

        public void onReceivedError(WebView var1, int var2, String var3, String var4);
    }

    static class DefaultExecutor
    implements UrlExecutor {
        private final Context context;

        public DefaultExecutor(Context context) {
            this.context = context;
        }

        public boolean execute(String url) {
            WebUtils.launchActivityForIntentLink(url, this.context);
            return true;
        }
    }

    static class AmazonMobileExecutor
    implements UrlExecutor {
        private final Context context;
        private final AmazonDeviceLauncher launcher;
        private final MobileAdsLogger logger;
        private final WebUtils2 webUtils;

        AmazonMobileExecutor(Context context) {
            this(context, new MobileAdsLoggerFactory(), new AmazonDeviceLauncher(), new WebUtils2());
        }

        AmazonMobileExecutor(Context context, MobileAdsLoggerFactory loggerFactory, AmazonDeviceLauncher launcher, WebUtils2 webUtils) {
            this.context = context;
            this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
            this.launcher = launcher;
            this.webUtils = webUtils;
        }

        public boolean execute(String url) {
            this.specialUrlClicked(url);
            return true;
        }

        public void specialUrlClicked(String url) {
            this.logger.d("Executing AmazonMobile Intent");
            Uri uri = Uri.parse((String)url);
            List intents = null;
            try {
                intents = uri.getQueryParameters("intent");
            }
            catch (UnsupportedOperationException e) {
                intents = null;
            }
            if (intents != null && intents.size() > 0) {
                for (String intent : intents) {
                    if (!this.launchExternalActivity(intent)) continue;
                    return;
                }
                this.handleApplicationDefinedSpecialURL(url);
            } else if (this.launcher.isWindowshopPresent(this.context) && !this.launcher.isInWindowshopApp(this.context)) {
                if (uri.getHost().equals("shopping")) {
                    String action = uri.getQueryParameter("app-action");
                    if (action == null || action.length() == 0) {
                        return;
                    }
                    if (action.equals("detail")) {
                        String asin = uri.getQueryParameter("asin");
                        if (asin == null || asin.length() == 0) {
                            return;
                        }
                        this.launcher.launchWindowshopDetailPage(this.context, asin);
                    } else if (action.equals("search")) {
                        String keyword = uri.getQueryParameter("keyword");
                        if (keyword == null || keyword.length() == 0) {
                            return;
                        }
                        this.launcher.launchWindowshopSearchPage(this.context, keyword);
                    } else if (action.equals("webview")) {
                        this.handleApplicationDefinedSpecialURL(url);
                    }
                }
            } else {
                this.handleApplicationDefinedSpecialURL(url);
            }
        }

        protected void handleApplicationDefinedSpecialURL(String url) {
            this.logger.i("Special url clicked, but was not handled by SDK. Url: %s", url);
        }

        protected boolean launchExternalActivity(String url) {
            return this.webUtils.launchActivityForIntentLink(url, this.context);
        }
    }

    static interface UrlExecutor {
        public boolean execute(String var1);
    }
}

