/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.os.AsyncTask;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.WebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdMetricsSubmitAaxTask
extends AsyncTask<WebRequest, Void, Void> {
    private static final String LOGTAG = AdMetricsSubmitAaxTask.class.getSimpleName();
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);

    AdMetricsSubmitAaxTask() {
    }

    public Void doInBackground(WebRequest ... webRequests) {
        block8: for (WebRequest webRequest : webRequests) {
            try {
                webRequest.makeCall();
            }
            catch (WebRequest.WebRequestException e) {
                switch (e.getStatus()) {
                    case INVALID_CLIENT_PROTOCOL: {
                        this.logger.e("Unable to submit metrics for ad due to an Invalid Client Protocol, msg: %s", e.getMessage());
                        continue block8;
                    }
                    case NETWORK_FAILURE: {
                        this.logger.e("Unable to submit metrics for ad due to Network Failure, msg: %s", e.getMessage());
                        continue block8;
                    }
                    case MALFORMED_URL: {
                        this.logger.e("Unable to submit metrics for ad due to a Malformed Pixel URL, msg: %s", e.getMessage());
                    }
                    case UNSUPPORTED_ENCODING: {
                        this.logger.e("Unable to submit metrics for ad because of unsupported character encoding, msg: %s", e.getMessage());
                        continue block8;
                    }
                }
            }
        }
        return null;
    }
}

