package com.aliyun.core.tracing;

import io.opentelemetry.api.common.AttributeKey;


public final class AttributeKeys {
    private void AwsAttributeKeys() {
    }

    static final AttributeKey<String> ALIBABA_CLOUD_SERVICE =
            AttributeKey.stringKey("alibaba.cloud.service");

    /**
     * API name.
     */
    static final AttributeKey<String> ALIBABA_CLOUD_ACTION =
            AttributeKey.stringKey("alibaba.cloud.action");

    /**
     * API version.
     */
    static final AttributeKey<String> ALIBABA_CLOUD_API_VERSION =
            AttributeKey.stringKey("alibaba.cloud.api_version");

    /**
     * The request id.
     */
    static final AttributeKey<String> ALIBABA_CLOUD_REQUEST_ID =
            AttributeKey.stringKey("alibaba.cloud.request_id");

    /**
     * AlibabaCloud signature version for request.
     */
    static final AttributeKey<String> ALIBABA_CLOUD_SIGNATURE_VERSION =
            AttributeKey.stringKey("alibaba.cloud.signature_version");

    /**
     * AlibabaCloud resource type.
     */
    static final AttributeKey<String> ALIBABA_CLOUD_RESOURCE_TYPE =
            AttributeKey.stringKey("alibaba.cloud.resource.type");

//    static final AttributeKey<String> ALIBABA_CLOUD_BUCKET_NAME =
//            AttributeKey.stringKey("alibaba.cloud.bucket.name");

    /**
     * Describes a class of error the operation ended with, like timeout; java.net.UnknownHostException; server_certificate_invalid; 500
     */
    static final AttributeKey<String> ALIBABA_CLOUD_ERROR_TYPE =
            AttributeKey.stringKey("alibaba.cloud.error.type");

    /**
     * AlibabaCloud Error Code.
     */
    static final AttributeKey<String> ALIBABA_CLOUD_ERROR_CODE =
            AttributeKey.stringKey("alibaba.cloud.error.code");

    static final AttributeKey<String> ALIBABA_CLOUD_USER_AGENT =
            AttributeKey.stringKey("alibaba.cloud.user_agent");

    /**
     * HTTP request method, like GET; POST; HEAD
     */
    static final AttributeKey<String> ALIBABA_CLOUD_HTTP_REQUEST_METHOD =
            AttributeKey.stringKey("http.request.method");

    /**
     * The HTTP protocol version, like 1.1.
     */
    static final AttributeKey<String> ALIBABA_CLOUD_NETWORK_PROTOCOL_VERSION =
            AttributeKey.stringKey("network.protocol.version");

    /**
     * The ordinal number of request resending attempt (for any reason, including redirects).
     */
    static final AttributeKey<String> ALIBABA_CLOUD_HTTP_REQUEST_RESEND_COUNT =
            AttributeKey.stringKey("http.request.resend_count");

    static final AttributeKey<String> ALIBABA_CLOUD_HTTP_RESPONSE_STATUS_CODE =
            AttributeKey.stringKey("http.response.status_code");

    static final AttributeKey<String> ALIBABA_CLOUD_HTTP_REQUEST_RETRY_ATTEMPTS =
            AttributeKey.stringKey("http.request.retry.attempts");

    static final AttributeKey<String> ALIBABA_CLOUD_HTTP_REQUEST_RETRY_BACKOFF =
            AttributeKey.stringKey("http.request.retry.backoff");

    static final AttributeKey<String> ALIBABA_CLOUD_SERVER_ADDRESS =
            AttributeKey.stringKey("server.address");

    static final AttributeKey<String> ALIBABA_CLOUD_SERVER_PORT =
            AttributeKey.stringKey("server.port");

    /**
     * Absolute URL describing a network resource according to RFC3986
     */
    static final AttributeKey<String> ALIBABA_CLOUD_URL_FULL =
            AttributeKey.stringKey("url.full");

    static final AttributeKey<String> ALIBABA_CLOUD_CLIENT_ADDRESS =
            AttributeKey.stringKey("client.address");
}
