/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package com.alibaba.sdk.android.oss.common;

public final class RequestParameters {

    public static final String SUBRESOURCE_BUCKETINFO = "bucketInfo";
    public static final String SUBRESOURCE_ACL = "acl";
    public static final String SUBRESOURCE_REFERER = "referer";
    public static final String SUBRESOURCE_LOCATION = "location";
    public static final String SUBRESOURCE_LOGGING = "logging";
    public static final String SUBRESOURCE_WEBSITE = "website";
    public static final String SUBRESOURCE_LIFECYCLE = "lifecycle";
    public static final String SUBRESOURCE_UPLOADS = "uploads";
    public static final String SUBRESOURCE_DELETE = "delete";
    public static final String SUBRESOURCE_CORS = "cors";
    public static final String SUBRESOURCE_APPEND = "append";
    public static final String SUBRESOURCE_SEQUENTIAL = "sequential";


    public static final String PREFIX = "prefix";
    public static final String DELIMITER = "delimiter";
    public static final String MARKER = "marker";
    public static final String MAX_KEYS = "max-keys";
    public static final String ENCODING_TYPE = "encoding-type";

    public static final String UPLOAD_ID = "uploadId";
    public static final String PART_NUMBER = "partNumber";
    public static final String MAX_UPLOADS = "max-uploads";
    public static final String UPLOAD_ID_MARKER = "upload-id-marker";
    public static final String KEY_MARKER = "key-marker";
    public static final String MAX_PARTS = "max-parts";
    public static final String PART_NUMBER_MARKER = "part-number-marker";


    public static final String SIGNATURE = "Signature";
    public static final String OSS_ACCESS_KEY_ID = "OSSAccessKeyId";

    public static final String SECURITY_TOKEN = "security-token";

    public static final String POSITION = "position";

    public static final String RESPONSE_HEADER_CONTENT_TYPE = "response-content-type";
    public static final String RESPONSE_HEADER_CONTENT_LANGUAGE = "response-content-language";
    public static final String RESPONSE_HEADER_EXPIRES = "response-expires";
    public static final String RESPONSE_HEADER_CACHE_CONTROL = "response-cache-control";
    public static final String RESPONSE_HEADER_CONTENT_DISPOSITION = "response-content-disposition";
    public static final String RESPONSE_HEADER_CONTENT_ENCODING = "response-content-encoding";

    public static final String X_OSS_PROCESS = "x-oss-process";

    public static final String X_OSS_SYMLINK = "symlink";

    public static final String X_OSS_RESTORE = "restore";
}
