/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring6.webservlet.view;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.AbstractView;

public class FastJsonJsonView
extends AbstractView {
    private Set<String> renderedAttributes;
    private boolean disableCaching = true;
    private boolean extractValueFromSingleKeyModel;
    private FastJsonConfig config = new FastJsonConfig();

    public FastJsonJsonView() {
        this.setContentType("application/json");
        this.setExposePathVariables(false);
    }

    public FastJsonConfig getFastJsonConfig() {
        return this.config;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.config = fastJsonConfig;
    }

    public void setRenderedAttributes(Set<String> renderedAttributes) {
        this.renderedAttributes = renderedAttributes;
    }

    public boolean isExtractValueFromSingleKeyModel() {
        return this.extractValueFromSingleKeyModel;
    }

    public void setExtractValueFromSingleKeyModel(boolean extractValueFromSingleKeyModel) {
        this.extractValueFromSingleKeyModel = extractValueFromSingleKeyModel;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object value = this.filterModel(model);
        ServletOutputStream out = response.getOutputStream();
        int len = JSON.writeTo((OutputStream)out, (Object)value, (String)this.config.getDateFormat(), (Filter[])this.config.getWriterFilters(), (JSONWriter.Feature[])this.config.getWriterFeatures());
        if (this.config.isWriteContentLength()) {
            response.setContentLength(len);
        }
    }

    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        this.setResponseContentType(request, response);
        response.setCharacterEncoding(this.config.getCharset().name());
        if (this.disableCaching) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache, no-store, max-age=0");
            response.addDateHeader("Expires", 1L);
        }
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    public void setUpdateContentLength(boolean updateContentLength) {
        this.config.setWriteContentLength(updateContentLength);
    }

    protected Object filterModel(Map<String, Object> model) {
        Map.Entry<String, Object> entry;
        HashMap<String, Object> result = new HashMap<String, Object>(model.size());
        Set<String> renderedAttributes = !CollectionUtils.isEmpty(this.renderedAttributes) ? this.renderedAttributes : model.keySet();
        Iterator<Map.Entry<String, Object>> iterator = model.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry.getValue() instanceof BindingResult || !renderedAttributes.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        if (this.extractValueFromSingleKeyModel && result.size() == 1 && (iterator = result.entrySet().iterator()).hasNext()) {
            entry = iterator.next();
            return entry.getValue();
        }
        return result;
    }

    protected void setResponseContentType(HttpServletRequest request, HttpServletResponse response) {
        super.setResponseContentType(request, response);
    }
}

