/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.insights.webservice;

import com.algolia.instantsearch.insights.converter.ConverterParameterToString;
import com.algolia.instantsearch.insights.event.Event;
import com.algolia.instantsearch.insights.event.EventType;
import com.algolia.instantsearch.insights.webservice.WebService;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/algolia/instantsearch/insights/webservice/WebServiceHttp;", "Lcom/algolia/instantsearch/insights/webservice/WebService;", "appId", "", "apiKey", "environment", "Lcom/algolia/instantsearch/insights/webservice/WebServiceHttp$Environment;", "connectTimeoutInMilliseconds", "", "readTimeoutInMilliseconds", "(Ljava/lang/String;Ljava/lang/String;Lcom/algolia/instantsearch/insights/webservice/WebServiceHttp$Environment;II)V", "sendEvent", "Lcom/algolia/instantsearch/insights/webservice/WebService$Response;", "event", "Lcom/algolia/instantsearch/insights/event/Event;", "Environment", "com.algolia.instantsearch-android.insights"})
public final class WebServiceHttp
implements WebService {
    private final String appId;
    private final String apiKey;
    private final Environment environment;
    private final int connectTimeoutInMilliseconds;
    private final int readTimeoutInMilliseconds;

    @Override
    @NotNull
    public WebService.Response sendEvent(@NotNull Event event) {
        String string;
        Object object;
        EventType eventType;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Event event2 = event;
        if (event2 instanceof Event.Click) {
            eventType = EventType.Click;
        } else if (event2 instanceof Event.View) {
            eventType = EventType.View;
        } else if (event2 instanceof Event.Conversion) {
            eventType = EventType.Conversion;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        EventType eventType2 = eventType;
        String string2 = ConverterParameterToString.INSTANCE.convert(event.getParams());
        URL url = new URL(this.environment.buildUrl(eventType2));
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        Object it = object = (HttpURLConnection)uRLConnection;
        ((URLConnection)it).setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        ((URLConnection)it).setRequestProperty("Accept", "application/json");
        ((URLConnection)it).setRequestProperty("X-Algolia-Application-Id", this.appId);
        ((URLConnection)it).setRequestProperty("X-Algolia-API-Key", this.apiKey);
        ((URLConnection)it).setRequestProperty("Content-Length", String.valueOf(string2.length()));
        ((HttpURLConnection)it).setRequestMethod("POST");
        ((URLConnection)it).setConnectTimeout(this.connectTimeoutInMilliseconds);
        ((URLConnection)it).setReadTimeout(this.readTimeoutInMilliseconds);
        ((URLConnection)it).setDoOutput(true);
        ((URLConnection)it).setUseCaches(false);
        HttpURLConnection connection = object;
        object = string2;
        OutputStream outputStream = connection.getOutputStream();
        it = Charsets.UTF_8;
        Object object2 = object;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = ((String)object2).getBytes((Charset)it);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        outputStream.write(byArray2);
        int responseCode = connection.getResponseCode();
        InputStream inputStream = connection.getErrorStream();
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Closeable closeable = inputStream2;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            int n = 8192;
            string = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
        } else {
            string = null;
        }
        String errorMessage = string;
        connection.disconnect();
        return new WebService.Response(errorMessage, responseCode);
    }

    public WebServiceHttp(@NotNull String appId, @NotNull String apiKey, @NotNull Environment environment, int connectTimeoutInMilliseconds, int readTimeoutInMilliseconds) {
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        this.appId = appId;
        this.apiKey = apiKey;
        this.environment = environment;
        this.connectTimeoutInMilliseconds = connectTimeoutInMilliseconds;
        this.readTimeoutInMilliseconds = readTimeoutInMilliseconds;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/algolia/instantsearch/insights/webservice/WebServiceHttp$Environment;", "", "baseUrl", "", "(Ljava/lang/String;ILjava/lang/String;)V", "buildUrl", "eventType", "Lcom/algolia/instantsearch/insights/event/EventType;", "Prod", "Debug", "com.algolia.instantsearch-android.insights"})
    public static final class Environment
    extends Enum<Environment> {
        public static final /* enum */ Environment Prod;
        public static final /* enum */ Environment Debug;
        private static final /* synthetic */ Environment[] $VALUES;
        private final String baseUrl;

        static {
            Environment[] environmentArray = new Environment[2];
            Environment[] environmentArray2 = environmentArray;
            environmentArray[0] = Prod = new Environment("https://insights.algolia.io");
            environmentArray[1] = Debug = new Environment("http://localhost:8080");
            $VALUES = environmentArray;
        }

        @NotNull
        public final String buildUrl(@NotNull EventType eventType) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)eventType), (String)"eventType");
            return this.baseUrl + "/1/searches/" + eventType.getRoute();
        }

        protected Environment(String baseUrl) {
            Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
            this.baseUrl = baseUrl;
        }

        public static Environment[] values() {
            return (Environment[])$VALUES.clone();
        }

        public static Environment valueOf(String string) {
            return Enum.valueOf(Environment.class, string);
        }
    }
}

