/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.objects;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class RequestOptions
implements Serializable {
    public static final RequestOptions empty = new RequestOptions();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, String> queryParams = new HashMap<String, String>();
    private String forwardedFor;

    public String getForwardedFor() {
        return this.forwardedFor;
    }

    public RequestOptions setForwardedFor(@Nonnull String forwardedFor) {
        this.forwardedFor = forwardedFor;
        return this;
    }

    public RequestOptions addExtraHeader(@Nonnull String key, @Nonnull String value) {
        this.headers.put(key, value);
        return this;
    }

    public RequestOptions addExtraQueryParameters(@Nonnull String key, @Nonnull String value) {
        this.queryParams.put(key, value);
        return this;
    }

    public Map<String, String> generateExtraHeaders() {
        if (this.forwardedFor != null) {
            this.headers.put("X-Forwarded-For", this.forwardedFor);
        }
        return this.headers;
    }

    public Map<String, String> generateExtraQueryParams() {
        return this.queryParams;
    }

    public String toString() {
        return "RequestOptions{headers=" + this.headers + ", queryParams=" + this.queryParams + ", forwardedFor='" + this.forwardedFor + '\'' + '}';
    }
}

