/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SyncBaseIndex;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.inputs.synonym.AbstractSynonym;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.SynonymQuery;
import com.algolia.search.objects.tasks.sync.Task;
import com.algolia.search.responses.SearchSynonymResult;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface SyncSynonyms<T>
extends SyncBaseIndex<T> {
    default public Task saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content) throws AlgoliaException {
        return this.saveSynonym(synonymID, content, false, RequestOptions.empty);
    }

    default public Task saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.saveSynonym(synonymID, content, false, requestOptions);
    }

    default public Task saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, boolean forwardToReplicas) throws AlgoliaException {
        return this.saveSynonym(synonymID, content, forwardToReplicas, RequestOptions.empty);
    }

    default public Task saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().saveSynonym(this.getName(), synonymID, content, forwardToReplicas, requestOptions);
    }

    default public Optional<AbstractSynonym> getSynonym(@Nonnull String synonymID) throws AlgoliaException {
        return this.getSynonym(synonymID, RequestOptions.empty);
    }

    default public Optional<AbstractSynonym> getSynonym(@Nonnull String synonymID, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().getSynonym(this.getName(), synonymID, requestOptions);
    }

    default public Task deleteSynonym(@Nonnull String synonymID) throws AlgoliaException {
        return this.deleteSynonym(synonymID, false);
    }

    default public Task deleteSynonym(@Nonnull String synonymID, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.deleteSynonym(synonymID, false, requestOptions);
    }

    default public Task deleteSynonym(@Nonnull String synonymID, boolean forwardToReplicas) throws AlgoliaException {
        return this.deleteSynonym(synonymID, forwardToReplicas, RequestOptions.empty);
    }

    default public Task deleteSynonym(@Nonnull String synonymID, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().deleteSynonym(this.getName(), synonymID, forwardToReplicas, requestOptions);
    }

    default public Task clearSynonyms() throws AlgoliaException {
        return this.clearSynonyms(false);
    }

    default public Task clearSynonyms(@Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.clearSynonyms(false, requestOptions);
    }

    default public Task clearSynonyms(boolean forwardToReplicas) throws AlgoliaException {
        return this.clearSynonyms(forwardToReplicas, RequestOptions.empty);
    }

    default public Task clearSynonyms(boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().clearSynonyms(this.getName(), forwardToReplicas, requestOptions);
    }

    default public SearchSynonymResult searchSynonyms(@Nonnull SynonymQuery query) throws AlgoliaException {
        return this.searchSynonyms(query, RequestOptions.empty);
    }

    default public SearchSynonymResult searchSynonyms(@Nonnull SynonymQuery query, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().searchSynonyms(this.getName(), query, requestOptions);
    }

    default public Task batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas, boolean replaceExistingSynonyms) throws AlgoliaException {
        return this.batchSynonyms(synonyms, forwardToReplicas, replaceExistingSynonyms, RequestOptions.empty);
    }

    default public Task batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas, boolean replaceExistingSynonyms, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().batchSynonyms(this.getName(), synonyms, forwardToReplicas, replaceExistingSynonyms, requestOptions);
    }

    default public Task batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas) throws AlgoliaException {
        return this.batchSynonyms(synonyms, forwardToReplicas, false);
    }

    default public Task batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.batchSynonyms(synonyms, forwardToReplicas, false, requestOptions);
    }

    default public Task batchSynonyms(@Nonnull List<AbstractSynonym> synonyms) throws AlgoliaException {
        return this.batchSynonyms(synonyms, false, false);
    }

    default public Task batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.batchSynonyms(synonyms, false, false, requestOptions);
    }
}

