/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClient;
import com.algolia.search.APIClientConfiguration;
import com.algolia.search.GenericAPIClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class APIClientBuilder
extends GenericAPIClientBuilder {
    public APIClientBuilder(@Nonnull String applicationId, @Nonnull String apiKey) {
        super(applicationId, apiKey);
    }

    @Override
    public APIClientBuilder setUserAgent(@Nonnull String customAgent, @Nonnull String customAgentVersion) {
        super.setUserAgent(customAgent, customAgentVersion);
        return this;
    }

    @Override
    public APIClientBuilder setExtraHeader(@Nonnull String key, String value) {
        super.addExtraHeader(key, value);
        return this;
    }

    @Override
    public GenericAPIClientBuilder addExtraHeader(@Nonnull String key, String value) {
        return super.addExtraHeader(key, value);
    }

    @Override
    public APIClientBuilder setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public APIClientBuilder setReadTimeout(int readTimeout) {
        super.setReadTimeout(readTimeout);
        return this;
    }

    @Override
    public APIClientBuilder setHostDownTimeout(int hostDownTimeout) {
        super.setHostDownTimeout(hostDownTimeout);
        return this;
    }

    @Override
    public APIClientBuilder setObjectMapper(@Nonnull ObjectMapper objectMapper) {
        super.setObjectMapper(objectMapper);
        return this;
    }

    @Override
    public APIClientBuilder setQueryHosts(List<String> queryHosts) {
        super.setQueryHosts(queryHosts);
        return this;
    }

    @Override
    public APIClientBuilder setBuildHosts(List<String> buildHosts) {
        super.setBuildHosts(buildHosts);
        return this;
    }

    @Override
    public APIClientBuilder setMaxConnTotal(int maxConnTotal) {
        super.setMaxConnTotal(maxConnTotal);
        return this;
    }

    protected abstract APIClient build(@Nonnull APIClientConfiguration var1);

    public APIClient build() {
        return this.build(new APIClientConfiguration().setApplicationId(this.applicationId).setApiKey(this.apiKey).setObjectMapper(this.objectMapper).setBuildHosts(this.generateBuildHosts()).setQueryHosts(this.generateQueryHosts()).setHeaders(this.generateHeaders()).setConnectTimeout(this.connectTimeout).setReadTimeout(this.readTimeout).setHostDownTimeout(this.hostDownTimeout).setMaxConnTotal(this.maxConnTotal));
    }
}

