/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.BaseSyncIndex;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.objects.ApiKey;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.responses.CreateUpdateKey;
import com.algolia.search.responses.DeleteKey;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

interface Key<T>
extends BaseSyncIndex<T> {
    @Deprecated
    default public List<ApiKey> listKeys() throws AlgoliaException {
        return this.listApiKeys();
    }

    default public List<ApiKey> listApiKeys() throws AlgoliaException {
        return this.listApiKeys(RequestOptions.empty);
    }

    default public List<ApiKey> listApiKeys(@Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().listKeys(this.getName(), requestOptions);
    }

    @Deprecated
    default public Optional<ApiKey> getKey(@Nonnull String key) throws AlgoliaException {
        return this.getApiKey(key);
    }

    default public Optional<ApiKey> getApiKey(@Nonnull String key) throws AlgoliaException {
        return this.getApiKey(key, RequestOptions.empty);
    }

    default public Optional<ApiKey> getApiKey(@Nonnull String key, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().getKey(this.getName(), key, requestOptions);
    }

    @Deprecated
    default public DeleteKey deleteKey(@Nonnull String key) throws AlgoliaException {
        return this.deleteApiKey(key);
    }

    default public DeleteKey deleteApiKey(@Nonnull String key) throws AlgoliaException {
        return this.deleteApiKey(key, RequestOptions.empty);
    }

    default public DeleteKey deleteApiKey(@Nonnull String key, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().deleteKey(this.getName(), key, requestOptions);
    }

    @Deprecated
    default public CreateUpdateKey addKey(@Nonnull ApiKey key) throws AlgoliaException {
        return this.addApiKey(key);
    }

    default public CreateUpdateKey addApiKey(@Nonnull ApiKey key) throws AlgoliaException {
        return this.addApiKey(key, RequestOptions.empty);
    }

    default public CreateUpdateKey addApiKey(@Nonnull ApiKey key, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().addKey(this.getName(), key, requestOptions);
    }

    default public CreateUpdateKey updateKey(@Nonnull String keyName, @Nonnull ApiKey key) throws AlgoliaException {
        return this.updateKey(keyName, key, RequestOptions.empty);
    }

    default public CreateUpdateKey updateKey(@Nonnull String keyName, @Nonnull ApiKey key, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().updateKey(this.getName(), keyName, key, requestOptions);
    }
}

