/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.simplelist;

import android.content.Context;
import android.graphics.PorterDuff;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.commons.R;
import com.afollestad.materialdialogs.internal.MDAdapter;
import com.afollestad.materialdialogs.simplelist.MaterialSimpleListItem;
import java.util.ArrayList;
import java.util.List;

public class MaterialSimpleListAdapter
extends RecyclerView.Adapter<SimpleListVH>
implements MDAdapter {
    private MaterialDialog dialog;
    private List<MaterialSimpleListItem> items = new ArrayList<MaterialSimpleListItem>(4);
    private Callback callback;

    public MaterialSimpleListAdapter(Callback callback) {
        this.callback = callback;
    }

    public void add(MaterialSimpleListItem item) {
        this.items.add(item);
        this.notifyItemInserted(this.items.size() - 1);
    }

    public void clear() {
        this.items.clear();
        this.notifyDataSetChanged();
    }

    public MaterialSimpleListItem getItem(int index) {
        return this.items.get(index);
    }

    public void setDialog(MaterialDialog dialog) {
        this.dialog = dialog;
    }

    public SimpleListVH onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.md_simplelist_item, parent, false);
        return new SimpleListVH(view, this);
    }

    public void onBindViewHolder(SimpleListVH holder, int position) {
        if (this.dialog != null) {
            MaterialSimpleListItem item = this.items.get(position);
            if (item.getIcon() != null) {
                holder.icon.setImageDrawable(item.getIcon());
                holder.icon.setPadding(item.getIconPadding(), item.getIconPadding(), item.getIconPadding(), item.getIconPadding());
                holder.icon.getBackground().setColorFilter(item.getBackgroundColor(), PorterDuff.Mode.SRC_ATOP);
            } else {
                holder.icon.setVisibility(8);
            }
            holder.title.setTextColor(this.dialog.getBuilder().getItemColor());
            holder.title.setText(item.getContent());
            this.dialog.setTypeface(holder.title, this.dialog.getBuilder().getRegularFont());
        }
    }

    public int getItemCount() {
        return this.items.size();
    }

    static class SimpleListVH
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        final ImageView icon;
        final TextView title;
        final MaterialSimpleListAdapter adapter;

        SimpleListVH(View itemView, MaterialSimpleListAdapter adapter) {
            super(itemView);
            this.icon = (ImageView)itemView.findViewById(16908294);
            this.title = (TextView)itemView.findViewById(16908310);
            this.adapter = adapter;
            itemView.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View view) {
            if (this.adapter.callback != null) {
                this.adapter.callback.onMaterialListItemSelected(this.adapter.dialog, this.getAdapterPosition(), this.adapter.getItem(this.getAdapterPosition()));
            }
        }
    }

    public static interface Callback {
        public void onMaterialListItemSelected(MaterialDialog var1, int var2, MaterialSimpleListItem var3);
    }
}

