/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.color;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ArrayRes;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.res.ResourcesCompat;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.SeekBar;
import android.widget.TextView;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.Theme;
import com.afollestad.materialdialogs.color.CircleView;
import com.afollestad.materialdialogs.color.ColorPalette;
import com.afollestad.materialdialogs.commons.R;
import com.afollestad.materialdialogs.internal.MDTintHelper;
import com.afollestad.materialdialogs.util.DialogUtils;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public class ColorChooserDialog
extends DialogFragment
implements View.OnClickListener,
View.OnLongClickListener {
    public static final String TAG_PRIMARY = "[MD_COLOR_CHOOSER]";
    public static final String TAG_ACCENT = "[MD_COLOR_CHOOSER]";
    public static final String TAG_CUSTOM = "[MD_COLOR_CHOOSER]";
    private int[] colorsTop;
    @Nullable
    private int[][] colorsSub;
    private int circleSize;
    private ColorCallback callback;
    private GridView grid;
    private View colorChooserCustomFrame;
    private EditText customColorHex;
    private View customColorIndicator;
    private TextWatcher customColorTextWatcher;
    private SeekBar customSeekA;
    private TextView customSeekAValue;
    private SeekBar customSeekR;
    private TextView customSeekRValue;
    private SeekBar customSeekG;
    private TextView customSeekGValue;
    private SeekBar customSeekB;
    private TextView customSeekBValue;
    private SeekBar.OnSeekBarChangeListener customColorRgbListener;
    private int selectedCustomColor;

    @Nullable
    public static ColorChooserDialog findVisible(@NonNull FragmentManager fragmentManager, String tag) {
        Fragment frag = fragmentManager.findFragmentByTag(tag);
        if (frag != null && frag instanceof ColorChooserDialog) {
            return (ColorChooserDialog)frag;
        }
        return null;
    }

    private void generateColors() {
        Builder builder = this.getBuilder();
        if (builder.colorsTop != null) {
            this.colorsTop = builder.colorsTop;
            this.colorsSub = builder.colorsSub;
            return;
        }
        if (builder.accentMode) {
            this.colorsTop = ColorPalette.ACCENT_COLORS;
            this.colorsSub = ColorPalette.ACCENT_COLORS_SUB;
        } else {
            this.colorsTop = ColorPalette.PRIMARY_COLORS;
            this.colorsSub = ColorPalette.PRIMARY_COLORS_SUB;
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("top_index", this.topIndex());
        outState.putBoolean("in_sub", this.isInSub());
        outState.putInt("sub_index", this.subIndex());
        outState.putBoolean("in_custom", this.colorChooserCustomFrame != null && this.colorChooserCustomFrame.getVisibility() == 0);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.getActivity() instanceof ColorCallback) {
            this.callback = (ColorCallback)this.getActivity();
        } else if (this.getParentFragment() instanceof ColorCallback) {
            this.callback = (ColorCallback)this.getParentFragment();
        } else {
            throw new IllegalStateException("ColorChooserDialog needs to be shown from an Activity/Fragment implementing ColorCallback.");
        }
    }

    private boolean isInSub() {
        return this.getArguments().getBoolean("in_sub", false);
    }

    private void isInSub(boolean value) {
        this.getArguments().putBoolean("in_sub", value);
    }

    private int topIndex() {
        return this.getArguments().getInt("top_index", -1);
    }

    private void topIndex(int value) {
        if (value > -1) {
            this.findSubIndexForColor(value, this.colorsTop[value]);
        }
        this.getArguments().putInt("top_index", value);
    }

    private int subIndex() {
        if (this.colorsSub == null) {
            return -1;
        }
        return this.getArguments().getInt("sub_index", -1);
    }

    private void subIndex(int value) {
        if (this.colorsSub == null) {
            return;
        }
        this.getArguments().putInt("sub_index", value);
    }

    @StringRes
    public int getTitle() {
        Builder builder = this.getBuilder();
        int title = this.isInSub() ? builder.titleSub : builder.title;
        if (title == 0) {
            title = builder.title;
        }
        return title;
    }

    public String tag() {
        Builder builder = this.getBuilder();
        if (builder.tag != null) {
            return builder.tag;
        }
        return super.getTag();
    }

    public boolean isAccentMode() {
        return this.getBuilder().accentMode;
    }

    public void onClick(View v) {
        if (v.getTag() != null) {
            String[] tag = ((String)v.getTag()).split(":");
            int index = Integer.parseInt(tag[0]);
            MaterialDialog dialog = (MaterialDialog)this.getDialog();
            Builder builder = this.getBuilder();
            if (this.isInSub()) {
                this.subIndex(index);
            } else {
                this.topIndex(index);
                if (this.colorsSub != null && index < this.colorsSub.length) {
                    dialog.setActionButton(DialogAction.NEGATIVE, builder.backBtn);
                    this.isInSub(true);
                }
            }
            if (builder.allowUserCustom) {
                this.selectedCustomColor = this.getSelectedColor();
            }
            this.invalidateDynamicButtonColors();
            this.invalidate();
        }
    }

    public boolean onLongClick(View v) {
        if (v.getTag() != null) {
            String[] tag = ((String)v.getTag()).split(":");
            int color = Integer.parseInt(tag[1]);
            ((CircleView)v).showHint(color);
            return true;
        }
        return false;
    }

    private void invalidateDynamicButtonColors() {
        MaterialDialog dialog = (MaterialDialog)this.getDialog();
        if (dialog == null) {
            return;
        }
        Builder builder = this.getBuilder();
        if (builder.dynamicButtonColor) {
            int selectedColor = this.getSelectedColor();
            if (Color.alpha((int)selectedColor) < 64 || Color.red((int)selectedColor) > 247 && Color.green((int)selectedColor) > 247 && Color.blue((int)selectedColor) > 247) {
                selectedColor = Color.parseColor((String)"#DEDEDE");
            }
            if (this.getBuilder().dynamicButtonColor) {
                dialog.getActionButton(DialogAction.POSITIVE).setTextColor(selectedColor);
                dialog.getActionButton(DialogAction.NEGATIVE).setTextColor(selectedColor);
                dialog.getActionButton(DialogAction.NEUTRAL).setTextColor(selectedColor);
            }
            if (this.customSeekR != null) {
                if (this.customSeekA.getVisibility() == 0) {
                    MDTintHelper.setTint((SeekBar)this.customSeekA, (int)selectedColor);
                }
                MDTintHelper.setTint((SeekBar)this.customSeekR, (int)selectedColor);
                MDTintHelper.setTint((SeekBar)this.customSeekG, (int)selectedColor);
                MDTintHelper.setTint((SeekBar)this.customSeekB, (int)selectedColor);
            }
        }
    }

    @ColorInt
    private int getSelectedColor() {
        if (this.colorChooserCustomFrame != null && this.colorChooserCustomFrame.getVisibility() == 0) {
            return this.selectedCustomColor;
        }
        int color = 0;
        if (this.subIndex() > -1) {
            color = this.colorsSub[this.topIndex()][this.subIndex()];
        } else if (this.topIndex() > -1) {
            color = this.colorsTop[this.topIndex()];
        }
        if (color == 0) {
            int fallback = 0;
            if (Build.VERSION.SDK_INT >= 21) {
                fallback = DialogUtils.resolveColor((Context)this.getActivity(), (int)16843829);
            }
            color = DialogUtils.resolveColor((Context)this.getActivity(), (int)R.attr.colorAccent, (int)fallback);
        }
        return color;
    }

    private void findSubIndexForColor(int topIndex, int color) {
        if (this.colorsSub == null || this.colorsSub.length - 1 < topIndex) {
            return;
        }
        int[] subColors = this.colorsSub[topIndex];
        for (int subIndex = 0; subIndex < subColors.length; ++subIndex) {
            if (subColors[subIndex] != color) continue;
            this.subIndex(subIndex);
            break;
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        int preselectColor;
        if (this.getArguments() == null || !this.getArguments().containsKey("builder")) {
            throw new IllegalStateException("ColorChooserDialog should be created using its Builder interface.");
        }
        this.generateColors();
        boolean foundPreselectColor = false;
        if (savedInstanceState != null) {
            foundPreselectColor = !savedInstanceState.getBoolean("in_custom", false);
            preselectColor = this.getSelectedColor();
        } else if (this.getBuilder().setPreselectionColor) {
            preselectColor = this.getBuilder().preselectColor;
            if (preselectColor != 0) {
                for (int topIndex = 0; topIndex < this.colorsTop.length; ++topIndex) {
                    if (this.colorsTop[topIndex] == preselectColor) {
                        foundPreselectColor = true;
                        this.topIndex(topIndex);
                        if (this.getBuilder().accentMode) {
                            this.subIndex(2);
                        } else if (this.colorsSub != null) {
                            this.findSubIndexForColor(topIndex, preselectColor);
                        } else {
                            this.subIndex(5);
                        }
                    } else {
                        if (this.colorsSub == null) continue;
                        for (int subIndex = 0; subIndex < this.colorsSub[topIndex].length; ++subIndex) {
                            if (this.colorsSub[topIndex][subIndex] != preselectColor) continue;
                            foundPreselectColor = true;
                            this.topIndex(topIndex);
                            this.subIndex(subIndex);
                            break;
                        }
                        if (!foundPreselectColor) {
                            continue;
                        }
                    }
                    break;
                }
            }
        } else {
            preselectColor = -16777216;
            foundPreselectColor = true;
        }
        this.circleSize = this.getResources().getDimensionPixelSize(R.dimen.md_colorchooser_circlesize);
        Builder builder = this.getBuilder();
        MaterialDialog.Builder bd = new MaterialDialog.Builder((Context)this.getActivity()).title(this.getTitle()).autoDismiss(false).customView(R.layout.md_dialog_colorchooser, false).negativeText(builder.cancelBtn).positiveText(builder.doneBtn).neutralText(builder.allowUserCustom ? builder.customBtn : 0).typeface(builder.mediumFont, builder.regularFont).onPositive(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                ColorChooserDialog.this.callback.onColorSelection(ColorChooserDialog.this, ColorChooserDialog.this.getSelectedColor());
                ColorChooserDialog.this.dismiss();
            }
        }).onNegative(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                if (ColorChooserDialog.this.isInSub()) {
                    dialog.setActionButton(DialogAction.NEGATIVE, ((ColorChooserDialog)ColorChooserDialog.this).getBuilder().cancelBtn);
                    ColorChooserDialog.this.isInSub(false);
                    ColorChooserDialog.this.subIndex(-1);
                    ColorChooserDialog.this.invalidate();
                } else {
                    dialog.cancel();
                }
            }
        }).onNeutral(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                ColorChooserDialog.this.toggleCustom(dialog);
            }
        }).showListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                ColorChooserDialog.this.invalidateDynamicButtonColors();
            }
        });
        if (builder.theme != null) {
            bd.theme(builder.theme);
        }
        MaterialDialog dialog = bd.build();
        View v = dialog.getCustomView();
        this.grid = (GridView)v.findViewById(R.id.md_grid);
        if (builder.allowUserCustom) {
            this.selectedCustomColor = preselectColor;
            this.colorChooserCustomFrame = v.findViewById(R.id.md_colorChooserCustomFrame);
            this.customColorHex = (EditText)v.findViewById(R.id.md_hexInput);
            this.customColorIndicator = v.findViewById(R.id.md_colorIndicator);
            this.customSeekA = (SeekBar)v.findViewById(R.id.md_colorA);
            this.customSeekAValue = (TextView)v.findViewById(R.id.md_colorAValue);
            this.customSeekR = (SeekBar)v.findViewById(R.id.md_colorR);
            this.customSeekRValue = (TextView)v.findViewById(R.id.md_colorRValue);
            this.customSeekG = (SeekBar)v.findViewById(R.id.md_colorG);
            this.customSeekGValue = (TextView)v.findViewById(R.id.md_colorGValue);
            this.customSeekB = (SeekBar)v.findViewById(R.id.md_colorB);
            this.customSeekBValue = (TextView)v.findViewById(R.id.md_colorBValue);
            if (!builder.allowUserCustomAlpha) {
                v.findViewById(R.id.md_colorALabel).setVisibility(8);
                this.customSeekA.setVisibility(8);
                this.customSeekAValue.setVisibility(8);
                this.customColorHex.setHint((CharSequence)"2196F3");
                this.customColorHex.setFilters(new InputFilter[]{new InputFilter.LengthFilter(6)});
            } else {
                this.customColorHex.setHint((CharSequence)"FF2196F3");
                this.customColorHex.setFilters(new InputFilter[]{new InputFilter.LengthFilter(8)});
            }
            if (!foundPreselectColor) {
                this.toggleCustom(dialog);
            }
        }
        this.invalidate();
        return dialog;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.callback != null) {
            this.callback.onColorChooserDismissed(this);
        }
    }

    private void toggleCustom(MaterialDialog dialog) {
        if (dialog == null) {
            dialog = (MaterialDialog)this.getDialog();
        }
        if (this.grid.getVisibility() == 0) {
            dialog.setTitle(this.getBuilder().customBtn);
            dialog.setActionButton(DialogAction.NEUTRAL, this.getBuilder().presetsBtn);
            dialog.setActionButton(DialogAction.NEGATIVE, this.getBuilder().cancelBtn);
            this.grid.setVisibility(4);
            this.colorChooserCustomFrame.setVisibility(0);
            this.customColorTextWatcher = new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    try {
                        ColorChooserDialog.this.selectedCustomColor = Color.parseColor((String)("#" + s.toString()));
                    }
                    catch (IllegalArgumentException e) {
                        ColorChooserDialog.this.selectedCustomColor = -16777216;
                    }
                    ColorChooserDialog.this.customColorIndicator.setBackgroundColor(ColorChooserDialog.this.selectedCustomColor);
                    if (ColorChooserDialog.this.customSeekA.getVisibility() == 0) {
                        int alpha = Color.alpha((int)ColorChooserDialog.this.selectedCustomColor);
                        ColorChooserDialog.this.customSeekA.setProgress(alpha);
                        ColorChooserDialog.this.customSeekAValue.setText((CharSequence)String.format(Locale.US, "%d", alpha));
                    }
                    int red = Color.red((int)ColorChooserDialog.this.selectedCustomColor);
                    ColorChooserDialog.this.customSeekR.setProgress(red);
                    int green = Color.green((int)ColorChooserDialog.this.selectedCustomColor);
                    ColorChooserDialog.this.customSeekG.setProgress(green);
                    int blue = Color.blue((int)ColorChooserDialog.this.selectedCustomColor);
                    ColorChooserDialog.this.customSeekB.setProgress(blue);
                    ColorChooserDialog.this.isInSub(false);
                    ColorChooserDialog.this.topIndex(-1);
                    ColorChooserDialog.this.subIndex(-1);
                    ColorChooserDialog.this.invalidateDynamicButtonColors();
                }

                public void afterTextChanged(Editable s) {
                }
            };
            this.customColorHex.addTextChangedListener(this.customColorTextWatcher);
            this.customColorRgbListener = new SeekBar.OnSeekBarChangeListener(){

                @SuppressLint(value={"DefaultLocale"})
                public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                    if (fromUser) {
                        if (((ColorChooserDialog)ColorChooserDialog.this).getBuilder().allowUserCustomAlpha) {
                            int color = Color.argb((int)ColorChooserDialog.this.customSeekA.getProgress(), (int)ColorChooserDialog.this.customSeekR.getProgress(), (int)ColorChooserDialog.this.customSeekG.getProgress(), (int)ColorChooserDialog.this.customSeekB.getProgress());
                            ColorChooserDialog.this.customColorHex.setText((CharSequence)String.format("%08X", color));
                        } else {
                            int color = Color.rgb((int)ColorChooserDialog.this.customSeekR.getProgress(), (int)ColorChooserDialog.this.customSeekG.getProgress(), (int)ColorChooserDialog.this.customSeekB.getProgress());
                            ColorChooserDialog.this.customColorHex.setText((CharSequence)String.format("%06X", 0xFFFFFF & color));
                        }
                    }
                    ColorChooserDialog.this.customSeekAValue.setText((CharSequence)String.format("%d", ColorChooserDialog.this.customSeekA.getProgress()));
                    ColorChooserDialog.this.customSeekRValue.setText((CharSequence)String.format("%d", ColorChooserDialog.this.customSeekR.getProgress()));
                    ColorChooserDialog.this.customSeekGValue.setText((CharSequence)String.format("%d", ColorChooserDialog.this.customSeekG.getProgress()));
                    ColorChooserDialog.this.customSeekBValue.setText((CharSequence)String.format("%d", ColorChooserDialog.this.customSeekB.getProgress()));
                }

                public void onStartTrackingTouch(SeekBar seekBar) {
                }

                public void onStopTrackingTouch(SeekBar seekBar) {
                }
            };
            this.customSeekR.setOnSeekBarChangeListener(this.customColorRgbListener);
            this.customSeekG.setOnSeekBarChangeListener(this.customColorRgbListener);
            this.customSeekB.setOnSeekBarChangeListener(this.customColorRgbListener);
            if (this.customSeekA.getVisibility() == 0) {
                this.customSeekA.setOnSeekBarChangeListener(this.customColorRgbListener);
                this.customColorHex.setText((CharSequence)String.format("%08X", this.selectedCustomColor));
            } else {
                this.customColorHex.setText((CharSequence)String.format("%06X", 0xFFFFFF & this.selectedCustomColor));
            }
        } else {
            dialog.setTitle(this.getBuilder().title);
            dialog.setActionButton(DialogAction.NEUTRAL, this.getBuilder().customBtn);
            if (this.isInSub()) {
                dialog.setActionButton(DialogAction.NEGATIVE, this.getBuilder().backBtn);
            } else {
                dialog.setActionButton(DialogAction.NEGATIVE, this.getBuilder().cancelBtn);
            }
            this.grid.setVisibility(0);
            this.colorChooserCustomFrame.setVisibility(8);
            this.customColorHex.removeTextChangedListener(this.customColorTextWatcher);
            this.customColorTextWatcher = null;
            this.customSeekR.setOnSeekBarChangeListener(null);
            this.customSeekG.setOnSeekBarChangeListener(null);
            this.customSeekB.setOnSeekBarChangeListener(null);
            this.customColorRgbListener = null;
        }
    }

    private void invalidate() {
        if (this.grid.getAdapter() == null) {
            this.grid.setAdapter((ListAdapter)new ColorGridAdapter());
            this.grid.setSelector(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.md_transparent, null));
        } else {
            ((BaseAdapter)this.grid.getAdapter()).notifyDataSetChanged();
        }
        if (this.getDialog() != null) {
            this.getDialog().setTitle(this.getTitle());
        }
    }

    private Builder getBuilder() {
        if (this.getArguments() == null || !this.getArguments().containsKey("builder")) {
            return null;
        }
        return (Builder)this.getArguments().getSerializable("builder");
    }

    private void dismissIfNecessary(FragmentManager fragmentManager, String tag) {
        Fragment frag = fragmentManager.findFragmentByTag(tag);
        if (frag != null) {
            ((DialogFragment)frag).dismiss();
            fragmentManager.beginTransaction().remove(frag).commit();
        }
    }

    @NonNull
    public ColorChooserDialog show(FragmentManager fragmentManager) {
        Builder builder = this.getBuilder();
        String tag = builder.colorsTop != null ? "[MD_COLOR_CHOOSER]" : (builder.accentMode ? "[MD_COLOR_CHOOSER]" : "[MD_COLOR_CHOOSER]");
        this.dismissIfNecessary(fragmentManager, tag);
        this.show(fragmentManager, tag);
        return this;
    }

    @NonNull
    public ColorChooserDialog show(FragmentActivity fragmentActivity) {
        return this.show(fragmentActivity.getSupportFragmentManager());
    }

    private class ColorGridAdapter
    extends BaseAdapter {
        ColorGridAdapter() {
        }

        public int getCount() {
            if (ColorChooserDialog.this.isInSub()) {
                return ColorChooserDialog.this.colorsSub[ColorChooserDialog.this.topIndex()].length;
            }
            return ColorChooserDialog.this.colorsTop.length;
        }

        public Object getItem(int position) {
            if (ColorChooserDialog.this.isInSub()) {
                return ColorChooserDialog.this.colorsSub[ColorChooserDialog.this.topIndex()][position];
            }
            return ColorChooserDialog.this.colorsTop[position];
        }

        public long getItemId(int position) {
            return position;
        }

        @SuppressLint(value={"DefaultLocale"})
        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = new CircleView(ColorChooserDialog.this.getContext());
                convertView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(ColorChooserDialog.this.circleSize, ColorChooserDialog.this.circleSize));
            }
            CircleView child = (CircleView)((Object)convertView);
            int color = ColorChooserDialog.this.isInSub() ? ColorChooserDialog.this.colorsSub[ColorChooserDialog.this.topIndex()][position] : ColorChooserDialog.this.colorsTop[position];
            child.setBackgroundColor(color);
            if (ColorChooserDialog.this.isInSub()) {
                child.setSelected(ColorChooserDialog.this.subIndex() == position);
            } else {
                child.setSelected(ColorChooserDialog.this.topIndex() == position);
            }
            child.setTag(String.format("%d:%d", position, color));
            child.setOnClickListener(ColorChooserDialog.this);
            child.setOnLongClickListener(ColorChooserDialog.this);
            return convertView;
        }
    }

    public static class Builder
    implements Serializable {
        @NonNull
        final transient Context context;
        @Nullable
        String mediumFont;
        @Nullable
        String regularFont;
        @StringRes
        final int title;
        @StringRes
        int titleSub;
        @ColorInt
        int preselectColor;
        @StringRes
        int doneBtn = R.string.md_done_label;
        @StringRes
        int backBtn = R.string.md_back_label;
        @StringRes
        int cancelBtn = R.string.md_cancel_label;
        @StringRes
        int customBtn = R.string.md_custom_label;
        @StringRes
        int presetsBtn = R.string.md_presets_label;
        @Nullable
        int[] colorsTop;
        @Nullable
        int[][] colorsSub;
        @Nullable
        String tag;
        @Nullable
        Theme theme;
        boolean accentMode = false;
        boolean dynamicButtonColor = true;
        boolean allowUserCustom = true;
        boolean allowUserCustomAlpha = true;
        boolean setPreselectionColor = false;

        public Builder(@NonNull Context context, @StringRes int title) {
            this.context = context;
            this.title = title;
        }

        @NonNull
        public Builder typeface(@Nullable String medium, @Nullable String regular) {
            this.mediumFont = medium;
            this.regularFont = regular;
            return this;
        }

        @NonNull
        public Builder titleSub(@StringRes int titleSub) {
            this.titleSub = titleSub;
            return this;
        }

        @NonNull
        public Builder tag(@Nullable String tag) {
            this.tag = tag;
            return this;
        }

        @NonNull
        public Builder theme(@NonNull Theme theme) {
            this.theme = theme;
            return this;
        }

        @NonNull
        public Builder preselect(@ColorInt int preselect) {
            this.preselectColor = preselect;
            this.setPreselectionColor = true;
            return this;
        }

        @NonNull
        public Builder accentMode(boolean accentMode) {
            this.accentMode = accentMode;
            return this;
        }

        @NonNull
        public Builder doneButton(@StringRes int text) {
            this.doneBtn = text;
            return this;
        }

        @NonNull
        public Builder backButton(@StringRes int text) {
            this.backBtn = text;
            return this;
        }

        @NonNull
        public Builder cancelButton(@StringRes int text) {
            this.cancelBtn = text;
            return this;
        }

        @NonNull
        public Builder customButton(@StringRes int text) {
            this.customBtn = text;
            return this;
        }

        @NonNull
        public Builder presetsButton(@StringRes int text) {
            this.presetsBtn = text;
            return this;
        }

        @NonNull
        public Builder dynamicButtonColor(boolean enabled) {
            this.dynamicButtonColor = enabled;
            return this;
        }

        @NonNull
        public Builder customColors(@NonNull int[] topLevel, @Nullable int[][] subLevel) {
            this.colorsTop = topLevel;
            this.colorsSub = subLevel;
            return this;
        }

        @NonNull
        public Builder customColors(@ArrayRes int topLevel, @Nullable int[][] subLevel) {
            this.colorsTop = DialogUtils.getColorArray((Context)this.context, (int)topLevel);
            this.colorsSub = subLevel;
            return this;
        }

        @NonNull
        public Builder allowUserColorInput(boolean allow) {
            this.allowUserCustom = allow;
            return this;
        }

        @NonNull
        public Builder allowUserColorInputAlpha(boolean allow) {
            this.allowUserCustomAlpha = allow;
            return this;
        }

        @NonNull
        public ColorChooserDialog build() {
            ColorChooserDialog dialog = new ColorChooserDialog();
            Bundle args = new Bundle();
            args.putSerializable("builder", (Serializable)this);
            dialog.setArguments(args);
            return dialog;
        }

        @NonNull
        public ColorChooserDialog show(FragmentManager fragmentManager) {
            ColorChooserDialog dialog = this.build();
            dialog.show(fragmentManager);
            return dialog;
        }

        @NonNull
        public ColorChooserDialog show(FragmentActivity fragmentActivity) {
            return this.show(fragmentActivity.getSupportFragmentManager());
        }
    }

    public static interface ColorCallback {
        public void onColorSelection(@NonNull ColorChooserDialog var1, @ColorInt int var2);

        public void onColorChooserDismissed(@NonNull ColorChooserDialog var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorChooserTag {
    }
}

