/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public final class Util {
    private Util() {
    }

    public static <T> String implode(String glue, List<T> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean addGlue = false;
        for (T item : list) {
            if (addGlue) {
                sb.append(glue);
            } else {
                addGlue = true;
            }
            if (item == null) continue;
            sb.append(item);
        }
        return sb.toString();
    }

    public static int getDecimalPlaces(String currency) {
        switch (currency) {
            case "CVE": 
            case "DJF": 
            case "GNF": 
            case "IDR": 
            case "JPY": 
            case "KMF": 
            case "KRW": 
            case "PYG": 
            case "RWF": 
            case "UGX": 
            case "VND": 
            case "VUV": 
            case "XAF": 
            case "XOF": 
            case "XPF": {
                return 0;
            }
            case "BHD": 
            case "IQD": 
            case "JOD": 
            case "KWD": 
            case "LYD": 
            case "OMR": 
            case "TND": {
                return 3;
            }
        }
        return 2;
    }

    public static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static String calculateSessionValidity() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        Date sessionDate = calendar.getTime();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX", Locale.ENGLISH);
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        return fmt.format(sessionDate);
    }
}

