/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.reportwebhooks;

import com.adyen.model.reportwebhooks.JSON;
import com.adyen.model.reportwebhooks.ResourceReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolder", "balanceAccount", "balancePlatform", "creationDate", "downloadUrl", "fileName", "reportType"})
public class ReportNotificationData {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER = "accountHolder";
    private ResourceReference accountHolder;
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT = "balanceAccount";
    private ResourceReference balanceAccount;
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private OffsetDateTime creationDate;
    public static final String JSON_PROPERTY_DOWNLOAD_URL = "downloadUrl";
    private String downloadUrl;
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName;
    public static final String JSON_PROPERTY_REPORT_TYPE = "reportType";
    private String reportType;

    public ReportNotificationData accountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getAccountHolder() {
        return this.accountHolder;
    }

    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
    }

    public ReportNotificationData balanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="balanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getBalanceAccount() {
        return this.balanceAccount;
    }

    @JsonProperty(value="balanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
    }

    public ReportNotificationData balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance platform.")
    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public ReportNotificationData creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public ReportNotificationData downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL at which you can download the report. To download, you must authenticate your GET request with your [API credentials](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/overview).")
    @JsonProperty(value="downloadUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @JsonProperty(value="downloadUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public ReportNotificationData fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(required=true, value="The filename of the report.")
    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ReportNotificationData reportType(String reportType) {
        this.reportType = reportType;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of report.")
    @JsonProperty(value="reportType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReportType() {
        return this.reportType;
    }

    @JsonProperty(value="reportType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportNotificationData reportNotificationData = (ReportNotificationData)o;
        return Objects.equals(this.accountHolder, reportNotificationData.accountHolder) && Objects.equals(this.balanceAccount, reportNotificationData.balanceAccount) && Objects.equals(this.balancePlatform, reportNotificationData.balancePlatform) && Objects.equals(this.creationDate, reportNotificationData.creationDate) && Objects.equals(this.downloadUrl, reportNotificationData.downloadUrl) && Objects.equals(this.fileName, reportNotificationData.fileName) && Objects.equals(this.reportType, reportNotificationData.reportType);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolder, this.balanceAccount, this.balancePlatform, this.creationDate, this.downloadUrl, this.fileName, this.reportType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportNotificationData {\n");
        sb.append("    accountHolder: ").append(this.toIndentedString(this.accountHolder)).append("\n");
        sb.append("    balanceAccount: ").append(this.toIndentedString(this.balanceAccount)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    reportType: ").append(this.toIndentedString(this.reportType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ReportNotificationData fromJson(String jsonString) throws JsonProcessingException {
        return (ReportNotificationData)JSON.getMapper().readValue(jsonString, ReportNotificationData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

