/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.ErrorFieldType;
import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.RefundResult;
import com.adyen.model.marketpaywebhooks.Transaction;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountCode", "accountHolderCode", "invalidFields", "lastPayout", "refundResults"})
public class ScheduledRefundsNotificationContent {
    public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
    private String accountCode;
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_LAST_PAYOUT = "lastPayout";
    private Transaction lastPayout;
    public static final String JSON_PROPERTY_REFUND_RESULTS = "refundResults";
    private List<RefundResult> refundResults = null;

    public ScheduledRefundsNotificationContent accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account.")
    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountCode() {
        return this.accountCode;
    }

    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public ScheduledRefundsNotificationContent accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The code of the Account Holder.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public ScheduledRefundsNotificationContent invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public ScheduledRefundsNotificationContent addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Invalid fields list.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public ScheduledRefundsNotificationContent lastPayout(Transaction lastPayout) {
        this.lastPayout = lastPayout;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="lastPayout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Transaction getLastPayout() {
        return this.lastPayout;
    }

    @JsonProperty(value="lastPayout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastPayout(Transaction lastPayout) {
        this.lastPayout = lastPayout;
    }

    public ScheduledRefundsNotificationContent refundResults(List<RefundResult> refundResults) {
        this.refundResults = refundResults;
        return this;
    }

    public ScheduledRefundsNotificationContent addRefundResultsItem(RefundResult refundResultsItem) {
        if (this.refundResults == null) {
            this.refundResults = new ArrayList<RefundResult>();
        }
        this.refundResults.add(refundResultsItem);
        return this;
    }

    @ApiModelProperty(value="A list of the refunds that have been scheduled and their results.")
    @JsonProperty(value="refundResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RefundResult> getRefundResults() {
        return this.refundResults;
    }

    @JsonProperty(value="refundResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundResults(List<RefundResult> refundResults) {
        this.refundResults = refundResults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledRefundsNotificationContent scheduledRefundsNotificationContent = (ScheduledRefundsNotificationContent)o;
        return Objects.equals(this.accountCode, scheduledRefundsNotificationContent.accountCode) && Objects.equals(this.accountHolderCode, scheduledRefundsNotificationContent.accountHolderCode) && Objects.equals(this.invalidFields, scheduledRefundsNotificationContent.invalidFields) && Objects.equals(this.lastPayout, scheduledRefundsNotificationContent.lastPayout) && Objects.equals(this.refundResults, scheduledRefundsNotificationContent.refundResults);
    }

    public int hashCode() {
        return Objects.hash(this.accountCode, this.accountHolderCode, this.invalidFields, this.lastPayout, this.refundResults);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduledRefundsNotificationContent {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    lastPayout: ").append(this.toIndentedString(this.lastPayout)).append("\n");
        sb.append("    refundResults: ").append(this.toIndentedString(this.refundResults)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ScheduledRefundsNotificationContent fromJson(String jsonString) throws JsonProcessingException {
        return (ScheduledRefundsNotificationContent)JSON.getMapper().readValue(jsonString, ScheduledRefundsNotificationContent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

