/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.KYCCheckStatusData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"checks", "legalArrangementCode", "legalArrangementEntityCode", "shareholderCode"})
public class KYCShareholderCheckResult {
    public static final String JSON_PROPERTY_CHECKS = "checks";
    private List<KYCCheckStatusData> checks = null;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE = "legalArrangementCode";
    private String legalArrangementCode;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODE = "legalArrangementEntityCode";
    private String legalArrangementEntityCode;
    public static final String JSON_PROPERTY_SHAREHOLDER_CODE = "shareholderCode";
    private String shareholderCode;

    public KYCShareholderCheckResult checks(List<KYCCheckStatusData> checks) {
        this.checks = checks;
        return this;
    }

    public KYCShareholderCheckResult addChecksItem(KYCCheckStatusData checksItem) {
        if (this.checks == null) {
            this.checks = new ArrayList<KYCCheckStatusData>();
        }
        this.checks.add(checksItem);
        return this;
    }

    @ApiModelProperty(value="A list of the checks and their statuses.")
    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<KYCCheckStatusData> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChecks(List<KYCCheckStatusData> checks) {
        this.checks = checks;
    }

    public KYCShareholderCheckResult legalArrangementCode(String legalArrangementCode) {
        this.legalArrangementCode = legalArrangementCode;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the legal arrangement to which the shareholder belongs, if applicable.")
    @JsonProperty(value="legalArrangementCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalArrangementCode() {
        return this.legalArrangementCode;
    }

    @JsonProperty(value="legalArrangementCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementCode(String legalArrangementCode) {
        this.legalArrangementCode = legalArrangementCode;
    }

    public KYCShareholderCheckResult legalArrangementEntityCode(String legalArrangementEntityCode) {
        this.legalArrangementEntityCode = legalArrangementEntityCode;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the legal arrangement entity to which the shareholder belongs, if applicable.")
    @JsonProperty(value="legalArrangementEntityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalArrangementEntityCode() {
        return this.legalArrangementEntityCode;
    }

    @JsonProperty(value="legalArrangementEntityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementEntityCode(String legalArrangementEntityCode) {
        this.legalArrangementEntityCode = legalArrangementEntityCode;
    }

    public KYCShareholderCheckResult shareholderCode(String shareholderCode) {
        this.shareholderCode = shareholderCode;
        return this;
    }

    @ApiModelProperty(value="The code of the shareholder to which the check applies.")
    @JsonProperty(value="shareholderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShareholderCode() {
        return this.shareholderCode;
    }

    @JsonProperty(value="shareholderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShareholderCode(String shareholderCode) {
        this.shareholderCode = shareholderCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KYCShareholderCheckResult kyCShareholderCheckResult = (KYCShareholderCheckResult)o;
        return Objects.equals(this.checks, kyCShareholderCheckResult.checks) && Objects.equals(this.legalArrangementCode, kyCShareholderCheckResult.legalArrangementCode) && Objects.equals(this.legalArrangementEntityCode, kyCShareholderCheckResult.legalArrangementEntityCode) && Objects.equals(this.shareholderCode, kyCShareholderCheckResult.shareholderCode);
    }

    public int hashCode() {
        return Objects.hash(this.checks, this.legalArrangementCode, this.legalArrangementEntityCode, this.shareholderCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KYCShareholderCheckResult {\n");
        sb.append("    checks: ").append(this.toIndentedString(this.checks)).append("\n");
        sb.append("    legalArrangementCode: ").append(this.toIndentedString(this.legalArrangementCode)).append("\n");
        sb.append("    legalArrangementEntityCode: ").append(this.toIndentedString(this.legalArrangementEntityCode)).append("\n");
        sb.append("    shareholderCode: ").append(this.toIndentedString(this.shareholderCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static KYCShareholderCheckResult fromJson(String jsonString) throws JsonProcessingException {
        return (KYCShareholderCheckResult)JSON.getMapper().readValue(jsonString, KYCShareholderCheckResult.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

