/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AdditionalSettingsResponse;
import com.adyen.model.management.JSON;
import com.adyen.model.management.WebhookLinks;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"_links", "acceptsExpiredCertificate", "acceptsSelfSignedCertificate", "acceptsUntrustedRootCertificate", "accountReference", "active", "additionalSettings", "certificateAlias", "communicationFormat", "description", "encryptionProtocol", "filterMerchantAccountType", "filterMerchantAccounts", "hasError", "hasPassword", "hmacKeyCheckValue", "id", "networkType", "populateSoapActionHeader", "type", "url", "username"})
public class Webhook {
    public static final String JSON_PROPERTY_LINKS = "_links";
    private WebhookLinks links;
    public static final String JSON_PROPERTY_ACCEPTS_EXPIRED_CERTIFICATE = "acceptsExpiredCertificate";
    private Boolean acceptsExpiredCertificate;
    public static final String JSON_PROPERTY_ACCEPTS_SELF_SIGNED_CERTIFICATE = "acceptsSelfSignedCertificate";
    private Boolean acceptsSelfSignedCertificate;
    public static final String JSON_PROPERTY_ACCEPTS_UNTRUSTED_ROOT_CERTIFICATE = "acceptsUntrustedRootCertificate";
    private Boolean acceptsUntrustedRootCertificate;
    public static final String JSON_PROPERTY_ACCOUNT_REFERENCE = "accountReference";
    private String accountReference;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_ADDITIONAL_SETTINGS = "additionalSettings";
    private AdditionalSettingsResponse additionalSettings;
    public static final String JSON_PROPERTY_CERTIFICATE_ALIAS = "certificateAlias";
    private String certificateAlias;
    public static final String JSON_PROPERTY_COMMUNICATION_FORMAT = "communicationFormat";
    private CommunicationFormatEnum communicationFormat;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ENCRYPTION_PROTOCOL = "encryptionProtocol";
    private EncryptionProtocolEnum encryptionProtocol;
    public static final String JSON_PROPERTY_FILTER_MERCHANT_ACCOUNT_TYPE = "filterMerchantAccountType";
    private FilterMerchantAccountTypeEnum filterMerchantAccountType;
    public static final String JSON_PROPERTY_FILTER_MERCHANT_ACCOUNTS = "filterMerchantAccounts";
    private List<String> filterMerchantAccounts = null;
    public static final String JSON_PROPERTY_HAS_ERROR = "hasError";
    private Boolean hasError;
    public static final String JSON_PROPERTY_HAS_PASSWORD = "hasPassword";
    private Boolean hasPassword;
    public static final String JSON_PROPERTY_HMAC_KEY_CHECK_VALUE = "hmacKeyCheckValue";
    private String hmacKeyCheckValue;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NETWORK_TYPE = "networkType";
    private NetworkTypeEnum networkType;
    public static final String JSON_PROPERTY_POPULATE_SOAP_ACTION_HEADER = "populateSoapActionHeader";
    private Boolean populateSoapActionHeader;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public Webhook links(WebhookLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WebhookLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(WebhookLinks links) {
        this.links = links;
    }

    public Webhook acceptsExpiredCertificate(Boolean acceptsExpiredCertificate) {
        this.acceptsExpiredCertificate = acceptsExpiredCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if expired SSL certificates are accepted. Default value: **false**.")
    @JsonProperty(value="acceptsExpiredCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAcceptsExpiredCertificate() {
        return this.acceptsExpiredCertificate;
    }

    @JsonProperty(value="acceptsExpiredCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptsExpiredCertificate(Boolean acceptsExpiredCertificate) {
        this.acceptsExpiredCertificate = acceptsExpiredCertificate;
    }

    public Webhook acceptsSelfSignedCertificate(Boolean acceptsSelfSignedCertificate) {
        this.acceptsSelfSignedCertificate = acceptsSelfSignedCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if self-signed SSL certificates are accepted. Default value: **false**.")
    @JsonProperty(value="acceptsSelfSignedCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAcceptsSelfSignedCertificate() {
        return this.acceptsSelfSignedCertificate;
    }

    @JsonProperty(value="acceptsSelfSignedCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptsSelfSignedCertificate(Boolean acceptsSelfSignedCertificate) {
        this.acceptsSelfSignedCertificate = acceptsSelfSignedCertificate;
    }

    public Webhook acceptsUntrustedRootCertificate(Boolean acceptsUntrustedRootCertificate) {
        this.acceptsUntrustedRootCertificate = acceptsUntrustedRootCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if untrusted SSL certificates are accepted. Default value: **false**.")
    @JsonProperty(value="acceptsUntrustedRootCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAcceptsUntrustedRootCertificate() {
        return this.acceptsUntrustedRootCertificate;
    }

    @JsonProperty(value="acceptsUntrustedRootCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptsUntrustedRootCertificate(Boolean acceptsUntrustedRootCertificate) {
        this.acceptsUntrustedRootCertificate = acceptsUntrustedRootCertificate;
    }

    public Webhook accountReference(String accountReference) {
        this.accountReference = accountReference;
        return this;
    }

    @ApiModelProperty(value="Reference to the account the webook is set on.")
    @JsonProperty(value="accountReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountReference() {
        return this.accountReference;
    }

    @JsonProperty(value="accountReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountReference(String accountReference) {
        this.accountReference = accountReference;
    }

    public Webhook active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if the webhook configuration is active. The field must be **true** for you to receive webhooks about events related an account.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public Webhook additionalSettings(AdditionalSettingsResponse additionalSettings) {
        this.additionalSettings = additionalSettings;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="additionalSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AdditionalSettingsResponse getAdditionalSettings() {
        return this.additionalSettings;
    }

    @JsonProperty(value="additionalSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalSettings(AdditionalSettingsResponse additionalSettings) {
        this.additionalSettings = additionalSettings;
    }

    public Webhook certificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
        return this;
    }

    @ApiModelProperty(value="The alias of our SSL certificate. When you receive a notification from us, the alias from the HMAC signature will match this alias.")
    @JsonProperty(value="certificateAlias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    @JsonProperty(value="certificateAlias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCertificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
    }

    public Webhook communicationFormat(CommunicationFormatEnum communicationFormat) {
        this.communicationFormat = communicationFormat;
        return this;
    }

    @ApiModelProperty(example="soap", required=true, value="Format or protocol for receiving webhooks. Possible values: * **soap** * **http** * **json** ")
    @JsonProperty(value="communicationFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CommunicationFormatEnum getCommunicationFormat() {
        return this.communicationFormat;
    }

    @JsonProperty(value="communicationFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommunicationFormat(CommunicationFormatEnum communicationFormat) {
        this.communicationFormat = communicationFormat;
    }

    public Webhook description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for this webhook configuration.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Webhook encryptionProtocol(EncryptionProtocolEnum encryptionProtocol) {
        this.encryptionProtocol = encryptionProtocol;
        return this;
    }

    @ApiModelProperty(example="TLSv1.2", value="SSL version to access the public webhook URL specified in the `url` field. Possible values: * **TLSv1.3** * **TLSv1.2** * **HTTP** - Only allowed on Test environment.  If not specified, the webhook will use `sslVersion`: **TLSv1.2**.")
    @JsonProperty(value="encryptionProtocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EncryptionProtocolEnum getEncryptionProtocol() {
        return this.encryptionProtocol;
    }

    @JsonProperty(value="encryptionProtocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptionProtocol(EncryptionProtocolEnum encryptionProtocol) {
        this.encryptionProtocol = encryptionProtocol;
    }

    public Webhook filterMerchantAccountType(FilterMerchantAccountTypeEnum filterMerchantAccountType) {
        this.filterMerchantAccountType = filterMerchantAccountType;
        return this;
    }

    @ApiModelProperty(value="Shows how merchant accounts are included in company-level webhooks. Possible values: * **includeAccounts** * **excludeAccounts** * **allAccounts**: Includes all merchant accounts, and does not require specifying `filterMerchantAccounts`.")
    @JsonProperty(value="filterMerchantAccountType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FilterMerchantAccountTypeEnum getFilterMerchantAccountType() {
        return this.filterMerchantAccountType;
    }

    @JsonProperty(value="filterMerchantAccountType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterMerchantAccountType(FilterMerchantAccountTypeEnum filterMerchantAccountType) {
        this.filterMerchantAccountType = filterMerchantAccountType;
    }

    public Webhook filterMerchantAccounts(List<String> filterMerchantAccounts) {
        this.filterMerchantAccounts = filterMerchantAccounts;
        return this;
    }

    public Webhook addFilterMerchantAccountsItem(String filterMerchantAccountsItem) {
        if (this.filterMerchantAccounts == null) {
            this.filterMerchantAccounts = new ArrayList<String>();
        }
        this.filterMerchantAccounts.add(filterMerchantAccountsItem);
        return this;
    }

    @ApiModelProperty(value="A list of merchant account names that are included or excluded from receiving the webhook. Inclusion or exclusion is based on the value defined for `filterMerchantAccountType`.  Required if `filterMerchantAccountType` is either: * **includeAccounts** * **excludeAccounts**  Not needed for `filterMerchantAccountType`: **allAccounts**.")
    @JsonProperty(value="filterMerchantAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFilterMerchantAccounts() {
        return this.filterMerchantAccounts;
    }

    @JsonProperty(value="filterMerchantAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterMerchantAccounts(List<String> filterMerchantAccounts) {
        this.filterMerchantAccounts = filterMerchantAccounts;
    }

    public Webhook hasError(Boolean hasError) {
        this.hasError = hasError;
        return this;
    }

    @ApiModelProperty(value="Indicates if the webhook configuration has errors that need troubleshooting. If the value is **true**, troubleshoot the configuration using the [testing endpoint](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/companies/{companyId}/webhooks/{webhookid}/test).")
    @JsonProperty(value="hasError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasError() {
        return this.hasError;
    }

    @JsonProperty(value="hasError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasError(Boolean hasError) {
        this.hasError = hasError;
    }

    public Webhook hasPassword(Boolean hasPassword) {
        this.hasPassword = hasPassword;
        return this;
    }

    @ApiModelProperty(value="Indicates if the webhook is password protected.")
    @JsonProperty(value="hasPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPassword() {
        return this.hasPassword;
    }

    @JsonProperty(value="hasPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPassword(Boolean hasPassword) {
        this.hasPassword = hasPassword;
    }

    public Webhook hmacKeyCheckValue(String hmacKeyCheckValue) {
        this.hmacKeyCheckValue = hmacKeyCheckValue;
        return this;
    }

    @ApiModelProperty(value="The [checksum](https://en.wikipedia.org/wiki/Key_checksum_value) of the HMAC key generated for this webhook. You can use this value to uniquely identify the HMAC key configured for this webhook.")
    @JsonProperty(value="hmacKeyCheckValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHmacKeyCheckValue() {
        return this.hmacKeyCheckValue;
    }

    @JsonProperty(value="hmacKeyCheckValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHmacKeyCheckValue(String hmacKeyCheckValue) {
        this.hmacKeyCheckValue = hmacKeyCheckValue;
    }

    public Webhook id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="Unique identifier for this webhook.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Webhook networkType(NetworkTypeEnum networkType) {
        this.networkType = networkType;
        return this;
    }

    @ApiModelProperty(value="Network type for Terminal API details webhooks.")
    @JsonProperty(value="networkType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NetworkTypeEnum getNetworkType() {
        return this.networkType;
    }

    @JsonProperty(value="networkType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkType(NetworkTypeEnum networkType) {
        this.networkType = networkType;
    }

    public Webhook populateSoapActionHeader(Boolean populateSoapActionHeader) {
        this.populateSoapActionHeader = populateSoapActionHeader;
        return this;
    }

    @ApiModelProperty(value="Indicates if the SOAP action header needs to be populated. Default value: **false**.  Only applies if `communicationFormat`: **soap**.")
    @JsonProperty(value="populateSoapActionHeader")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPopulateSoapActionHeader() {
        return this.populateSoapActionHeader;
    }

    @JsonProperty(value="populateSoapActionHeader")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPopulateSoapActionHeader(Boolean populateSoapActionHeader) {
        this.populateSoapActionHeader = populateSoapActionHeader;
    }

    public Webhook type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of webhook. Possible values are:  - **standard** - **account-settings-notification** - **banktransfer-notification** - **boletobancario-notification** - **directdebit-notification** - **ach-notification-of-change-notification** - **pending-notification** - **ideal-notification** - **ideal-pending-notification** - **report-notification** - **terminal-api-notification** - **terminal-settings**  Find out more about [standard notification webhooks](https://docs.adyen.com/development-resources/webhooks/understand-notifications#event-codes) and [other types of notifications](https://docs.adyen.com/development-resources/webhooks/understand-notifications#other-notifications).")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public Webhook url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="http://www.adyen.com", required=true, value="Public URL where webhooks will be sent, for example **https://www.domain.com/webhook-endpoint**.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public Webhook username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(value="Username to access the webhook URL.")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.links, webhook.links) && Objects.equals(this.acceptsExpiredCertificate, webhook.acceptsExpiredCertificate) && Objects.equals(this.acceptsSelfSignedCertificate, webhook.acceptsSelfSignedCertificate) && Objects.equals(this.acceptsUntrustedRootCertificate, webhook.acceptsUntrustedRootCertificate) && Objects.equals(this.accountReference, webhook.accountReference) && Objects.equals(this.active, webhook.active) && Objects.equals(this.additionalSettings, webhook.additionalSettings) && Objects.equals(this.certificateAlias, webhook.certificateAlias) && Objects.equals((Object)this.communicationFormat, (Object)webhook.communicationFormat) && Objects.equals(this.description, webhook.description) && Objects.equals((Object)this.encryptionProtocol, (Object)webhook.encryptionProtocol) && Objects.equals((Object)this.filterMerchantAccountType, (Object)webhook.filterMerchantAccountType) && Objects.equals(this.filterMerchantAccounts, webhook.filterMerchantAccounts) && Objects.equals(this.hasError, webhook.hasError) && Objects.equals(this.hasPassword, webhook.hasPassword) && Objects.equals(this.hmacKeyCheckValue, webhook.hmacKeyCheckValue) && Objects.equals(this.id, webhook.id) && Objects.equals((Object)this.networkType, (Object)webhook.networkType) && Objects.equals(this.populateSoapActionHeader, webhook.populateSoapActionHeader) && Objects.equals(this.type, webhook.type) && Objects.equals(this.url, webhook.url) && Objects.equals(this.username, webhook.username);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.links, this.acceptsExpiredCertificate, this.acceptsSelfSignedCertificate, this.acceptsUntrustedRootCertificate, this.accountReference, this.active, this.additionalSettings, this.certificateAlias, this.communicationFormat, this.description, this.encryptionProtocol, this.filterMerchantAccountType, this.filterMerchantAccounts, this.hasError, this.hasPassword, this.hmacKeyCheckValue, this.id, this.networkType, this.populateSoapActionHeader, this.type, this.url, this.username});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webhook {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    acceptsExpiredCertificate: ").append(this.toIndentedString(this.acceptsExpiredCertificate)).append("\n");
        sb.append("    acceptsSelfSignedCertificate: ").append(this.toIndentedString(this.acceptsSelfSignedCertificate)).append("\n");
        sb.append("    acceptsUntrustedRootCertificate: ").append(this.toIndentedString(this.acceptsUntrustedRootCertificate)).append("\n");
        sb.append("    accountReference: ").append(this.toIndentedString(this.accountReference)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    additionalSettings: ").append(this.toIndentedString(this.additionalSettings)).append("\n");
        sb.append("    certificateAlias: ").append(this.toIndentedString(this.certificateAlias)).append("\n");
        sb.append("    communicationFormat: ").append(this.toIndentedString((Object)this.communicationFormat)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    encryptionProtocol: ").append(this.toIndentedString((Object)this.encryptionProtocol)).append("\n");
        sb.append("    filterMerchantAccountType: ").append(this.toIndentedString((Object)this.filterMerchantAccountType)).append("\n");
        sb.append("    filterMerchantAccounts: ").append(this.toIndentedString(this.filterMerchantAccounts)).append("\n");
        sb.append("    hasError: ").append(this.toIndentedString(this.hasError)).append("\n");
        sb.append("    hasPassword: ").append(this.toIndentedString(this.hasPassword)).append("\n");
        sb.append("    hmacKeyCheckValue: ").append(this.toIndentedString(this.hmacKeyCheckValue)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    networkType: ").append(this.toIndentedString((Object)this.networkType)).append("\n");
        sb.append("    populateSoapActionHeader: ").append(this.toIndentedString(this.populateSoapActionHeader)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Webhook fromJson(String jsonString) throws JsonProcessingException {
        return (Webhook)JSON.getMapper().readValue(jsonString, Webhook.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum NetworkTypeEnum {
        LOCAL("local"),
        PUBLIC("public");

        private String value;

        private NetworkTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NetworkTypeEnum fromValue(String value) {
            for (NetworkTypeEnum b : NetworkTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FilterMerchantAccountTypeEnum {
        ALLACCOUNTS("allAccounts"),
        EXCLUDEACCOUNTS("excludeAccounts"),
        INCLUDEACCOUNTS("includeAccounts");

        private String value;

        private FilterMerchantAccountTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FilterMerchantAccountTypeEnum fromValue(String value) {
            for (FilterMerchantAccountTypeEnum b : FilterMerchantAccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EncryptionProtocolEnum {
        HTTP("HTTP"),
        TLSV1_2("TLSv1.2"),
        TLSV1_3("TLSv1.3");

        private String value;

        private EncryptionProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EncryptionProtocolEnum fromValue(String value) {
            for (EncryptionProtocolEnum b : EncryptionProtocolEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CommunicationFormatEnum {
        HTTP("http"),
        JSON("json"),
        SOAP("soap");

        private String value;

        private CommunicationFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CommunicationFormatEnum fromValue(String value) {
            for (CommunicationFormatEnum b : CommunicationFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

