/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"encrypted", "password", "url", "username"})
public class Url {
    public static final String JSON_PROPERTY_ENCRYPTED = "encrypted";
    private Boolean encrypted;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public Url encrypted(Boolean encrypted) {
        this.encrypted = encrypted;
        return this;
    }

    @ApiModelProperty(value="Indicates if the message sent to this URL should be encrypted.")
    @JsonProperty(value="encrypted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEncrypted() {
        return this.encrypted;
    }

    @JsonProperty(value="encrypted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    public Url password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="The password for authentication of the notifications.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public Url url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="The URL in the format: http(s)://domain.com.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public Url username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(value="The username for authentication of the notifications.")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Url url = (Url)o;
        return Objects.equals(this.encrypted, url.encrypted) && Objects.equals(this.password, url.password) && Objects.equals(this.url, url.url) && Objects.equals(this.username, url.username);
    }

    public int hashCode() {
        return Objects.hash(this.encrypted, this.password, this.url, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Url {\n");
        sb.append("    encrypted: ").append(this.toIndentedString(this.encrypted)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Url fromJson(String jsonString) throws JsonProcessingException {
        return (Url)JSON.getMapper().readValue(jsonString, Url.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

