/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"livePrefix", "name"})
public class DataCenter {
    public static final String JSON_PROPERTY_LIVE_PREFIX = "livePrefix";
    private String livePrefix;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public DataCenter livePrefix(String livePrefix) {
        this.livePrefix = livePrefix;
        return this;
    }

    @ApiModelProperty(value="The unique [live URL prefix](https://docs.adyen.com/development-resources/live-endpoints#live-url-prefix) for your live endpoint. Each data center has its own live URL prefix.  This field is empty for requests made in the test environment.")
    @JsonProperty(value="livePrefix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLivePrefix() {
        return this.livePrefix;
    }

    @JsonProperty(value="livePrefix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLivePrefix(String livePrefix) {
        this.livePrefix = livePrefix;
    }

    public DataCenter name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name assigned to a data center, for example **EU** for the European data center. Possible values are:  * **default**: the European data center. This value is always returned in the test environment.  * **AU** * **EU** * **US**")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataCenter dataCenter = (DataCenter)o;
        return Objects.equals(this.livePrefix, dataCenter.livePrefix) && Objects.equals(this.name, dataCenter.name);
    }

    public int hashCode() {
        return Objects.hash(this.livePrefix, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataCenter {\n");
        sb.append("    livePrefix: ").append(this.toIndentedString(this.livePrefix)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DataCenter fromJson(String jsonString) throws JsonProcessingException {
        return (DataCenter)JSON.getMapper().readValue(jsonString, DataCenter.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

