/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"simcardStatus"})
public class Connectivity {
    public static final String JSON_PROPERTY_SIMCARD_STATUS = "simcardStatus";
    private SimcardStatusEnum simcardStatus;

    public Connectivity simcardStatus(SimcardStatusEnum simcardStatus) {
        this.simcardStatus = simcardStatus;
        return this;
    }

    @ApiModelProperty(value="Indicates the status of the SIM card in the payment terminal. Can be updated and received only at terminal level, and only for models that support cellular connectivity.  Possible values: * **ACTIVATED**: the SIM card is activated. Cellular connectivity may still need to be enabled on the terminal itself, in the **Network** settings. * **INVENTORY**: the SIM card is not activated. The terminal can't use cellular connectivity.")
    @JsonProperty(value="simcardStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SimcardStatusEnum getSimcardStatus() {
        return this.simcardStatus;
    }

    @JsonProperty(value="simcardStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSimcardStatus(SimcardStatusEnum simcardStatus) {
        this.simcardStatus = simcardStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connectivity connectivity = (Connectivity)o;
        return Objects.equals((Object)this.simcardStatus, (Object)connectivity.simcardStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.simcardStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Connectivity {\n");
        sb.append("    simcardStatus: ").append(this.toIndentedString((Object)this.simcardStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Connectivity fromJson(String jsonString) throws JsonProcessingException {
        return (Connectivity)JSON.getMapper().readValue(jsonString, Connectivity.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum SimcardStatusEnum {
        ACTIVATED("ACTIVATED"),
        INVENTORY("INVENTORY");

        private String value;

        private SimcardStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SimcardStatusEnum fromValue(String value) {
            for (SimcardStatusEnum b : SimcardStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

