/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"cronExpression", "type"})
public class SweepSchedule {
    public static final String JSON_PROPERTY_CRON_EXPRESSION = "cronExpression";
    private String cronExpression;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public SweepSchedule cronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
        return this;
    }

    @ApiModelProperty(value="A [cron expression](https://en.wikipedia.org/wiki/Cron#CRON_expression) that is used to set the sweep schedule. The schedule uses the time zone of the balance account.  For example, **30 17 * * MON** schedules a sweep every Monday at 17:30.  The expression must have five values separated by a single space in the following order:  * Minute: **0-59**  * Hour: **0-23**  * Day of the month: **1-31**  * Month: **1-12** or **JAN-DEC**  * Day of the week: **0-7** (0 and 7 are Sunday) or **MON-SUN**.  The following non-standard characters are supported: **&ast;**, **L**, **#**, **W** and **_/_**. See [crontab guru](https://crontab.guru/) for more examples.  Required when `type` is **cron**. ")
    @JsonProperty(value="cronExpression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCronExpression() {
        return this.cronExpression;
    }

    @JsonProperty(value="cronExpression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public SweepSchedule type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The schedule type.  Possible values:  * **cron**: push out funds based on a `cronExpression`.  * **daily**: push out funds daily at 07:00 AM CET.  * **weekly**: push out funds every Monday at 07:00 AM CET.  * **monthly**: push out funds every first of the month at 07:00 AM CET.  * **balance**: pull in funds instantly if the balance is less than or equal to the `triggerAmount`. You can only use this for sweeps of `type` **pull** and when the source is a `merchantAccount` or `transferInstrument`. If the source is transferInstrument, merchant account identifier is still required, with which you want to process the transaction. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SweepSchedule sweepSchedule = (SweepSchedule)o;
        return Objects.equals(this.cronExpression, sweepSchedule.cronExpression) && Objects.equals((Object)this.type, (Object)sweepSchedule.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cronExpression, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SweepSchedule {\n");
        sb.append("    cronExpression: ").append(this.toIndentedString(this.cronExpression)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SweepSchedule fromJson(String jsonString) throws JsonProcessingException {
        return (SweepSchedule)JSON.getMapper().readValue(jsonString, SweepSchedule.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        DAILY("daily"),
        WEEKLY("weekly"),
        MONTHLY("monthly"),
        BALANCE("balance"),
        CRON("cron");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

