/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"dateOfBirth", "idNumber", "nationality"})
public class PersonalData {
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private String dateOfBirth;
    public static final String JSON_PROPERTY_ID_NUMBER = "idNumber";
    private String idNumber;
    public static final String JSON_PROPERTY_NATIONALITY = "nationality";
    private String nationality;

    public PersonalData dateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @ApiModelProperty(value="The date of birth of the person. The date should be in ISO-8601 format yyyy-mm-dd (e.g. 2000-01-31).")
    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PersonalData idNumber(String idNumber) {
        this.idNumber = idNumber;
        return this;
    }

    @ApiModelProperty(value="An ID number of the person.")
    @JsonProperty(value="idNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdNumber() {
        return this.idNumber;
    }

    @JsonProperty(value="idNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public PersonalData nationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @ApiModelProperty(value="The nationality of the person represented by a two-character country code. >The permitted country codes are defined in ISO-3166-1 alpha-2 (e.g. 'NL').")
    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNationality() {
        return this.nationality;
    }

    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonalData personalData = (PersonalData)o;
        return Objects.equals(this.dateOfBirth, personalData.dateOfBirth) && Objects.equals(this.idNumber, personalData.idNumber) && Objects.equals(this.nationality, personalData.nationality);
    }

    public int hashCode() {
        return Objects.hash(this.dateOfBirth, this.idNumber, this.nationality);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PersonalData {\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    idNumber: ").append(this.toIndentedString(this.idNumber)).append("\n");
        sb.append("    nationality: ").append(this.toIndentedString(this.nationality)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PersonalData fromJson(String jsonString) throws JsonProcessingException {
        return (PersonalData)JSON.getMapper().readValue(jsonString, PersonalData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

