/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.AccountInfo;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.AuthenticationData;
import com.adyen.model.checkout.BillingAddress;
import com.adyen.model.checkout.BrowserInfo;
import com.adyen.model.checkout.DeliveryAddress;
import com.adyen.model.checkout.DonationPaymentMethod;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.MerchantRiskIndicator;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.ThreeDS2RequestFields;
import com.adyen.model.checkout.ThreeDSecureData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"accountInfo", "additionalData", "amount", "applicationInfo", "authenticationData", "billingAddress", "browserInfo", "channel", "checkoutAttemptId", "conversionId", "countryCode", "dateOfBirth", "deliverAt", "deliveryAddress", "deviceFingerprint", "donationAccount", "donationOriginalPspReference", "donationToken", "lineItems", "merchantAccount", "merchantRiskIndicator", "metadata", "mpiData", "origin", "paymentMethod", "recurringProcessingModel", "redirectFromIssuerMethod", "redirectToIssuerMethod", "reference", "returnUrl", "sessionValidity", "shopperEmail", "shopperIP", "shopperInteraction", "shopperLocale", "shopperName", "shopperReference", "socialSecurityNumber", "telephoneNumber", "threeDS2RequestData", "threeDSAuthenticationOnly"})
public class DonationPaymentRequest {
    public static final String JSON_PROPERTY_ACCOUNT_INFO = "accountInfo";
    private AccountInfo accountInfo;
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData = null;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
    private ApplicationInfo applicationInfo;
    public static final String JSON_PROPERTY_AUTHENTICATION_DATA = "authenticationData";
    private AuthenticationData authenticationData;
    public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
    private BillingAddress billingAddress;
    public static final String JSON_PROPERTY_BROWSER_INFO = "browserInfo";
    private BrowserInfo browserInfo;
    public static final String JSON_PROPERTY_CHANNEL = "channel";
    private ChannelEnum channel;
    public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    private String checkoutAttemptId;
    public static final String JSON_PROPERTY_CONVERSION_ID = "conversionId";
    @Deprecated
    private String conversionId;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private OffsetDateTime dateOfBirth;
    public static final String JSON_PROPERTY_DELIVER_AT = "deliverAt";
    private OffsetDateTime deliverAt;
    public static final String JSON_PROPERTY_DELIVERY_ADDRESS = "deliveryAddress";
    private DeliveryAddress deliveryAddress;
    public static final String JSON_PROPERTY_DEVICE_FINGERPRINT = "deviceFingerprint";
    private String deviceFingerprint;
    public static final String JSON_PROPERTY_DONATION_ACCOUNT = "donationAccount";
    private String donationAccount;
    public static final String JSON_PROPERTY_DONATION_ORIGINAL_PSP_REFERENCE = "donationOriginalPspReference";
    private String donationOriginalPspReference;
    public static final String JSON_PROPERTY_DONATION_TOKEN = "donationToken";
    private String donationToken;
    public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
    private List<LineItem> lineItems = null;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MERCHANT_RISK_INDICATOR = "merchantRiskIndicator";
    private MerchantRiskIndicator merchantRiskIndicator;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_MPI_DATA = "mpiData";
    private ThreeDSecureData mpiData;
    public static final String JSON_PROPERTY_ORIGIN = "origin";
    private String origin;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private DonationPaymentMethod paymentMethod;
    public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
    private RecurringProcessingModelEnum recurringProcessingModel;
    public static final String JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD = "redirectFromIssuerMethod";
    private String redirectFromIssuerMethod;
    public static final String JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD = "redirectToIssuerMethod";
    private String redirectToIssuerMethod;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_RETURN_URL = "returnUrl";
    private String returnUrl;
    public static final String JSON_PROPERTY_SESSION_VALIDITY = "sessionValidity";
    private String sessionValidity;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SHOPPER_I_P = "shopperIP";
    private String shopperIP;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private ShopperInteractionEnum shopperInteraction;
    public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
    private String shopperLocale;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    private String socialSecurityNumber;
    public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
    private String telephoneNumber;
    public static final String JSON_PROPERTY_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
    private ThreeDS2RequestFields threeDS2RequestData;
    public static final String JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
    @Deprecated
    private Boolean threeDSAuthenticationOnly;

    public DonationPaymentRequest accountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="accountInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    @JsonProperty(value="accountInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public DonationPaymentRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public DonationPaymentRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be required for a particular payment request.  The `additionalData` object consists of entries, each of which includes the key and value.")
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public DonationPaymentRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public DonationPaymentRequest applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public DonationPaymentRequest authenticationData(AuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="authenticationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthenticationData getAuthenticationData() {
        return this.authenticationData;
    }

    @JsonProperty(value="authenticationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticationData(AuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
    }

    public DonationPaymentRequest billingAddress(BillingAddress billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BillingAddress getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAddress(BillingAddress billingAddress) {
        this.billingAddress = billingAddress;
    }

    public DonationPaymentRequest browserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="browserInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    @JsonProperty(value="browserInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrowserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
    }

    public DonationPaymentRequest channel(ChannelEnum channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(value="The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the `sdkVersion` or `token`.  Possible values: * iOS * Android * Web")
    @JsonProperty(value="channel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChannelEnum getChannel() {
        return this.channel;
    }

    @JsonProperty(value="channel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannel(ChannelEnum channel) {
        this.channel = channel;
    }

    public DonationPaymentRequest checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="Checkout attempt ID that corresponds to the Id generated by the client SDK for tracking user payment journey.")
    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    @Deprecated
    public DonationPaymentRequest conversionId(String conversionId) {
        this.conversionId = conversionId;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Conversion ID that corresponds to the Id generated by the client SDK for tracking user payment journey.")
    @JsonProperty(value="conversionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getConversionId() {
        return this.conversionId;
    }

    @Deprecated
    @JsonProperty(value="conversionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConversionId(String conversionId) {
        this.conversionId = conversionId;
    }

    public DonationPaymentRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="The shopper country.  Format: [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public DonationPaymentRequest dateOfBirth(OffsetDateTime dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @ApiModelProperty(value="The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD")
    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(OffsetDateTime dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public DonationPaymentRequest deliverAt(OffsetDateTime deliverAt) {
        this.deliverAt = deliverAt;
        return this;
    }

    @ApiModelProperty(value="The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00")
    @JsonProperty(value="deliverAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDeliverAt() {
        return this.deliverAt;
    }

    @JsonProperty(value="deliverAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliverAt(OffsetDateTime deliverAt) {
        this.deliverAt = deliverAt;
    }

    public DonationPaymentRequest deliveryAddress(DeliveryAddress deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="deliveryAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeliveryAddress getDeliveryAddress() {
        return this.deliveryAddress;
    }

    @JsonProperty(value="deliveryAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryAddress(DeliveryAddress deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public DonationPaymentRequest deviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
        return this;
    }

    @ApiModelProperty(value="A string containing the shopper's device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).")
    @JsonProperty(value="deviceFingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceFingerprint() {
        return this.deviceFingerprint;
    }

    @JsonProperty(value="deviceFingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    public DonationPaymentRequest donationAccount(String donationAccount) {
        this.donationAccount = donationAccount;
        return this;
    }

    @ApiModelProperty(value="Donation account to which the transaction is credited.")
    @JsonProperty(value="donationAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDonationAccount() {
        return this.donationAccount;
    }

    @JsonProperty(value="donationAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDonationAccount(String donationAccount) {
        this.donationAccount = donationAccount;
    }

    public DonationPaymentRequest donationOriginalPspReference(String donationOriginalPspReference) {
        this.donationOriginalPspReference = donationOriginalPspReference;
        return this;
    }

    @ApiModelProperty(value="PSP reference of the transaction from which the donation token is generated. Required when `donationToken` is provided.")
    @JsonProperty(value="donationOriginalPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDonationOriginalPspReference() {
        return this.donationOriginalPspReference;
    }

    @JsonProperty(value="donationOriginalPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDonationOriginalPspReference(String donationOriginalPspReference) {
        this.donationOriginalPspReference = donationOriginalPspReference;
    }

    public DonationPaymentRequest donationToken(String donationToken) {
        this.donationToken = donationToken;
        return this;
    }

    @ApiModelProperty(value="Donation token received in the `/payments` call.")
    @JsonProperty(value="donationToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDonationToken() {
        return this.donationToken;
    }

    @JsonProperty(value="donationToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDonationToken(String donationToken) {
        this.donationToken = donationToken;
    }

    public DonationPaymentRequest lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public DonationPaymentRequest addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="Price and product information about the purchased items, to be included on the invoice sent to the shopper. > This field is required for 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna, Ratepay, and Zip.")
    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public DonationPaymentRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, with which you want to process the transaction.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public DonationPaymentRequest merchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="merchantRiskIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MerchantRiskIndicator getMerchantRiskIndicator() {
        return this.merchantRiskIndicator;
    }

    @JsonProperty(value="merchantRiskIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
    }

    public DonationPaymentRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public DonationPaymentRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \"177\" error occurs: \"Metadata size exceeds limit\". * Maximum 20 characters per key. * Maximum 80 characters per value. ")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public DonationPaymentRequest mpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mpiData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    @JsonProperty(value="mpiData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public DonationPaymentRequest origin(String origin) {
        this.origin = origin;
        return this;
    }

    @ApiModelProperty(value="Required for the 3D Secure 2 `channel` **Web** integration.  Set this parameter to the origin URL of the page that you are loading the 3D Secure Component from.")
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrigin() {
        return this.origin;
    }

    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public DonationPaymentRequest paymentMethod(DonationPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DonationPaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(DonationPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public DonationPaymentRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    @ApiModelProperty(value="Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * `Subscription` \u2013 A transaction for a fixed or variable amount, which follows a fixed schedule. * `CardOnFile` \u2013 With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * `UnscheduledCardOnFile` \u2013 An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")
    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public DonationPaymentRequest redirectFromIssuerMethod(String redirectFromIssuerMethod) {
        this.redirectFromIssuerMethod = redirectFromIssuerMethod;
        return this;
    }

    @ApiModelProperty(value="Specifies the redirect method (GET or POST) when redirecting back from the issuer.")
    @JsonProperty(value="redirectFromIssuerMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRedirectFromIssuerMethod() {
        return this.redirectFromIssuerMethod;
    }

    @JsonProperty(value="redirectFromIssuerMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectFromIssuerMethod(String redirectFromIssuerMethod) {
        this.redirectFromIssuerMethod = redirectFromIssuerMethod;
    }

    public DonationPaymentRequest redirectToIssuerMethod(String redirectToIssuerMethod) {
        this.redirectToIssuerMethod = redirectToIssuerMethod;
        return this;
    }

    @ApiModelProperty(value="Specifies the redirect method (GET or POST) when redirecting to the issuer.")
    @JsonProperty(value="redirectToIssuerMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRedirectToIssuerMethod() {
        return this.redirectToIssuerMethod;
    }

    @JsonProperty(value="redirectToIssuerMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectToIssuerMethod(String redirectToIssuerMethod) {
        this.redirectToIssuerMethod = redirectToIssuerMethod;
    }

    public DonationPaymentRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\"-\"). Maximum length: 80 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public DonationPaymentRequest returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL to return to in case of a redirection. The format depends on the channel. This URL can have a maximum of 1024 characters. * For web, include the protocol `http://` or `https://`. You can also include your own additional query parameters, for example, shopper ID or order reference number. Example: `https://your-company.com/checkout?shopperOrder=12xy` * For iOS, use the custom URL for your app. To know more about setting custom URL schemes, refer to the [Apple Developer documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app). Example: `my-app://` * For Android, use a custom URL handled by an Activity on your app. You can configure it with an [intent filter](https://developer.android.com/guide/components/intents-filters). Example: `my-app://your.package.name`")
    @JsonProperty(value="returnUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @JsonProperty(value="returnUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public DonationPaymentRequest sessionValidity(String sessionValidity) {
        this.sessionValidity = sessionValidity;
        return this;
    }

    @ApiModelProperty(value="The date and time until when the session remains valid, in [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format.  For example: 2020-07-18T15:42:40.428+01:00")
    @JsonProperty(value="sessionValidity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSessionValidity() {
        return this.sessionValidity;
    }

    @JsonProperty(value="sessionValidity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionValidity(String sessionValidity) {
        this.sessionValidity = sessionValidity;
    }

    public DonationPaymentRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="The shopper's email address. We recommend that you provide this data, as it is used in velocity fraud checks. > For 3D Secure 2 transactions, schemes require `shopperEmail` for all browser-based and mobile implementations.")
    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public DonationPaymentRequest shopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
        return this;
    }

    @ApiModelProperty(value="The shopper's IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). > For 3D Secure 2 transactions, schemes require `shopperIP` for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).")
    @JsonProperty(value="shopperIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperIP() {
        return this.shopperIP;
    }

    @JsonProperty(value="shopperIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
    }

    public DonationPaymentRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(value="Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * `Ecommerce` - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * `ContAuth` - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * `Moto` - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * `POS` - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.")
    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public DonationPaymentRequest shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @ApiModelProperty(value="The combination of a language code and a country code to specify the language to be used in the payment.")
    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public DonationPaymentRequest shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public DonationPaymentRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public DonationPaymentRequest socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's social security number.")
    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public DonationPaymentRequest telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's telephone number.")
    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public DonationPaymentRequest threeDS2RequestData(ThreeDS2RequestFields threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="threeDS2RequestData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDS2RequestFields getThreeDS2RequestData() {
        return this.threeDS2RequestData;
    }

    @JsonProperty(value="threeDS2RequestData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDS2RequestData(ThreeDS2RequestFields threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
    }

    @Deprecated
    public DonationPaymentRequest threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.")
    @JsonProperty(value="threeDSAuthenticationOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getThreeDSAuthenticationOnly() {
        return this.threeDSAuthenticationOnly;
    }

    @Deprecated
    @JsonProperty(value="threeDSAuthenticationOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DonationPaymentRequest donationPaymentRequest = (DonationPaymentRequest)o;
        return Objects.equals(this.accountInfo, donationPaymentRequest.accountInfo) && Objects.equals(this.additionalData, donationPaymentRequest.additionalData) && Objects.equals(this.amount, donationPaymentRequest.amount) && Objects.equals(this.applicationInfo, donationPaymentRequest.applicationInfo) && Objects.equals(this.authenticationData, donationPaymentRequest.authenticationData) && Objects.equals(this.billingAddress, donationPaymentRequest.billingAddress) && Objects.equals(this.browserInfo, donationPaymentRequest.browserInfo) && Objects.equals((Object)this.channel, (Object)donationPaymentRequest.channel) && Objects.equals(this.checkoutAttemptId, donationPaymentRequest.checkoutAttemptId) && Objects.equals(this.conversionId, donationPaymentRequest.conversionId) && Objects.equals(this.countryCode, donationPaymentRequest.countryCode) && Objects.equals(this.dateOfBirth, donationPaymentRequest.dateOfBirth) && Objects.equals(this.deliverAt, donationPaymentRequest.deliverAt) && Objects.equals(this.deliveryAddress, donationPaymentRequest.deliveryAddress) && Objects.equals(this.deviceFingerprint, donationPaymentRequest.deviceFingerprint) && Objects.equals(this.donationAccount, donationPaymentRequest.donationAccount) && Objects.equals(this.donationOriginalPspReference, donationPaymentRequest.donationOriginalPspReference) && Objects.equals(this.donationToken, donationPaymentRequest.donationToken) && Objects.equals(this.lineItems, donationPaymentRequest.lineItems) && Objects.equals(this.merchantAccount, donationPaymentRequest.merchantAccount) && Objects.equals(this.merchantRiskIndicator, donationPaymentRequest.merchantRiskIndicator) && Objects.equals(this.metadata, donationPaymentRequest.metadata) && Objects.equals(this.mpiData, donationPaymentRequest.mpiData) && Objects.equals(this.origin, donationPaymentRequest.origin) && Objects.equals(this.paymentMethod, donationPaymentRequest.paymentMethod) && Objects.equals((Object)this.recurringProcessingModel, (Object)donationPaymentRequest.recurringProcessingModel) && Objects.equals(this.redirectFromIssuerMethod, donationPaymentRequest.redirectFromIssuerMethod) && Objects.equals(this.redirectToIssuerMethod, donationPaymentRequest.redirectToIssuerMethod) && Objects.equals(this.reference, donationPaymentRequest.reference) && Objects.equals(this.returnUrl, donationPaymentRequest.returnUrl) && Objects.equals(this.sessionValidity, donationPaymentRequest.sessionValidity) && Objects.equals(this.shopperEmail, donationPaymentRequest.shopperEmail) && Objects.equals(this.shopperIP, donationPaymentRequest.shopperIP) && Objects.equals((Object)this.shopperInteraction, (Object)donationPaymentRequest.shopperInteraction) && Objects.equals(this.shopperLocale, donationPaymentRequest.shopperLocale) && Objects.equals(this.shopperName, donationPaymentRequest.shopperName) && Objects.equals(this.shopperReference, donationPaymentRequest.shopperReference) && Objects.equals(this.socialSecurityNumber, donationPaymentRequest.socialSecurityNumber) && Objects.equals(this.telephoneNumber, donationPaymentRequest.telephoneNumber) && Objects.equals(this.threeDS2RequestData, donationPaymentRequest.threeDS2RequestData) && Objects.equals(this.threeDSAuthenticationOnly, donationPaymentRequest.threeDSAuthenticationOnly);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountInfo, this.additionalData, this.amount, this.applicationInfo, this.authenticationData, this.billingAddress, this.browserInfo, this.channel, this.checkoutAttemptId, this.conversionId, this.countryCode, this.dateOfBirth, this.deliverAt, this.deliveryAddress, this.deviceFingerprint, this.donationAccount, this.donationOriginalPspReference, this.donationToken, this.lineItems, this.merchantAccount, this.merchantRiskIndicator, this.metadata, this.mpiData, this.origin, this.paymentMethod, this.recurringProcessingModel, this.redirectFromIssuerMethod, this.redirectToIssuerMethod, this.reference, this.returnUrl, this.sessionValidity, this.shopperEmail, this.shopperIP, this.shopperInteraction, this.shopperLocale, this.shopperName, this.shopperReference, this.socialSecurityNumber, this.telephoneNumber, this.threeDS2RequestData, this.threeDSAuthenticationOnly});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DonationPaymentRequest {\n");
        sb.append("    accountInfo: ").append(this.toIndentedString(this.accountInfo)).append("\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    authenticationData: ").append(this.toIndentedString(this.authenticationData)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    browserInfo: ").append(this.toIndentedString(this.browserInfo)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString((Object)this.channel)).append("\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    conversionId: ").append(this.toIndentedString(this.conversionId)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    deliverAt: ").append(this.toIndentedString(this.deliverAt)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    deviceFingerprint: ").append(this.toIndentedString(this.deviceFingerprint)).append("\n");
        sb.append("    donationAccount: ").append(this.toIndentedString(this.donationAccount)).append("\n");
        sb.append("    donationOriginalPspReference: ").append(this.toIndentedString(this.donationOriginalPspReference)).append("\n");
        sb.append("    donationToken: ").append(this.toIndentedString(this.donationToken)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantRiskIndicator: ").append(this.toIndentedString(this.merchantRiskIndicator)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    mpiData: ").append(this.toIndentedString(this.mpiData)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    redirectFromIssuerMethod: ").append(this.toIndentedString(this.redirectFromIssuerMethod)).append("\n");
        sb.append("    redirectToIssuerMethod: ").append(this.toIndentedString(this.redirectToIssuerMethod)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    sessionValidity: ").append(this.toIndentedString(this.sessionValidity)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperIP: ").append(this.toIndentedString(this.shopperIP)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    threeDS2RequestData: ").append(this.toIndentedString(this.threeDS2RequestData)).append("\n");
        sb.append("    threeDSAuthenticationOnly: ").append(this.toIndentedString(this.threeDSAuthenticationOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DonationPaymentRequest fromJson(String jsonString) throws JsonProcessingException {
        return (DonationPaymentRequest)JSON.getMapper().readValue(jsonString, DonationPaymentRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ShopperInteractionEnum {
        ECOMMERCE("Ecommerce"),
        CONTAUTH("ContAuth"),
        MOTO("Moto"),
        POS("POS");

        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RecurringProcessingModelEnum {
        CARDONFILE("CardOnFile"),
        SUBSCRIPTION("Subscription"),
        UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecurringProcessingModelEnum fromValue(String value) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChannelEnum {
        IOS("iOS"),
        ANDROID("Android"),
        WEB("Web");

        private String value;

        private ChannelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChannelEnum fromValue(String value) {
            for (ChannelEnum b : ChannelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

