/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.notification;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.widget.RemoteViews;
import com.adpdigital.push.R;

public final class NZV {
    public static RemoteViews generateActionButton(NotificationCompat.Action action, int color, Context context) {
        boolean tombstone = action.actionIntent == null;
        RemoteViews button = new RemoteViews(context.getPackageName(), R.layout.notification_action);
        Bitmap coloredIcon = NZV.createColoredBitmap(action.getIcon(), color, context);
        if (coloredIcon != null) {
            button.setImageViewBitmap(R.id.action_image, coloredIcon);
            button.setViewVisibility(R.id.action_image, 0);
        } else {
            button.setViewVisibility(R.id.action_image, 8);
            int topAndBottom = NZV.getSizeFromScreenDp(5, context);
            int rightAndLeft = NZV.getSizeFromScreenDp(20, context);
            if (Build.VERSION.SDK_INT >= 16) {
                button.setViewPadding(R.id.action_text, rightAndLeft, topAndBottom, rightAndLeft, topAndBottom);
            }
        }
        if (color != -1) {
            button.setTextColor(R.id.action_text, color);
        }
        button.setTextViewText(R.id.action_text, action.title);
        if (!tombstone) {
            button.setOnClickPendingIntent(R.id.action_container, action.actionIntent);
        }
        if (Build.VERSION.SDK_INT >= 15) {
            button.setContentDescription(R.id.action_container, action.title);
        }
        return button;
    }

    public static Bitmap createColoredBitmap(int iconId, int color, Context context) {
        return NZV.NZV(iconId, color, context);
    }

    @Nullable
    private static Bitmap NZV(int iconId, int color, Context context) {
        try {
            Drawable drawable2 = Build.VERSION.SDK_INT >= 21 ? context.getResources().getDrawable(iconId, context.getTheme()) : context.getResources().getDrawable(iconId);
            int width = drawable2.getIntrinsicWidth();
            int height = drawable2.getIntrinsicHeight();
            Bitmap resultBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            drawable2.setBounds(0, 0, width, height);
            if (color != 0) {
                drawable2.mutate().setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
            }
            Canvas canvas = new Canvas(resultBitmap);
            drawable2.draw(canvas);
            return resultBitmap;
        }
        catch (Resources.NotFoundException notFoundException) {
            notFoundException.printStackTrace();
            return null;
        }
    }

    public static int getSizeFromScreenDp(int pixelSize, Context context) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)pixelSize * scale + 0.5f);
    }
}

