/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import java.io.UnsupportedEncodingException;

public class ODB {
    public static final int DEFAULT = 0;
    public static final int NO_PADDING = 1;
    public static final int NO_WRAP = 2;
    public static final int CRLF = 4;
    public static final int URL_SAFE = 8;
    public static final int NO_CLOSE = 16;

    public static byte[] decode(String str, int flags) {
        return ODB.decode(str.getBytes(), flags);
    }

    public static byte[] decode(byte[] input, int flags) {
        return ODB.decode(input, 0, input.length, flags);
    }

    public static byte[] decode(byte[] input, int offset, int len, int flags) {
        MRR decoder = new MRR(flags, new byte[len * 3 / 4]);
        if (!decoder.process(input, offset, len, true)) {
            throw new IllegalArgumentException("bad base-64");
        }
        if (decoder.op == decoder.output.length) {
            return decoder.output;
        }
        byte[] temp = new byte[decoder.op];
        System.arraycopy(decoder.output, 0, temp, 0, decoder.op);
        return temp;
    }

    public static String encodeToString(byte[] input, int flags) {
        try {
            return new String(ODB.encode(input, flags), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String encodeToString(byte[] input, int offset, int len, int flags) {
        try {
            return new String(ODB.encode(input, offset, len, flags), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] encode(byte[] input, int flags) {
        return ODB.encode(input, 0, input.length, flags);
    }

    public static byte[] encode(byte[] input, int offset, int len, int flags) {
        OJW encoder = new OJW(flags, null);
        int output_len = len / 3 * 4;
        if (encoder.do_padding) {
            if (len % 3 > 0) {
                output_len += 4;
            }
        } else {
            switch (len % 3) {
                case 0: {
                    break;
                }
                case 1: {
                    output_len += 2;
                    break;
                }
                case 2: {
                    output_len += 3;
                }
            }
        }
        if (encoder.do_newline && len > 0) {
            output_len += ((len - 1) / 57 + 1) * (encoder.do_cr ? 2 : 1);
        }
        encoder.output = new byte[output_len];
        encoder.process(input, offset, len, true);
        assert (encoder.op == output_len);
        return encoder.output;
    }

    private ODB() {
    }

    static final class OJW
    extends NZV {
        public static final int LINE_GROUPS = 19;
        private static final byte[] OJW = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        private static final byte[] HUI = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
        private final byte[] YCE;
        int NZV;
        private int XTU;
        public final boolean do_padding;
        public final boolean do_newline;
        public final boolean do_cr;
        private final byte[] VMB;

        public OJW(int flags, byte[] output) {
            this.output = output;
            this.do_padding = (flags & 1) == 0;
            this.do_newline = (flags & 2) == 0;
            this.do_cr = (flags & 4) != 0;
            this.VMB = (flags & 8) == 0 ? OJW : HUI;
            this.YCE = new byte[2];
            this.NZV = 0;
            this.XTU = this.do_newline ? 19 : -1;
        }

        @Override
        public final int maxOutputSize(int len) {
            return len * 8 / 5 + 10;
        }

        @Override
        public final boolean process(byte[] input, int offset, int len, boolean finish) {
            byte[] alphabet = this.VMB;
            byte[] output = this.output;
            int op = 0;
            int count = this.XTU;
            int p = offset;
            len += offset;
            int v = -1;
            switch (this.NZV) {
                case 0: {
                    break;
                }
                case 1: {
                    if (offset + 2 > len) break;
                    int n = ++p;
                    ++p;
                    v = (this.YCE[0] & 0xFF) << 16 | (input[offset] & 0xFF) << 8 | input[n] & 0xFF;
                    this.NZV = 0;
                    break;
                }
                case 2: {
                    if (offset + 1 > len) break;
                    ++p;
                    v = (this.YCE[0] & 0xFF) << 16 | (this.YCE[1] & 0xFF) << 8 | input[offset] & 0xFF;
                    this.NZV = 0;
                }
            }
            if (v != -1) {
                ++op;
                output[0] = alphabet[v >> 18 & 0x3F];
                ++op;
                output[1] = alphabet[v >> 12 & 0x3F];
                ++op;
                output[2] = alphabet[v >> 6 & 0x3F];
                ++op;
                output[3] = alphabet[v & 0x3F];
                if (--count == 0) {
                    if (this.do_cr) {
                        output[4] = 13;
                    }
                    int n = ++op;
                    ++op;
                    output[n] = 10;
                    count = 19;
                }
            }
            while (p + 3 <= len) {
                v = (input[p] & 0xFF) << 16 | (input[p + 1] & 0xFF) << 8 | input[p + 2] & 0xFF;
                output[op] = alphabet[v >> 18 & 0x3F];
                output[op + 1] = alphabet[v >> 12 & 0x3F];
                output[op + 2] = alphabet[v >> 6 & 0x3F];
                output[op + 3] = alphabet[v & 0x3F];
                p += 3;
                op += 4;
                if (--count != 0) continue;
                if (this.do_cr) {
                    output[op++] = 13;
                }
                output[op++] = 10;
                count = 19;
            }
            if (finish) {
                if (p - this.NZV == len - 1) {
                    byte by;
                    int t = 0;
                    if (this.NZV > 0) {
                        ++t;
                        by = this.YCE[0];
                    } else {
                        by = input[p++];
                    }
                    v = (by & 0xFF) << 4;
                    this.NZV -= t;
                    output[op++] = alphabet[v >> 6 & 0x3F];
                    output[op++] = alphabet[v & 0x3F];
                    if (this.do_padding) {
                        output[op++] = 61;
                        output[op++] = 61;
                    }
                    if (this.do_newline) {
                        if (this.do_cr) {
                            output[op++] = 13;
                        }
                        output[op++] = 10;
                    }
                } else if (p - this.NZV == len - 2) {
                    byte by;
                    int t = 0;
                    if (this.NZV > 1) {
                        ++t;
                        by = this.YCE[0];
                    } else {
                        by = input[p++];
                    }
                    v = (by & 0xFF) << 10 | ((this.NZV > 0 ? this.YCE[t++] : input[p++]) & 0xFF) << 2;
                    this.NZV -= t;
                    output[op++] = alphabet[v >> 12 & 0x3F];
                    output[op++] = alphabet[v >> 6 & 0x3F];
                    output[op++] = alphabet[v & 0x3F];
                    if (this.do_padding) {
                        output[op++] = 61;
                    }
                    if (this.do_newline) {
                        if (this.do_cr) {
                            output[op++] = 13;
                        }
                        output[op++] = 10;
                    }
                } else if (this.do_newline && op > 0 && count != 19) {
                    if (this.do_cr) {
                        output[op++] = 13;
                    }
                    output[op++] = 10;
                }
                assert (this.NZV == 0);
                assert (p == len);
            } else if (p == len - 1) {
                this.YCE[this.NZV++] = input[p];
            } else if (p == len - 2) {
                this.YCE[this.NZV++] = input[p];
                this.YCE[this.NZV++] = input[p + 1];
            }
            this.op = op;
            this.XTU = count;
            return true;
        }
    }

    static final class MRR
    extends NZV {
        private static final int[] NZV = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private static final int[] MRR = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private int OJW;
        private int HUI;
        private final int[] YCE;

        public MRR(int flags, byte[] output) {
            this.output = output;
            this.YCE = (flags & 8) == 0 ? NZV : MRR;
            this.OJW = 0;
            this.HUI = 0;
        }

        @Override
        public final int maxOutputSize(int len) {
            return len * 3 / 4 + 10;
        }

        @Override
        public final boolean process(byte[] input, int offset, int len, boolean finish) {
            if (this.OJW == 6) {
                return false;
            }
            int p = offset;
            len += offset;
            int state = this.OJW;
            int value = this.HUI;
            int op = 0;
            byte[] output = this.output;
            int[] alphabet = this.YCE;
            while (p < len) {
                if (state == 0) {
                    while (p + 4 <= len && (value = alphabet[input[p] & 0xFF] << 18 | alphabet[input[p + 1] & 0xFF] << 12 | alphabet[input[p + 2] & 0xFF] << 6 | alphabet[input[p + 3] & 0xFF]) >= 0) {
                        output[op + 2] = (byte)value;
                        output[op + 1] = (byte)(value >> 8);
                        output[op] = (byte)(value >> 16);
                        op += 3;
                        p += 4;
                    }
                    if (p >= len) break;
                }
                int d = alphabet[input[p++] & 0xFF];
                switch (state) {
                    case 0: {
                        if (d >= 0) {
                            value = d;
                            ++state;
                            break;
                        }
                        if (d == -1) break;
                        this.OJW = 6;
                        return false;
                    }
                    case 1: {
                        if (d >= 0) {
                            value = value << 6 | d;
                            ++state;
                            break;
                        }
                        if (d == -1) break;
                        this.OJW = 6;
                        return false;
                    }
                    case 2: {
                        if (d >= 0) {
                            value = value << 6 | d;
                            ++state;
                            break;
                        }
                        if (d == -2) {
                            output[op++] = (byte)(value >> 4);
                            state = 4;
                            break;
                        }
                        if (d == -1) break;
                        this.OJW = 6;
                        return false;
                    }
                    case 3: {
                        if (d >= 0) {
                            value = value << 6 | d;
                            output[op + 2] = (byte)value;
                            output[op + 1] = (byte)(value >> 8);
                            output[op] = (byte)(value >> 16);
                            op += 3;
                            state = 0;
                            break;
                        }
                        if (d == -2) {
                            output[op + 1] = (byte)(value >> 2);
                            output[op] = (byte)(value >> 10);
                            op += 2;
                            state = 5;
                            break;
                        }
                        if (d == -1) break;
                        this.OJW = 6;
                        return false;
                    }
                    case 4: {
                        if (d == -2) {
                            ++state;
                            break;
                        }
                        if (d == -1) break;
                        this.OJW = 6;
                        return false;
                    }
                    case 5: {
                        if (d == -1) break;
                        this.OJW = 6;
                        return false;
                    }
                }
            }
            if (!finish) {
                this.OJW = state;
                this.HUI = value;
                this.op = op;
                return true;
            }
            switch (state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.OJW = 6;
                    return false;
                }
                case 2: {
                    output[op++] = (byte)(value >> 4);
                    break;
                }
                case 3: {
                    output[op++] = (byte)(value >> 10);
                    output[op++] = (byte)(value >> 2);
                    break;
                }
                case 4: {
                    this.OJW = 6;
                    return false;
                }
            }
            this.OJW = state;
            this.op = op;
            return true;
        }
    }

    static abstract class NZV {
        public byte[] output;
        public int op;

        NZV() {
        }

        public abstract boolean process(byte[] var1, int var2, int var3, boolean var4);

        public abstract int maxOutputSize(int var1);
    }
}

