/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.IBinder;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.MRQ;
import com.adpdigital.push.NetworkConnectionIntentReceiver;
import com.adpdigital.push.OBX;
import com.adpdigital.push.PCS;
import com.adpdigital.push.RTB;
import com.adpdigital.push.RTU;
import com.adpdigital.push.WXQ;
import java.util.Set;

public class PushService
extends Service {
    private static final String NZV = PushService.class.getName();

    public static void performAction(Context context, String action) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        Intent actionIntent = new Intent(context, PushService.class);
        actionIntent.setAction(action);
        PCS.d(NZV, "PushService action " + action);
        try {
            if (Build.VERSION.SDK_INT >= 26 && !AdpPushClient.get().isForeground()) {
                return;
            }
            context.startService(actionIntent);
            return;
        }
        catch (Exception exc) {
            PCS.w(NZV, "Couldn't start service in foreground (" + AdpPushClient.get().isForeground() + ") with action " + action);
            exc.printStackTrace();
            return;
        }
    }

    public static boolean isRunning(Context ctx) {
        for (ActivityManager.RunningServiceInfo service : ((ActivityManager)ctx.getSystemService("activity")).getRunningServices(Integer.MAX_VALUE)) {
            if (!PushService.class.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void onCreate() {
        super.onCreate();
        PCS.d(NZV, "Creating Chabok PushService");
        MRQ mRQ = MRQ.getInstance((Context)this);
        mRQ.NZV();
        mRQ.AOP = (WifiManager)mRQ.IZX.getSystemService("wifi");
        mRQ.DYH = (AlarmManager)mRQ.IZX.getSystemService("alarm");
        MRQ mRQ2 = mRQ;
        mRQ2.HUI();
        mRQ2.cancelReconnect();
        Set set = RTB.getSharedPreferences(mRQ.IZX).getStringSet("dataCache", null);
        if (set != null) {
            MRQ.MRR.addAll(set);
        }
        mRQ.XTU.register(mRQ);
        mRQ.KEM = new MRQ.MRR<MRQ>(mRQ, mRQ);
        if (mRQ.HUI == null) {
            mRQ.HUI = new NetworkConnectionIntentReceiver(mRQ.IZX, new OBX(mRQ));
        }
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        mRQ.YCE = new RTU(mRQ);
        if (mRQ.IZX != null) {
            try {
                mRQ.IZX.getApplicationContext().registerReceiver(mRQ.YCE, intentFilter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    mRQ.IZX.registerReceiver(mRQ.YCE, intentFilter);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
        }
        if (MRQ.OJW == null) {
            MRQ.OJW = new MRQ.OJW(mRQ);
        } else {
            PCS.w(MRQ.NZV, "Already have a connection? Is this service being created twice?");
        }
        mRQ.VMB();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        PCS.i(NZV, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ onStartCommand " + flags + ", " + startId);
        if (intent == null || intent.getAction() == null) {
            PCS.i(NZV, "Start PushService with empty action");
            MRQ.getInstance((Context)this).OJW();
        } else {
            PCS.i(NZV, "PushService action " + intent.getAction() + ", foreground:" + AdpPushClient.get().isForeground() + ", screenOn:" + MRQ.MRR());
            switch (intent.getAction()) {
                case "START": {
                    MRQ.getInstance((Context)this).OJW();
                    break;
                }
                case "RESTART": {
                    MRQ mRQ = MRQ.getInstance((Context)this);
                    if (AdpPushClient.isDisabledSdk() || !AdpPushClient.get().isEnabledRealtime()) break;
                    if (!WXQ.isConnected(mRQ.IZX)) {
                        PCS.d(MRQ.NZV, "We are not online, Don't restart!");
                        break;
                    }
                    if (MRQ.OJW != null && (MRQ.OJW.isConnecting() || MRQ.OJW.isConnected())) {
                        PCS.w(MRQ.NZV, "Attempt to disconnect existing client first");
                        MRQ.OJW.disconnectExistingClient();
                    }
                    PCS.d(MRQ.NZV, "Restart connection");
                    new MRQ.NZV(mRQ).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                    break;
                }
                case "KEEP_ALIVE": {
                    MRQ mRQ = MRQ.getInstance((Context)this);
                    if (MRQ.OJW.isConnected()) {
                        PCS.i(MRQ.NZV, "send keepalive");
                        new MRQ.HUI(mRQ).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                        break;
                    }
                    PCS.w(MRQ.NZV, "Don't send keepalive, not connected.");
                    break;
                }
                case "RECONNECT": {
                    MRQ.getInstance((Context)this).YCE();
                    break;
                }
                case "DISCONNECT": {
                    MRQ.getInstance((Context)this).cancelReconnect();
                    MRQ.getInstance((Context)this).HUI();
                    if (MRQ.OJW == null) break;
                    MRQ.OJW.disconnectExistingClient();
                    break;
                }
                case "BackgroundTimeExceeded": {
                    MRQ.getInstance((Context)this).XTU();
                    break;
                }
                default: {
                    PCS.w(NZV, "Unrecognized action " + intent.getAction());
                }
            }
        }
        if (AdpPushClient.get().shouldBeSticky()) {
            PCS.d(NZV, "service is sticky");
            return 1;
        }
        PCS.d(NZV, "service is not sticky");
        return 2;
    }

    public void onTaskRemoved(Intent rootIntent) {
        PCS.w(NZV, "PushService removed: " + rootIntent.getAction() + rootIntent);
        MRQ.getInstance((Context)this).XTU();
        AdpPushClient.get().dismiss();
        super.onTaskRemoved(rootIntent);
    }

    public void onLowMemory() {
        PCS.w(NZV, "push service low memory...");
        MRQ.getInstance((Context)this).XTU();
        AdpPushClient.get().dismiss();
        super.onLowMemory();
    }

    public void onTrimMemory(int level) {
        PCS.w(NZV, "push service trim memory " + level);
        super.onTrimMemory(level);
    }

    public void onDestroy() {
        PCS.i(NZV, "destroying push service");
        MRQ.getInstance((Context)this).XTU();
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

