/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.IBinder;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.HWN;
import com.adpdigital.push.JYK;
import com.adpdigital.push.KPZ;
import com.adpdigital.push.NetworkConnectionIntentReceiver;
import com.adpdigital.push.OBX;
import com.adpdigital.push.PBC;
import com.adpdigital.push.UPG;
import java.util.Set;

public class PushService
extends Service {
    private static final String NZV = PushService.class.getName();

    public static void performAction(Context context, String action) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        Intent actionIntent = new Intent(context, PushService.class);
        actionIntent.setAction(action);
        KPZ.d(NZV, "PushService action " + action);
        try {
            if (Build.VERSION.SDK_INT >= 26 && !AdpPushClient.get().isForeground()) {
                return;
            }
            context.startService(actionIntent);
            return;
        }
        catch (Exception exc) {
            KPZ.w(NZV, "Couldn't start service in foreground (" + AdpPushClient.get().isForeground() + ") with action " + action);
            exc.printStackTrace();
            return;
        }
    }

    public static boolean isRunning(Context ctx) {
        for (ActivityManager.RunningServiceInfo service : ((ActivityManager)ctx.getSystemService("activity")).getRunningServices(Integer.MAX_VALUE)) {
            if (!PushService.class.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void onCreate() {
        super.onCreate();
        KPZ.d(NZV, "Creating Chabok PushService");
        OBX oBX = OBX.getInstance((Context)this);
        oBX.NZV();
        oBX.AOP = (WifiManager)oBX.IZX.getSystemService("wifi");
        oBX.DYH = (AlarmManager)oBX.IZX.getSystemService("alarm");
        OBX oBX2 = oBX;
        oBX2.HUI();
        oBX2.cancelReconnect();
        Set set = JYK.getSharedPreferences(oBX.IZX).getStringSet("dataCache", null);
        if (set != null) {
            OBX.MRR.addAll(set);
        }
        oBX.XTU.register(oBX);
        oBX.KEM = new OBX.MRR<OBX>(oBX, oBX);
        if (oBX.HUI == null) {
            oBX.HUI = new NetworkConnectionIntentReceiver(oBX.IZX, new HWN(oBX));
        }
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        oBX.YCE = new UPG(oBX);
        if (oBX.IZX != null) {
            try {
                oBX.IZX.getApplicationContext().registerReceiver(oBX.YCE, intentFilter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    oBX.IZX.registerReceiver(oBX.YCE, intentFilter);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
        }
        if (OBX.OJW == null) {
            OBX.OJW = new OBX.OJW(oBX);
        } else {
            KPZ.w(OBX.NZV, "Already have a connection? Is this service being created twice?");
        }
        oBX.VMB();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        KPZ.i(NZV, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ onStartCommand " + flags + ", " + startId);
        if (intent == null || intent.getAction() == null) {
            KPZ.i(NZV, "Start PushService with empty action");
            OBX.getInstance((Context)this).OJW();
        } else {
            KPZ.i(NZV, "PushService action " + intent.getAction() + ", foreground:" + AdpPushClient.get().isForeground() + ", screenOn:" + OBX.MRR());
            switch (intent.getAction()) {
                case "START": {
                    OBX.getInstance((Context)this).OJW();
                    break;
                }
                case "RESTART": {
                    OBX oBX = OBX.getInstance((Context)this);
                    if (AdpPushClient.isDisabledSdk() || !AdpPushClient.get().isEnabledRealtime()) break;
                    if (!PBC.isConnected(oBX.IZX)) {
                        KPZ.d(OBX.NZV, "We are not online, Don't restart!");
                        break;
                    }
                    if (OBX.OJW != null && (OBX.OJW.isConnecting() || OBX.OJW.isConnected())) {
                        KPZ.w(OBX.NZV, "Attempt to disconnect existing client first");
                        OBX.OJW.disconnectExistingClient();
                    }
                    KPZ.d(OBX.NZV, "Restart connection");
                    new OBX.NZV(oBX).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                    break;
                }
                case "KEEP_ALIVE": {
                    OBX oBX = OBX.getInstance((Context)this);
                    if (OBX.OJW.isConnected()) {
                        KPZ.i(OBX.NZV, "send keepalive");
                        new OBX.HUI(oBX).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                        break;
                    }
                    KPZ.w(OBX.NZV, "Don't send keepalive, not connected.");
                    break;
                }
                case "RECONNECT": {
                    OBX.getInstance((Context)this).YCE();
                    break;
                }
                case "DISCONNECT": {
                    OBX.getInstance((Context)this).cancelReconnect();
                    OBX.getInstance((Context)this).HUI();
                    if (OBX.OJW == null) break;
                    OBX.OJW.disconnectExistingClient();
                    break;
                }
                case "BackgroundTimeExceeded": {
                    OBX.getInstance((Context)this).XTU();
                    break;
                }
                default: {
                    KPZ.w(NZV, "Unrecognized action " + intent.getAction());
                }
            }
        }
        if (AdpPushClient.get().shouldBeSticky()) {
            KPZ.d(NZV, "service is sticky");
            return 1;
        }
        KPZ.d(NZV, "service is not sticky");
        return 2;
    }

    public void onTaskRemoved(Intent rootIntent) {
        KPZ.w(NZV, "PushService removed: " + rootIntent.getAction() + rootIntent);
        OBX.getInstance((Context)this).XTU();
        AdpPushClient.get().dismiss();
        super.onTaskRemoved(rootIntent);
    }

    public void onLowMemory() {
        KPZ.w(NZV, "push service low memory...");
        OBX.getInstance((Context)this).XTU();
        AdpPushClient.get().dismiss();
        super.onLowMemory();
    }

    public void onTrimMemory(int level) {
        KPZ.w(NZV, "push service trim memory " + level);
        super.onTrimMemory(level);
    }

    public void onDestroy() {
        KPZ.i(NZV, "destroying push service");
        OBX.getInstance((Context)this).XTU();
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

