/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.os.Bundle;
import com.adpdigital.push.IMV;
import com.adpdigital.push.KPZ;
import org.json.JSONObject;

public class ChabokEvent {
    protected Double revenue;
    protected JSONObject data;
    protected String currency;

    public ChabokEvent(double revenue) {
        this.setRevenue(revenue);
    }

    public ChabokEvent(double revenue, String currency) {
        this.setRevenue(revenue, currency);
    }

    public void setRevenue(double revenue) {
        if (!this.checkRevenue(revenue)) {
            return;
        }
        this.revenue = revenue;
    }

    public void setRevenue(double revenue, String currency) {
        if (!this.checkRevenue(revenue)) {
            return;
        }
        if (!this.checkCurrency(currency)) {
            return;
        }
        this.revenue = revenue;
        this.currency = currency;
    }

    public void setData(JSONObject data) {
        this.data = data;
    }

    public void setData(Bundle data) {
        this.data = IMV.MRR(data);
    }

    private boolean checkRevenue(Double revenue) {
        if (revenue == null) {
            KPZ.e(KPZ.TAG, "Amount is null");
            return false;
        }
        if (revenue < 0.0) {
            KPZ.e(KPZ.TAG, "Invalid amount " + revenue);
            return false;
        }
        return true;
    }

    private boolean checkCurrency(String currency) {
        if (currency == null) {
            KPZ.e(KPZ.TAG, "Currency must be set with revenue");
            return false;
        }
        if (currency.equals("")) {
            KPZ.e(KPZ.TAG, "Currency is empty");
            return false;
        }
        return true;
    }
}

