/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.ak;
import org.json.JSONException;
import org.json.JSONObject;

public class PushMessage
extends ak {
    private long createdAt;
    private boolean inApp = false;
    private boolean live = false;
    private boolean stateful = false;
    private long expireAt;
    protected String body;
    private JSONObject data;
    private String senderId;
    private String sentId;
    private boolean notify = true;
    private boolean useAsAlert = false;
    private String alertText;

    public long getCreatedAt() {
        return this.createdAt;
    }

    /*
     * WARNING - void declaration
     */
    public void setCreatedAt(long createdAt) {
        void var1_1;
        this.createdAt = var1_1;
    }

    public String getBody() {
        return this.body;
    }

    /*
     * WARNING - void declaration
     */
    public void setBody(String body) {
        void var1_1;
        this.body = var1_1;
    }

    public boolean isInApp() {
        return this.inApp;
    }

    /*
     * WARNING - void declaration
     */
    public void setInApp(boolean inApp) {
        void var1_1;
        this.inApp = var1_1;
    }

    public boolean isLive() {
        return this.live;
    }

    /*
     * WARNING - void declaration
     */
    public void setLive(boolean live) {
        void var1_1;
        this.live = var1_1;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    /*
     * WARNING - void declaration
     */
    public void setStateful(boolean stateful) {
        void var1_1;
        this.stateful = var1_1;
    }

    public long getExpireAt() {
        return this.expireAt;
    }

    /*
     * WARNING - void declaration
     */
    public void setExpireAt(long expireAt) {
        void var1_1;
        this.expireAt = var1_1;
    }

    public JSONObject getData() {
        return this.data;
    }

    /*
     * WARNING - void declaration
     */
    public void setData(JSONObject data) {
        void var1_1;
        this.data = var1_1;
    }

    public String getSenderId() {
        return this.senderId;
    }

    /*
     * WARNING - void declaration
     */
    public void setSenderId(String senderId) {
        void var1_1;
        this.senderId = var1_1;
    }

    public String getSentId() {
        return this.sentId;
    }

    /*
     * WARNING - void declaration
     */
    public void setSentId(String sentId) {
        void var1_1;
        this.sentId = var1_1;
    }

    public boolean isUseAsAlert() {
        return this.useAsAlert;
    }

    /*
     * WARNING - void declaration
     */
    public void setUseAsAlert(boolean useAsAlert) {
        void var1_1;
        this.useAsAlert = var1_1;
    }

    public String getAlertText() {
        return this.alertText;
    }

    /*
     * WARNING - void declaration
     */
    public void setAlertText(String alertText) {
        void var1_1;
        this.alertText = var1_1;
    }

    public boolean isNotify() {
        return this.notify;
    }

    /*
     * WARNING - void declaration
     */
    public void setNotify(boolean notify) {
        void var1_1;
        this.notify = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static PushMessage fromJson(String jsonString, String channel) {
        PushMessage push = new PushMessage();
        try {
            void var2_3;
            String[] tokens;
            void var1_2;
            String[] jsonMessage = new JSONObject(jsonString);
            push.setChannel((String)var1_2);
            push.setId(jsonMessage.getString("id"));
            push.setCreatedAt(jsonMessage.getLong("createdAt"));
            push.setReceivedAt(System.currentTimeMillis());
            push.setBody(jsonMessage.optString("content"));
            push.setData(jsonMessage.optJSONObject("data"));
            long ttl = jsonMessage.optLong("ttl", 0L);
            if (ttl > 0L) {
                void var3_4;
                push.setExpireAt(push.getCreatedAt() + var3_4 * 1000L);
            }
            push.setInApp(jsonMessage.optBoolean("inApp"));
            push.setLive(jsonMessage.optBoolean("live"));
            push.setNotify(!jsonMessage.optBoolean("silent", false));
            push.setStateful(jsonMessage.optBoolean("stateful"));
            String[] publishId = jsonMessage.optString("publishId");
            if (publishId != null && (tokens = publishId.split("/")).length == 3) {
                push.setSenderId(tokens[0]);
                push.setSentId(tokens[2]);
            }
            return var2_3;
        }
        catch (JSONException e2) {
            void var0_1;
            throw new IllegalArgumentException("Invalid Json " + var0_1.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toJson() {
        try {
            JSONObject jsonMessage = new JSONObject();
            jsonMessage.put("id", (Object)this.id);
            jsonMessage.put("createdAt", this.createdAt);
            if (this.body != null) {
                jsonMessage.put("content", (Object)this.body);
            }
            if (this.expireAt > 0L) {
                void var2_3;
                long ttl = (this.getExpireAt() - this.getCreatedAt()) / 1000L;
                jsonMessage.put("ttl", (long)var2_3);
            }
            if (this.inApp) {
                jsonMessage.put("inApp", true);
            }
            if (!this.notify) {
                jsonMessage.put("silent", true);
            }
            if (this.stateful) {
                jsonMessage.put("stateful", true);
            }
            if (this.useAsAlert) {
                jsonMessage.put("useAsAlert", true);
            }
            if (this.alertText != null) {
                jsonMessage.put("alertText", (Object)this.alertText);
            }
            if (this.data != null) {
                jsonMessage.put("data", (Object)this.data);
            }
            return jsonMessage.toString();
        }
        catch (JSONException e2) {
            void var1_2;
            throw new IllegalArgumentException("Invalid Json " + var1_2.getMessage());
        }
    }

    public String toString() {
        return "PushMessage{id='" + this.id + '\'' + ", createdAt=" + this.createdAt + ", channel='" + this.channel + '\'' + ", inapp='" + this.inApp + '\'' + ", stateful='" + this.stateful + '\'' + ", data='" + (this.data != null ? this.data.toString() : "null") + '\'' + '}';
    }

    @Override
    public String getIntentType() {
        return "com.adpdigital.push.client.MSGRECEIVE";
    }

    public void markAsRead() {
        PushMessage.markAsRead(this.id);
    }

    public static void markAsRead(String messageId) {
        String string2;
        AdpPushClient.get().publishMessageEvent("seen", string2);
    }

    public void dismiss() {
        PushMessage.messageDismissed(this.id);
    }

    public static void messageDismissed(String messageId) {
        String string2;
        AdpPushClient.get().publishMessageEvent("dismiss", string2);
    }
}

