/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import com.adpdigital.push.AppListener;
import com.adpdigital.push.ap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ForegroundManager
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = ForegroundManager.class.getName();
    private static String currentActivity = null;
    private static final long CHECK_DELAY = 500L;
    private static ForegroundManager instance;
    private boolean foreground = false;
    private boolean paused = true;
    private Handler handler = new Handler();
    private List<AppListener> listeners = new CopyOnWriteArrayList<AppListener>();
    private Runnable check;

    public static ForegroundManager init(Application application) {
        if (instance == null) {
            Application application2;
            instance = new ForegroundManager();
            application2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
        }
        return instance;
    }

    public static ForegroundManager get(Application application) {
        if (instance == null) {
            Application application2;
            ForegroundManager.init(application2);
        }
        return instance;
    }

    public static ForegroundManager get(Context ctx) {
        if (instance == null) {
            Context appCtx = ctx.getApplicationContext();
            if (appCtx instanceof Application) {
                Context context;
                return ForegroundManager.init((Application)context);
            }
            throw new IllegalStateException("ForegroundManager is not initialised and cannot obtain the Application object");
        }
        return instance;
    }

    public static ForegroundManager get() {
        if (instance == null) {
            throw new IllegalStateException("ForegroundManager is not initialised - invoke at least once with parameterised init/get");
        }
        return instance;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public boolean isBackground() {
        return !this.foreground;
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(AppListener listener) {
        void var1_1;
        this.listeners.add((AppListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeListener(AppListener listener) {
        void var1_1;
        this.listeners.remove(var1_1);
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public String getActiveActivityClassName() {
        return currentActivity;
    }

    /*
     * WARNING - void declaration
     */
    public void onActivityResumed(Activity activity) {
        void var1_1;
        void var2_2;
        this.paused = false;
        boolean wasBackground = !this.foreground;
        this.foreground = true;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        if (var2_2 != false) {
            Log.d((String)TAG, (String)"app foreground");
            for (AppListener l2 : this.listeners) {
                try {
                    l2.onBecameForeground(activity.getClass());
                }
                catch (Exception exc) {
                    void var3_5;
                    Log.e((String)TAG, (String)"AppListener threw exception!", (Throwable)var3_5);
                }
            }
        } else {
            Log.d((String)TAG, (String)"still foreground");
        }
        currentActivity = var1_1.getClass().getName();
    }

    public void onActivityPaused(Activity activity) {
        this.paused = true;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        this.check = new ap(this);
        this.handler.postDelayed(this.check, 500L);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    static /* synthetic */ boolean access$000(ForegroundManager x0) {
        return x0.foreground;
    }

    static /* synthetic */ boolean access$100(ForegroundManager x0) {
        return x0.paused;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$002(ForegroundManager x0, boolean x1) {
        void var1_1;
        x0.foreground = var1_1;
        return x0.foreground;
    }

    static /* synthetic */ String access$200() {
        return TAG;
    }

    static /* synthetic */ List access$300(ForegroundManager x0) {
        return x0.listeners;
    }
}

