package com.adpdigital.push.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.util.Log;

import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.DeviceToken;
import com.adpdigital.push.Logger;
import com.adpdigital.push.R;
import com.google.android.gms.gcm.GcmPubSub;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.iid.InstanceID;

import java.io.IOException;
import java.util.Arrays;

import de.greenrobot.event.EventBus;

/**
 * Created by behrad on 4/28/16.
 */
public class RegistrationIntentService extends IntentService {

    // abbreviated tag name
    private static final String TAG = "RegistrationIntentService";

    public RegistrationIntentService() {
        super(TAG);
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        // Make a call to Instance API
        InstanceID instanceID = InstanceID.getInstance(this);
        try {
            if(intent != null && intent.getExtras() != null) {
                if(intent.getExtras().getBoolean("unregister")) {
                    instanceID.deleteToken(AdpPushClient.get().getSenderId(),
                            GoogleCloudMessaging.INSTANCE_ID_SCOPE);
                    //TODO send unregister token to the Chabok server
                    return;
                }
            }

            String token = instanceID.getToken(
                AdpPushClient.get().getSenderId(),
                GoogleCloudMessaging.INSTANCE_ID_SCOPE
            );
            Logger.d(TAG, "GCM Registration Token: " + token);
            EventBus.getDefault().post(new DeviceToken(token));

            String[] subs = AdpPushClient.get().getSubscriptions();
            for(String topic : subs) {
                if (topic.startsWith("public/")) {
                    RegistrationIntentService.subscribe(topic, this);
                }
            }
        } catch (IOException e) {
            Logger.e(TAG, "Error registering to GCM ", e);
            EventBus.getDefault().post(new DeviceToken("---"));
        }
    }

    public static void subscribe(final String topic, final Context ctx) {
        new AsyncTask<Void, Void, Boolean>() {
            @Override
            protected Boolean doInBackground(final Void... params) {
                try{
                    InstanceID instanceID = InstanceID.getInstance(ctx);
                    String token = instanceID.getToken(
                            AdpPushClient.get().getSenderId(),
                            GoogleCloudMessaging.INSTANCE_ID_SCOPE
                    );
                    GcmPubSub pubSub = GcmPubSub.getInstance(ctx);
                    String[] tokens = topic.split("public/");
                    String channel = tokens[0];
                    if(tokens.length == 2) {
                        channel = tokens[1];
                    }
                    if (topic.equalsIgnoreCase("default")) {
                        channel = "chabok";
                    }
                    pubSub.subscribe(token, "/topics/" + channel, null);
                } catch (Exception e) {
                    Logger.e(TAG, "Error subscribing to firebase" , e);
                }
                return true;
            }

            @Override
            protected void onPostExecute(final Boolean registered) {
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null, null, null);
    }

    public static void unsubscribe(final String topic, final Context ctx) {
        new AsyncTask<Void, Void, Boolean>() {
            @Override
            protected Boolean doInBackground(final Void... params) {
                try{
                    InstanceID instanceID = InstanceID.getInstance(ctx);
                    String token = instanceID.getToken(
                            AdpPushClient.get().getSenderId(),
                            GoogleCloudMessaging.INSTANCE_ID_SCOPE
                    );
                    GcmPubSub pubSub = GcmPubSub.getInstance(ctx);
                    String[] tokens = topic.split("public/");
                    String channel = tokens[0];
                    if(tokens.length == 2) {
                        channel = tokens[1];
                    }
                    if (topic.equalsIgnoreCase("default")) {
                        channel = "chabok";
                    }
                    pubSub.unsubscribe(token, "/topics/" + channel);
                } catch (Exception e) {
                    Logger.e(TAG, "Error subscribing to firebase" , e);
                }
                return true;
            }

            @Override
            protected void onPostExecute(final Boolean registered) {
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null, null, null);
    }

}