package com.adpdigital.push;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.UUID;

import static com.adpdigital.push.AdpPushClient.PUSH_DELIVERY_RECEIVED_INTENT;


/**
 * Created by behrad on 2/4/16.
 */
public class EventMessage extends ChabokMessage {

    private String name;

    private String installationId;

    private JSONObject data;


    public EventMessage(String name, String installationId, String payload) {
        this.name = name;
        this.installationId = installationId;
        try {
            this.data = new JSONObject(payload);
            setId(this.data.getString("id"));
        } catch (JSONException e) {
            throw new IllegalArgumentException( "Invalid Json " + e.getMessage() );
        }
    }

    public String getName() {
        return name;
    }

    public String getInstallationId() {
        return installationId;
    }

    public JSONObject getData() {
        return data;
    }
}
