/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.provider.Settings;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import b.g;
import com.adpdigital.push.AppListener;
import com.adpdigital.push.BadgeUpdate;
import com.adpdigital.push.Callback;
import com.adpdigital.push.ChabokNotification;
import com.adpdigital.push.ConnectionStatus;
import com.adpdigital.push.ForegroundManager;
import com.adpdigital.push.GcmMessageHandler;
import com.adpdigital.push.NotificationHandler;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.PushService;
import com.adpdigital.push.R;
import com.adpdigital.push.a;
import com.adpdigital.push.aa;
import com.adpdigital.push.ab;
import com.adpdigital.push.ac;
import com.adpdigital.push.ae;
import com.adpdigital.push.af;
import com.adpdigital.push.ai;
import com.adpdigital.push.aj;
import com.adpdigital.push.al;
import com.adpdigital.push.an;
import com.adpdigital.push.b;
import com.adpdigital.push.c;
import com.adpdigital.push.d;
import com.adpdigital.push.e;
import com.adpdigital.push.f;
import com.adpdigital.push.h;
import com.adpdigital.push.i;
import com.adpdigital.push.j;
import com.adpdigital.push.k;
import com.adpdigital.push.l;
import com.adpdigital.push.n;
import com.adpdigital.push.o;
import com.adpdigital.push.p;
import com.adpdigital.push.q;
import com.adpdigital.push.s;
import com.adpdigital.push.service.RegistrationIntentService;
import com.adpdigital.push.t;
import com.adpdigital.push.u;
import com.adpdigital.push.w;
import com.adpdigital.push.y;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.Key;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import me.leolin.shortcutbadger.ShortcutBadger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdpPushClient {
    public static final String TAG = AdpPushClient.class.getName();
    public static String packageName;
    private static boolean FORCE_STICKY;
    public static final String SDK_VERSION = "2.7.6";
    public static final String PUSH_DELIVERY_RECEIVED_INTENT = "com.adpdigital.push.client.DLVRECEIVE";
    public static final String PUSH_MSG_RECEIVED_INTENT = "com.adpdigital.push.client.MSGRECEIVE";
    public static final String PUSH_MSG_RECEIVED_TOPIC = "com.adpdigital.push.client.MSGRECVD_TOPIC";
    public static final String PUSH_MSG_RECEIVED_MSG = "com.adpdigital.push.client.MSGRECVD_MSGBODY";
    private boolean restartServiceState = false;
    public static final int PUSH_NOTIFICATION_UPDATE = 2;
    public static final String APPLICATION_LAUNCH = "AppLaunched";
    public static final String APPLICATION_LAUNCH_TS = "AppLaunchTs";
    public static final String ACTIVITY_KEY = "MainActivityClassName";
    private g adapter;
    private boolean isFreshStart = false;
    private boolean registeredOnce = false;
    private boolean registering = false;
    private static int failed_tries;
    private static final int TOTAL_RETRIES = 3;
    private f.c eventBus = f.c.getDefault();
    private Context context;
    private Class activityClass;
    private Activity currentActivity;
    private String userId;
    private String senderId;
    private String appId;
    private String apiKey;
    private HashMap<String, Object> userInfo = new HashMap();
    Set<NotificationHandler> handlers = new HashSet<NotificationHandler>();
    private static Collection<String> notifs;
    private String[] topics = new String[]{"default"};
    private JSONObject notificationSettings;
    private ForegroundManager foreground;
    private boolean useSecure = true;
    private boolean useDev = false;
    private int notificationIcon = -1;
    private int notificationIconSilhouette = -1;
    private static final ScheduledExecutorService worker;
    private static AdpPushClient pushClientInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdpPushClient init(Context context, Class clazz, String string2, String string3, String string4, String string5) {
        if (pushClientInstance != null) return pushClientInstance;
        Class<AdpPushClient> clazz2 = AdpPushClient.class;
        synchronized (AdpPushClient.class) {
            if (pushClientInstance != null) return pushClientInstance;
            packageName = context.getPackageName();
            pushClientInstance = new AdpPushClient(context, clazz, string2, string3, string4, string5);
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return pushClientInstance;
        }
    }

    public static synchronized AdpPushClient get() {
        if (pushClientInstance == null) {
            throw new IllegalStateException("AdpPushClient not initialized yet, please first call AdpPushClient.get with parameters");
        }
        return pushClientInstance;
    }

    private AdpPushClient(Context context, Class clazz, String string2, String string3, String string4, String string5) {
        Log.i((String)TAG, (String)"Creating a new AdpPushClient instance");
        try {
            Class.forName("android.os.AsyncTask");
        }
        catch (Throwable throwable) {}
        this.isFreshStart = true;
        this.validateAndPopulate(context, clazz, string2, string3, string4, string5);
        this.eventBus.register(this);
        this.foreground = ForegroundManager.get(this.getApplicationContext());
        this.foreground.addListener(new a(this));
        try {
            ((Application)context).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new n(this));
        }
        catch (Exception exception) {}
        this.initializeAdapter();
    }

    private void initializeAdapter() {
        String string2 = "http://" + aj.a + ":80/api/";
        String string3 = aj.a;
        String string4 = ":1880";
        if (this.useSecure) {
            string3 = "";
            if (!(this.appId.equalsIgnoreCase("chabok-demo") || this.appId.equalsIgnoreCase("adp-nms-push") || this.appId.equalsIgnoreCase("chabok-demo"))) {
                string3 = this.appId.split("-demo")[0] + ".";
            }
            string2 = "https://" + string3 + aj.a + ":443/api/";
            string3 = string3 + aj.a;
            string4 = ":4443";
        }
        if (this.useDev) {
            string2 = "http://sandbox.push.adpdigital.com:80/api/";
            string3 = "sandbox.push.adpdigital.com";
            string4 = ":1880";
        }
        if (this.useDev && this.useSecure) {
            string2 = "https://sandbox.push.adpdigital.com:443/api/";
            string3 = "sandbox.push.adpdigital.com";
            string4 = ":4443";
        }
        this.getSharedPreferences().edit().putString("host", string3).putString("port", string4).putBoolean("useSecure", this.useSecure).putBoolean("useDev", this.useDev).apply();
        this.adapter = new g(this.getApplicationContext(), string2);
        this.adapter.setAccessToken(this.apiKey);
    }

    private void validateAndPopulate(Context object, Class clazz, String string2, String string3, String string4, String string5) {
        if (object == null) {
            throw new IllegalArgumentException("No Context passed, PushClient needs your application context");
        }
        this.context = object;
        if (clazz == null) {
            throw new IllegalArgumentException("No Handler Activity Class passed, PushClient needs a work on a activity");
        }
        this.activityClass = clazz;
        this.getSharedPreferences().edit().putString(ACTIVITY_KEY, this.getActivityClass().getName()).apply();
        if (string4 == null) {
            throw new IllegalArgumentException("Please provide your username");
        }
        this.getSharedPreferences().edit().putString("username", this.encrypt(string4)).apply();
        if (string5 == null) {
            throw new IllegalArgumentException("Please provide your password");
        }
        this.getSharedPreferences().edit().putString("password", this.encrypt(string5)).apply();
        if (string2 == null) {
            throw new IllegalArgumentException("Pleas provide your application ID");
        }
        object = string2.split("/");
        if (((String[])object).length != 2) {
            throw new IllegalArgumentException("Application ID should be in `app-name/number` format");
        }
        this.appId = object[0];
        this.apiKey = string3;
        this.senderId = object[1];
        this.getSharedPreferences().edit().putString("applicationId", this.encrypt(this.appId)).apply();
        this.getSharedPreferences().edit().putString("senderId", this.encrypt(this.senderId)).apply();
        object = this.getSharedPreferences().getStringSet("topics", new HashSet<String>(Arrays.asList(this.topics)));
        this.topics = object.toArray(new String[object.size()]);
        object = this.getSharedPreferences().getString("notificationSettings", null);
        if (object != null) {
            try {
                this.notificationSettings = new JSONObject((String)object);
            }
            catch (JSONException jSONException) {
                jSONException.getMessage();
            }
        }
        if ((object = this.getSharedPreferences().getStringSet("notifs", null)) != null) {
            notifs.addAll((Collection<String>)object);
        }
    }

    public void onEvent(an an2) {
        Log.w((String)TAG, (String)("New GCM message (foreground:" + this.isForeground() + "): " + an2.getIntent().getExtras()));
        if (this.isForeground()) {
            Log.w((String)TAG, (String)"How is this happening...!? we are in foreground, so ignore GCM message");
            return;
        }
        AdpPushClient adpPushClient = this;
        this.isReceivedMessage(an2.getIntent().getExtras().getString("messageId"), new t(this, adpPushClient, an2));
    }

    public void publish(PushMessage pushMessage, Callback callback) {
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new u(this, pushMessage, callback), 0);
    }

    public void publish(String string2, String string3, Callback callback) {
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new w(this, string3, string2, callback), 0);
    }

    public void publish(String string2, String string3, JSONObject jSONObject, Callback callback) {
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new y(this, string3, string2, jSONObject, callback), 0);
    }

    void emit(String string2, String string3) {
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new aa(this, string2, string3), 0);
    }

    private void isReceivedMessage(String string2, Callback callback) {
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new ab(this, callback, string2), 0);
    }

    public void getStatus(Callback<ConnectionStatus> callback) {
        if (!PushService.isRunning(this.getApplicationContext())) {
            callback.onSuccess(ConnectionStatus.DISCONNECTED);
            return;
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new ac(this, callback), 0);
    }

    public void subscribe(String string2, Callback callback) {
        this.subscribe(string2, false, callback);
    }

    public void subscribe(String string2, boolean bl, Callback callback) {
        if (!bl) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.topics));
            hashSet.add(string2);
            this.getSharedPreferences().edit().putStringSet("topics", hashSet).apply();
            this.topics = hashSet.toArray(new String[hashSet.size()]);
            this.updateInstallation(new HashMap());
            if (string2.startsWith("public/")) {
                RegistrationIntentService.subscribe(string2, this.getApplicationContext());
            }
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new b(this, string2, bl, callback), 0);
    }

    public void unsubscribe(String string2, Callback callback) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.topics));
        hashSet.remove(string2);
        this.getSharedPreferences().edit().putStringSet("topics", hashSet).apply();
        this.topics = hashSet.toArray(new String[hashSet.size()]);
        this.updateInstallation(new HashMap());
        if (string2.startsWith("public/")) {
            RegistrationIntentService.unsubscribe(string2, this.getApplicationContext());
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new c(this, string2, callback), 0);
    }

    public void updateNotificationSettings(String object, String object2, boolean bl) {
        if (this.notificationSettings == null) {
            this.notificationSettings = new JSONObject();
        }
        JSONObject jSONObject = new JSONObject();
        this.notificationSettings.remove((String)object);
        try {
            jSONObject.put("sound", object2);
            jSONObject.put("alert", bl);
            this.notificationSettings.put((String)object, (Object)jSONObject);
            this.getSharedPreferences().edit().putString("notificationSettings", this.notificationSettings.toString()).apply();
            object = new HashMap();
            object2 = this.getNotificationSettings();
            if (object2 != null) {
                ((HashMap)object).put("notificationSettings", object2);
            }
            this.updateInstallation((Map<String, ?>)object);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.getMessage();
            return;
        }
    }

    public AdpPushClient addListener(Object object) {
        if (!this.eventBus.isRegistered(object)) {
            this.eventBus.register(object);
        }
        return this;
    }

    public AdpPushClient notify(Object object) {
        if (this.eventBus != null) {
            this.eventBus.post(object);
        }
        return this;
    }

    public AdpPushClient removeListener(Object object) {
        if (this.eventBus.isRegistered(object)) {
            this.eventBus.unregister(object);
        }
        return this;
    }

    public AdpPushClient setPushListener(Object object) {
        return this.addListener(object);
    }

    public AdpPushClient removePushListener(Object object) {
        return this.removeListener(object);
    }

    public AdpPushClient register(String string2) {
        return this._register(string2, new String[0], false);
    }

    public AdpPushClient register(String string2, String[] stringArray) {
        return this._register(string2, stringArray, false);
    }

    public AdpPushClient reRegister(String string2) {
        return this._register(string2, new String[0], true);
    }

    public AdpPushClient reRegister(String string2, String[] stringArray) {
        return this._register(string2, stringArray, true);
    }

    public AdpPushClient _register(String object, String[] stringArray, boolean bl) {
        if (object == null || ((String)object).trim().equals("") || ((String)object).trim().equals("null")) {
            throw new IllegalArgumentException("Please provide a user ID to register with ADP server: " + (String)object);
        }
        this.registeredOnce = false;
        this.userId = object;
        this.getSharedPreferences().edit().putString("userId", this.encrypt(this.userId)).apply();
        object = new HashSet<String>(Arrays.asList(this.topics));
        boolean bl2 = false;
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray2[i2];
            if (object.contains(string2)) continue;
            bl2 = true;
        }
        object.addAll(Arrays.asList(stringArray));
        if (bl2) {
            this.makeSubsDirty();
        }
        this.getSharedPreferences().edit().putStringSet("topics", (Set)object).apply();
        this.topics = object.toArray(new String[object.size()]);
        failed_tries = 0;
        if (!this.checkPlayServices()) {
            this.getSharedPreferences().edit().putBoolean("noGCM", true).apply();
            Log.w((String)TAG, (String)"No valid Google Play Services found.");
        } else {
            this.getSharedPreferences().edit().putBoolean("noGCM", false).apply();
        }
        this.doRegister(bl);
        return this;
    }

    private void doRegister() {
        this.doRegister(false);
    }

    private void doRegister(boolean bl) {
        if (this.userId == null) {
            Log.e((String)TAG, (String)"userId not initialized yet");
            return;
        }
        if (this.registering) {
            new StringBuilder("Register already in progress for ").append(this.userId);
            return;
        }
        this.initializeAdapter();
        worker.schedule(new d(this, bl), 250L, TimeUnit.MILLISECONDS);
    }

    public boolean isConnected() {
        return this.adapter != null && this.adapter.isConnected();
    }

    public void dismiss() {
        this.eventBus.unregister(this);
        this.getForegroundManager().removeListeners();
    }

    private void cleanData() {
        this.getSharedPreferences().edit().clear().apply();
    }

    void makeSubsDirty() {
        this.getSharedPreferences().edit().putBoolean("subscriptionDirty", true).apply();
    }

    private boolean _checkPlayServices() {
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getApplicationContext());
        if (n2 != 0) {
            if (GooglePlayServicesUtil.isUserRecoverableError((int)n2) && this.currentActivity != null) {
                GooglePlayServicesUtil.getErrorDialog((int)n2, (Activity)this.currentActivity, (int)9000).show();
            } else {
                Log.w((String)"AdpPushLibrary", (String)"This device is not supported.");
            }
            return false;
        }
        return true;
    }

    private boolean checkPlayServices() {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        int n2 = googleApiAvailability.isGooglePlayServicesAvailable(this.getApplicationContext());
        if (n2 != 0 && n2 != 2) {
            if (googleApiAvailability.isUserResolvableError(n2)) {
                googleApiAvailability.getErrorDialog(this.currentActivity, n2, 9000).show();
            } else {
                Log.i((String)TAG, (String)"This device is not supported.");
            }
            return false;
        }
        return true;
    }

    private AdpPushClient updateRegistration(boolean bl) {
        b.a a2 = new b.a(this.getApplicationContext(), this.adapter);
        a2.setAppId(this.getAppId());
        a2.setAppVersion(SDK_VERSION);
        a2.setUserId(this.getUserId());
        a2.setSubscriptions(this.topics);
        this.restartServiceState = bl;
        this.registerInBackground(a2);
        return this;
    }

    private void registerInBackground(b.a a2) {
        a2.setDeviceToken("---");
        a2 = new Intent(this.getApplicationContext(), RegistrationIntentService.class);
        this.getApplicationContext().startService((Intent)a2);
    }

    public void onEvent(al al2) {
        b.a a2 = this.getLocalInstallation();
        new e(this, a2, al2).execute(new Void[]{null, null, null});
    }

    private void saveInstallation(b.a a2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("launchCount", this.getAppLaunchCount());
        hashMap.put("launchTime", this.getAppLaunchTime());
        hashMap.put("deviceId", this.getDeviceId());
        hashMap.put("connection", ai.getNetworkClass(this.getApplicationContext()));
        hashMap.put("osVersion", Build.VERSION.RELEASE);
        hashMap.put("deviceManufacturer", Build.MANUFACTURER);
        hashMap.put("deviceModel", Build.MODEL);
        HashMap<String, HashMap> hashMap2 = this.getNotificationSettings();
        if (hashMap2 != null) {
            hashMap.put("notificationSettings", hashMap2);
        }
        if (!this.getUserInfo().isEmpty()) {
            hashMap.put("userInfo", this.getUserInfo());
        }
        new f(this, a2, hashMap, bl).execute(new Void[]{null, null, null});
    }

    private HashMap<String, HashMap> getNotificationSettings() {
        if (this.notificationSettings != null) {
            HashMap<String, HashMap> hashMap = new HashMap<String, HashMap>();
            Iterator iterator = this.notificationSettings.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                JSONObject jSONObject = this.notificationSettings.optJSONObject(string2);
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                hashMap2.put("alert", jSONObject.optString("alert", null));
                hashMap2.put("sound", jSONObject.optString("sound", null));
                hashMap.put(string2, hashMap2);
            }
            return hashMap;
        }
        return null;
    }

    private void retryRegistrationBackoff() {
        if (++failed_tries <= 3) {
            h h2 = new h(this);
            worker.schedule(h2, (long)Math.pow(2.0, failed_tries) * 1000L, TimeUnit.SECONDS);
        }
    }

    private String getDeviceId() {
        return Build.SERIAL;
    }

    private AdpPushClient setBadge(int n2) {
        this.getSharedPreferences().edit().putInt("androidBadge", n2).apply();
        ShortcutBadger.with((Context)this.getApplicationContext()).count(n2);
        this.eventBus.post(new BadgeUpdate(n2));
        return this;
    }

    private void updateLaunchStats() {
        int n2 = this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
        this.getSharedPreferences().edit().putInt(APPLICATION_LAUNCH, ++n2).apply();
        this.getSharedPreferences().edit().putLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis()).apply();
    }

    public int getAppLaunchCount() {
        return this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 1);
    }

    public long getAppLaunchTime() {
        return this.getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis());
    }

    public int getBadge() {
        return this.getSharedPreferences().getInt("androidBadge", 0);
    }

    public AdpPushClient resetBadge() {
        ((NotificationManager)this.getApplicationContext().getSystemService("notification")).cancelAll();
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putInt("androidUnseenBadge", 0);
        editor.apply();
        return this.setBadge(0);
    }

    public void unregister() {
        this.deleteInstallation(new i(this));
    }

    public String getInstallationId() {
        String string2 = this.decrypt(this.getSharedPreferences().getString("installationId", null));
        if (string2 != null) {
            try {
                return (String)new JSONArray(string2).get(0);
            }
            catch (JSONException jSONException) {
                new StringBuilder("Cannot parse installation id '").append(string2).append("'");
            }
        }
        return null;
    }

    private void deleteInstallation(Callback callback) {
        b.f<b.c> f2 = this.adapter.createRepository("installation");
        b.a a2 = new b.a(this.getApplicationContext(), this.adapter);
        f2.createModel(d.a.getProperties(a2, false, false)).destroy(new j(this, callback, a2));
    }

    private void updateInstallation(Map<String, ?> map) {
        this.updateInstallation(map, new k(this));
    }

    private void updateInstallation(Map<String, ?> map, Callback<b.a> callback) {
        b.a a2 = new b.a(this.getApplicationContext(), this.adapter);
        a2.setAppId(this.getAppId());
        a2.setAppVersion(SDK_VERSION);
        a2.setUserId(this.getUserId());
        a2.setSubscriptions(this.topics);
        this.updateInstallation(a2, map, callback);
    }

    private b.a getLocalInstallation() {
        b.a a2 = new b.a(this.getApplicationContext(), this.adapter);
        a2.setAppId(this.getAppId());
        a2.setAppVersion(SDK_VERSION);
        a2.setUserId(this.getUserId());
        a2.setSubscriptions(this.topics);
        return a2;
    }

    private void updateInstallation(b.a a2, Map<String, ?> map, Callback<b.a> callback) {
        b.c c2 = this.adapter.createRepository("installation").createModel(d.a.getProperties(a2, false, false));
        c2.putAll(map);
        new l(this, c2, callback, a2).execute(new Void[]{null, null, null});
    }

    public void requestVerificationCode(String string2, String string3, Callback callback) {
        b.f<b.c> f2 = this.adapter.createRepository("verification");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("userId", string2);
        hashMap.put("appId", this.appId);
        hashMap.put("media", string3);
        f2.invokeStaticMethod("requestCode", hashMap, new o(this, callback));
    }

    public void requestVerificationCode(String string2, Callback callback) {
        this.requestVerificationCode(string2, "sms", callback);
    }

    public void verifyUserCode(String string2, String string3, Callback callback) {
        b.f<b.c> f2 = this.adapter.createRepository("verification");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("userId", string2);
        hashMap.put("appId", this.appId);
        hashMap.put("code", string3);
        f2.invokeStaticMethod("verify", hashMap, new p(this, callback));
    }

    boolean isFreshStart() {
        return this.isFreshStart;
    }

    public boolean isForeground() {
        return this.getForegroundManager().isForeground();
    }

    public boolean isFocused() {
        return this.isForeground() && this.getActivityClass().getName().equals(this.getForegroundManager().getActiveActivityClassName());
    }

    public boolean isBackground() {
        return this.getForegroundManager().isBackground();
    }

    public AdpPushClient addAppListener(AppListener appListener) {
        this.getForegroundManager().addListener(appListener);
        return this;
    }

    private ForegroundManager getForegroundManager() {
        return this.foreground;
    }

    public Class getActivityClass() {
        return this.activityClass;
    }

    private Context getApplicationContext() {
        return this.context;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isRegistered() {
        return this.getSharedPreferences().getString("userId", null) != null;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getNotificationIcon() {
        if (this.notificationIcon == -1) {
            try {
                PackageInfo packageInfo = this.getApplicationContext().getPackageManager().getPackageInfo(this.getApplicationContext().getPackageName(), 0);
                return this.getApplicationContext().getPackageManager().getApplicationInfo((String)packageInfo.packageName, (int)0).icon;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return -1;
            }
        }
        return this.notificationIcon;
    }

    public void setNotificationIcon(int n2) {
        this.notificationIcon = n2;
    }

    public int getNotificationIconSilhouette() {
        if (this.notificationIconSilhouette == -1) {
            return this.getNotificationIcon();
        }
        return this.notificationIconSilhouette;
    }

    public void setNotificationIconSilhouette(int n2) {
        this.notificationIconSilhouette = n2;
    }

    public HashMap<String, Object> getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(HashMap<String, Object> hashMap) {
        this.userInfo = hashMap;
    }

    public AdpPushClient setDevelopment(boolean bl) {
        this.useDev = bl;
        this.initializeAdapter();
        return this;
    }

    public AdpPushClient setSticky(boolean bl) {
        FORCE_STICKY = bl;
        return this;
    }

    public AdpPushClient enableDeliveryTopic() {
        this.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", true).apply();
        return this;
    }

    public AdpPushClient disableDeliveryTopic() {
        this.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", false).apply();
        return this;
    }

    public boolean deliveryTopicEnabled() {
        return this.getSharedPreferences().getBoolean("deliveryTopicEnabled", false);
    }

    private AdpPushClient setSecure(boolean bl) {
        this.useSecure = bl;
        this.initializeAdapter();
        return this;
    }

    public String[] getSubscriptions() {
        return this.topics;
    }

    private SharedPreferences getSharedPreferences() {
        return this.getApplicationContext().getSharedPreferences(b.a.SHARED_PREFERENCES_NAME, 0);
    }

    public AdpPushClient setCurrentActivity(Activity activity) {
        this.currentActivity = activity;
        return this;
    }

    void notifyNewMessage(PushMessage pushMessage) {
        Class object = this.activityClass;
        if (AdpPushClient.hasNotified(pushMessage.getId())) {
            return;
        }
        for (NotificationHandler notificationHandler : this.handlers) {
            ChabokNotification chabokNotification;
            Class object2 = notificationHandler.getActivityClass(chabokNotification = new ChabokNotification(pushMessage, 0));
            if (object2 == null) continue;
            object = object2;
        }
        GcmMessageHandler.sendNotification(this.getApplicationContext(), object, new ChabokNotification(pushMessage, 0));
    }

    static boolean hasNotified(String string2) {
        return notifs.contains(string2);
    }

    boolean addNotifiedMessage(String string2) {
        boolean bl = notifs.add(string2);
        this.getSharedPreferences().edit().putStringSet("notifs", new HashSet<String>(Arrays.asList(notifs.toArray(new String[notifs.size()])))).apply();
        return bl;
    }

    Class getNotifActivityClass(Bundle bundle) throws ClassNotFoundException {
        Class object = this.activityClass;
        for (NotificationHandler notificationHandler : this.handlers) {
            ChabokNotification chabokNotification;
            Class object2 = notificationHandler.getActivityClass(chabokNotification = new ChabokNotification(bundle.getString("messageId"), bundle.getString("messageFrom"), bundle.getString("message"), Integer.valueOf(bundle.getString("androidBadge", "0")), bundle));
            if (object2 == null) continue;
            object = object2;
        }
        return object;
    }

    boolean prepareNotification(ChabokNotification chabokNotification, NotificationCompat.Builder builder) {
        boolean bl = true;
        for (NotificationHandler notificationHandler : this.handlers) {
            bl &= notificationHandler.buildNotification(chabokNotification, builder);
        }
        return bl;
    }

    public void addNotificationHandler(NotificationHandler notificationHandler) {
        this.handlers.add(notificationHandler);
    }

    public void ifHuaweiAlert(Activity activity) {
        this.ifHuaweiAlert(activity, "\u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647", String.format("\u0628\u0631\u0646\u0627\u0645\u0647 %s \u0628\u0631\u0627\u06cc \u06a9\u0627\u0631\u06a9\u0631\u062f \u062f\u0631\u0633\u062a \u0645\u06cc\u200c\u0628\u0627\u06cc\u0633\u062a \u062f\u0631 \u0644\u06cc\u0633\u062a \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647 \u0641\u0639\u0627\u0644 \u0634\u0648\u062f.%n", this.getApplicationContext().getString(R.string.app_name)));
    }

    public void ifHuaweiAlert(Activity activity, String string2, String string3) {
        this.getApplicationContext();
        SharedPreferences sharedPreferences = activity.getSharedPreferences("ProtectedApps", 0);
        if (!sharedPreferences.getBoolean("skipProtectedAppsMessage", false)) {
            sharedPreferences = sharedPreferences.edit();
            Intent intent = new Intent();
            intent.setClassName("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity");
            if (this.isCallable(intent)) {
                intent = new CheckBox(this.getApplicationContext());
                intent.setTextColor(-16777216);
                intent.setText((CharSequence)"\u062f\u06cc\u06af\u0631 \u0627\u06cc\u0646 \u067e\u06cc\u0627\u0645 \u0631\u0627 \u0646\u0634\u0627\u0646 \u0646\u062f\u0647");
                intent.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)new q(this, (SharedPreferences.Editor)sharedPreferences));
                new AlertDialog.Builder((Context)activity).setIcon(17301543).setTitle((CharSequence)string2).setMessage((CharSequence)string3).setView((View)intent).setPositiveButton((CharSequence)"\u0628\u0631\u0648 \u0628\u0647 \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647", (DialogInterface.OnClickListener)new s(this)).setNegativeButton((CharSequence)"\u0644\u063a\u0648", null).show();
                return;
            }
            sharedPreferences.putBoolean("skipProtectedAppsMessage", true);
            sharedPreferences.apply();
        }
    }

    private boolean isCallable(Intent intent) {
        return this.getApplicationContext().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    private void huaweiProtectedApps() {
        try {
            String string2 = "am start -n com.huawei.systemmanager/.optimize.process.ProtectActivity";
            if (Build.VERSION.SDK_INT >= 17) {
                string2 = string2 + " --user " + this.getUserSerial();
            }
            Runtime.getRuntime().exec(string2);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private String getUserSerial() {
        Object object = this.getApplicationContext().getSystemService("user");
        if (object == null) {
            return "";
        }
        try {
            Object object2 = Process.class.getMethod("myUserHandle", null).invoke(Process.class, null);
            object = (Long)object.getClass().getMethod("getSerialNumberForUser", object2.getClass()).invoke(object, object2);
            if (object != null) {
                return String.valueOf(object);
            }
            return "";
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            return "";
        }
    }

    public String encrypt(String string2) {
        try {
            byte[] byArray = string2 != null ? string2.getBytes("UTF-8") : new byte[]{};
            SecretKey secretKey = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(new PBEKeySpec("BEHRAD".toCharArray()));
            Cipher cipher = Cipher.getInstance("PBEWithMD5AndDES");
            cipher.init(1, (Key)secretKey, new PBEParameterSpec(Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id").getBytes("UTF-8"), 20));
            return new String(ae.encode(cipher.doFinal(byArray), 2), "UTF-8");
        }
        catch (Exception exception) {
            this.getClass().getName();
            new StringBuilder("Warning, could not encrypt the value.  It may be stored in plaintext.  ").append(exception.getMessage());
            return string2;
        }
    }

    public String decrypt(String string2) {
        try {
            byte[] byArray = string2 != null ? ae.decode(string2, 0) : new byte[]{};
            SecretKey secretKey = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(new PBEKeySpec("BEHRAD".toCharArray()));
            Cipher cipher = Cipher.getInstance("PBEWithMD5AndDES");
            cipher.init(2, (Key)secretKey, new PBEParameterSpec(Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id").getBytes("UTF-8"), 20));
            return new String(cipher.doFinal(byArray), "UTF-8");
        }
        catch (Exception exception) {
            this.getClass().getName();
            new StringBuilder("Warning, could not decrypt the value.  It may be stored in plaintext.  ").append(exception.getMessage());
            return string2;
        }
    }

    boolean shouldBeSticky() {
        if (FORCE_STICKY) {
            return true;
        }
        if (this.appId != null && this.appId.contains("ansar-")) {
            return true;
        }
        return !this.isGCMSupported();
    }

    public boolean isGCMSupported() {
        return !this.getSharedPreferences().getBoolean("noGCM", false);
    }

    static /* synthetic */ boolean access$000(AdpPushClient adpPushClient) {
        return adpPushClient.isFreshStart;
    }

    static /* synthetic */ void access$100(AdpPushClient adpPushClient) {
        adpPushClient.updateLaunchStats();
    }

    static /* synthetic */ f.c access$200(AdpPushClient adpPushClient) {
        return adpPushClient.eventBus;
    }

    static /* synthetic */ void access$300(AdpPushClient adpPushClient) {
        adpPushClient.doRegister();
    }

    static /* synthetic */ boolean access$002(AdpPushClient adpPushClient, boolean bl) {
        adpPushClient.isFreshStart = bl;
        return adpPushClient.isFreshStart;
    }

    static /* synthetic */ Context access$400(AdpPushClient adpPushClient) {
        return adpPushClient.getApplicationContext();
    }

    static /* synthetic */ Activity access$502(AdpPushClient adpPushClient, Activity activity) {
        adpPushClient.currentActivity = activity;
        return adpPushClient.currentActivity;
    }

    static /* synthetic */ boolean access$600(AdpPushClient adpPushClient) {
        return adpPushClient.registeredOnce;
    }

    static /* synthetic */ ForegroundManager access$700(AdpPushClient adpPushClient) {
        return adpPushClient.foreground;
    }

    static /* synthetic */ boolean access$802(AdpPushClient adpPushClient, boolean bl) {
        adpPushClient.registering = bl;
        return adpPushClient.registering;
    }

    static /* synthetic */ boolean access$602(AdpPushClient adpPushClient, boolean bl) {
        adpPushClient.registeredOnce = bl;
        return adpPushClient.registeredOnce;
    }

    static /* synthetic */ AdpPushClient access$900(AdpPushClient adpPushClient, boolean bl) {
        return adpPushClient.updateRegistration(bl);
    }

    static /* synthetic */ boolean access$1000(AdpPushClient adpPushClient) {
        return adpPushClient.restartServiceState;
    }

    static /* synthetic */ void access$1100(AdpPushClient adpPushClient, b.a a2, boolean bl) {
        adpPushClient.saveInstallation(a2, bl);
    }

    static /* synthetic */ boolean access$1002(AdpPushClient adpPushClient, boolean bl) {
        adpPushClient.restartServiceState = bl;
        return adpPushClient.restartServiceState;
    }

    static /* synthetic */ int access$1202(int n2) {
        failed_tries = n2;
        return failed_tries;
    }

    static /* synthetic */ void access$1300(AdpPushClient adpPushClient) {
        adpPushClient.retryRegistrationBackoff();
    }

    static /* synthetic */ void access$1400(AdpPushClient adpPushClient) {
        adpPushClient.cleanData();
    }

    static /* synthetic */ void access$1500(AdpPushClient adpPushClient) {
        adpPushClient.huaweiProtectedApps();
    }

    static {
        FORCE_STICKY = false;
        failed_tries = 0;
        notifs = new af<String>(200);
        worker = Executors.newSingleThreadScheduledExecutor();
        pushClientInstance = null;
    }
}

