/*
 * Decompiled with CFR 0.152.
 */
package AOP;

import AOP.HXH;
import AOP.IZX;
import AOP.SUU;
import AOP.UFF;
import DYH.NZV;
import LMH.MRR;
import java.io.UnsupportedEncodingException;

public final class RGI {
    public static final String TOPIC_LEVEL_SEPARATOR = "/";
    public static final String MULTI_LEVEL_WILDCARD = "#";
    public static final String SINGLE_LEVEL_WILDCARD = "+";
    public static final String MULTI_LEVEL_WILDCARD_PATTERN = "/#";
    public static final String TOPIC_WILDCARDS = "#+";
    private NZV NZV;
    private String MRR;

    public RGI(String name, NZV comms) {
        this.NZV = comms;
        this.MRR = name;
    }

    public final IZX publish(byte[] payload, int qos, boolean retained) throws HXH, SUU {
        UFF message = new UFF(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return this.publish(message);
    }

    public final IZX publish(UFF message) throws HXH, SUU {
        IZX token = new IZX(this.NZV.getClient().getClientId());
        token.setMessage(message);
        UFF uFF = message;
        RGI rGI = this;
        this.NZV.sendNoWait(new IZX.SUU(rGI.getName(), uFF), token);
        token.internalTok.waitUntilSent();
        return token;
    }

    public final String getName() {
        return this.MRR;
    }

    public final String toString() {
        return this.getName();
    }

    public static void validate(String topicString, boolean wildcardAllowed) {
        int topicLen;
        try {
            topicLen = topicString.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        if (topicLen <= 0 || topicLen > 65535) {
            throw new IllegalArgumentException(String.format("Invalid topic length, should be in range[%d, %d]!", new Integer(1), new Integer(65535)));
        }
        if (wildcardAllowed) {
            if (LMH.MRR.equalsAny(topicString, new String[]{MULTI_LEVEL_WILDCARD, SINGLE_LEVEL_WILDCARD})) {
                return;
            }
            if (LMH.MRR.countMatches(topicString, MULTI_LEVEL_WILDCARD) > 1 || topicString.contains(MULTI_LEVEL_WILDCARD) && !topicString.endsWith(MULTI_LEVEL_WILDCARD_PATTERN)) {
                throw new IllegalArgumentException("Invalid usage of multi-level wildcard in topic string: " + topicString);
            }
            RGI.NZV(topicString);
            return;
        }
        if (LMH.MRR.containsAny((CharSequence)topicString, TOPIC_WILDCARDS)) {
            throw new IllegalArgumentException("The topic name MUST NOT contain any wildcard characters (#+)");
        }
    }

    private static void NZV(String topicString) {
        char singleLevelWildcardChar = SINGLE_LEVEL_WILDCARD.charAt(0);
        char topicLevelSeparatorChar = TOPIC_LEVEL_SEPARATOR.charAt(0);
        char[] chars = topicString.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            char next;
            char prev = i - 1 >= 0 ? chars[i - 1] : (char)'\u0000';
            char c = next = i + 1 < length ? chars[i + 1] : (char)'\u0000';
            if (chars[i] != singleLevelWildcardChar || (prev == topicLevelSeparatorChar || prev == '\u0000') && (next == topicLevelSeparatorChar || next == '\u0000')) continue;
            throw new IllegalArgumentException(String.format("Invalid usage of single-level wildcard in topic string '%s'!", topicString));
        }
    }
}

