/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.S3Verified;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.util.EtagUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@S3Verified(year=2025)
public record CompletedPart(@JsonProperty(value="ChecksumCRC32") String checksumCRC32, @JsonProperty(value="ChecksumCRC32C") String checksumCRC32C, @JsonProperty(value="ChecksumCRC64NVME") String checksumCRC64NVME, @JsonProperty(value="ChecksumSHA1") String checksumSHA1, @JsonProperty(value="ChecksumSHA256") String checksumSHA256, @JsonProperty(value="ETag") String etag, @JsonProperty(value="PartNumber") Integer partNumber) {
    public CompletedPart {
        etag = EtagUtil.normalizeEtag(etag);
    }

    public CompletedPart(ChecksumAlgorithm checksumAlgorithm, String checksum, String etag, Integer partNumber) {
        this(checksumAlgorithm == ChecksumAlgorithm.CRC32 ? checksum : null, checksumAlgorithm == ChecksumAlgorithm.CRC32C ? checksum : null, checksumAlgorithm == ChecksumAlgorithm.CRC64NVME ? checksum : null, checksumAlgorithm == ChecksumAlgorithm.SHA1 ? checksum : null, checksumAlgorithm == ChecksumAlgorithm.SHA256 ? checksum : null, etag, partNumber);
    }

    @JsonIgnore
    public String checksum(ChecksumAlgorithm algorithm) {
        return switch (algorithm) {
            default -> throw new IncompatibleClassChangeError();
            case ChecksumAlgorithm.CRC32 -> this.checksumCRC32;
            case ChecksumAlgorithm.CRC32C -> this.checksumCRC32C;
            case ChecksumAlgorithm.CRC64NVME -> this.checksumCRC64NVME;
            case ChecksumAlgorithm.SHA1 -> this.checksumSHA1;
            case ChecksumAlgorithm.SHA256 -> this.checksumSHA256;
        };
    }
}

