/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.dto.Tagging;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;

class TaggingHeaderConverter
implements Converter<String, List<Tag>> {
    private static final String XML_START = "<";
    private static final String XML_END = ">";
    private final XmlMapper xmlMapper;

    public TaggingHeaderConverter(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    public @Nullable List<Tag> convert(String source) {
        if (source.startsWith(XML_START) && source.endsWith(XML_END)) {
            return this.convertTagXml(source);
        }
        return TaggingHeaderConverter.convertTagPairs(source);
    }

    private @Nullable List<Tag> convertTagXml(String source) {
        try {
            Tagging tagging = (Tagging)this.xmlMapper.readValue(source, Tagging.class);
            if (tagging.tagSet() != null) {
                return tagging.tagSet().tags();
            }
            return null;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to parse XML tags from header: " + source, e);
        }
    }

    private static @Nullable List<Tag> convertTagPairs(String source) {
        String[] tagPairs;
        if (source.isEmpty()) {
            return null;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String tag : tagPairs = source.split("&")) {
            tags.add(new Tag(tag));
        }
        return tags.isEmpty() ? null : tags;
    }
}

