/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.S3Verified;
import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.AccessControlPolicy;
import com.adobe.testing.s3mock.dto.Checksum;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.ChecksumMode;
import com.adobe.testing.s3mock.dto.CopyObjectResult;
import com.adobe.testing.s3mock.dto.CopySource;
import com.adobe.testing.s3mock.dto.Delete;
import com.adobe.testing.s3mock.dto.DeleteResult;
import com.adobe.testing.s3mock.dto.GetObjectAttributesOutput;
import com.adobe.testing.s3mock.dto.LegalHold;
import com.adobe.testing.s3mock.dto.ObjectAttributes;
import com.adobe.testing.s3mock.dto.ObjectCannedACL;
import com.adobe.testing.s3mock.dto.ObjectKey;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Retention;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.dto.TagSet;
import com.adobe.testing.s3mock.dto.Tagging;
import com.adobe.testing.s3mock.service.BucketService;
import com.adobe.testing.s3mock.service.FileChecksum;
import com.adobe.testing.s3mock.service.ObjectService;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.AwsHttpHeaders;
import com.adobe.testing.s3mock.util.CannedAclUtil;
import com.adobe.testing.s3mock.util.HeaderUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRange;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@CrossOrigin(origins={"*"}, exposedHeaders={"*"})
@Controller
@RequestMapping(value={"${com.adobe.testing.s3mock.contextPath:}"})
public class ObjectController {
    private static final String RANGES_BYTES = "bytes";
    private final BucketService bucketService;
    private final ObjectService objectService;

    public ObjectController(BucketService bucketService, ObjectService objectService) {
        this.bucketService = bucketService;
        this.objectService = objectService;
    }

    @PostMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"delete"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<DeleteResult> deleteObjects(@PathVariable String bucketName, @RequestBody Delete body) {
        this.bucketService.verifyBucketExists(bucketName);
        return ResponseEntity.ok((Object)this.objectService.deleteObjects(bucketName, body));
    }

    @PostMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"!delete"}, produces={"application/xml"}, consumes={"multipart/form-data"})
    public ResponseEntity<Void> postObject(@PathVariable String bucketName, @RequestParam(value="key") ObjectKey key, @RequestParam(value="tagging", required=false) @Nullable List<Tag> tags, @RequestParam(value="Content-Type", required=false) String contentType, @RequestParam(value="Content-MD5", required=false) String contentMd5, @RequestParam(value="x-amz-storage-class", required=false, defaultValue="STANDARD") StorageClass storageClass, @RequestPart(value="file") MultipartFile file) throws IOException {
        String checksum = null;
        ChecksumAlgorithm checksumAlgorithm = null;
        FileChecksum tempFileAndChecksum = this.objectService.toTempFile(file.getInputStream());
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        Path tempFile = tempFileAndChecksum.path();
        this.objectService.verifyMd5(tempFile, contentMd5);
        Owner owner = Owner.DEFAULT_OWNER;
        S3ObjectMetadata s3ObjectMetadata = this.objectService.putS3Object(bucketName, key.key(), HeaderUtil.mediaTypeFrom(contentType).toString(), Map.of(), tempFile, Map.of(), Map.of(), tags, checksumAlgorithm, checksum, owner, storageClass);
        FileUtils.deleteQuietly((File)tempFile.toFile());
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> h.setAll(HeaderUtil.checksumHeaderFrom(s3ObjectMetadata)))).headers(h -> {
            if (s3ObjectMetadata.encryptionHeaders() != null) {
                h.setAll(s3ObjectMetadata.encryptionHeaders());
            }
        })).lastModified(s3ObjectMetadata.lastModified())).eTag(s3ObjectMetadata.etag())).headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).build();
    }

    @RequestMapping(value={"/{bucketName:.+}/{*key}"}, method={RequestMethod.HEAD})
    @S3Verified(year=2025)
    public ResponseEntity<Void> headObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="If-Match", required=false) List<String> match, @RequestHeader(value="If-None-Match", required=false) List<String> noneMatch, @RequestHeader(value="If-Modified-Since", required=false) List<Instant> ifModifiedSince, @RequestHeader(value="If-Unmodified-Since", required=false) List<Instant> ifUnmodifiedSince, @RequestHeader(value="Range", required=false) HttpRange range, @RequestParam(value="partNumber", required=false) String partNumber, @RequestParam(value="versionId", required=false) String versionId, @RequestParam Map<String, String> queryParams) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key(), versionId);
        this.objectService.verifyObjectMatching(match, noneMatch, ifModifiedSince, ifUnmodifiedSince, s3ObjectMetadata);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(s3ObjectMetadata.etag())).header("Accept-Ranges", new String[]{RANGES_BYTES})).lastModified(s3ObjectMetadata.lastModified())).contentLength(Long.parseLong(s3ObjectMetadata.size())).contentType(HeaderUtil.mediaTypeFrom(s3ObjectMetadata.contentType())).headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).headers(h -> {
            if (s3ObjectMetadata.storeHeaders() != null) {
                h.setAll(s3ObjectMetadata.storeHeaders());
            }
        })).headers(h -> h.setAll(HeaderUtil.userMetadataHeadersFrom(s3ObjectMetadata)))).headers(h -> {
            if (s3ObjectMetadata.encryptionHeaders() != null) {
                h.setAll(s3ObjectMetadata.encryptionHeaders());
            }
        })).headers(h -> h.setAll(HeaderUtil.checksumHeaderFrom(s3ObjectMetadata)))).headers(h -> h.setAll(HeaderUtil.storageClassHeadersFrom(s3ObjectMetadata)))).headers(h -> h.setAll(HeaderUtil.overrideHeadersFrom(queryParams)))).build();
    }

    @DeleteMapping(value={"/{bucketName:.+}/{*key}"}, params={"!lifecycle", "!tagging"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> deleteObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="If-Match", required=false) List<String> match, @RequestHeader(value="x-amz-if-match-last-modified-time", required=false) List<Instant> matchLastModifiedTime, @RequestHeader(value="x-amz-if-match-size", required=false) List<Long> matchSize, @RequestParam(value="versionId", required=false) String versionId) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = null;
        try {
            s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key(), versionId);
        }
        catch (S3Exception s3Exception) {
            // empty catch block
        }
        this.objectService.verifyObjectMatching(match, matchLastModifiedTime, matchSize, s3ObjectMetadata);
        String s3ObjectMetadataVersionId = s3ObjectMetadata != null ? s3ObjectMetadata.versionId() : null;
        boolean deleted = this.objectService.deleteObject(bucketName, key.key(), versionId);
        return ResponseEntity.noContent().header("x-amz-delete-marker", new String[]{String.valueOf(deleted)}).headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadataVersionId != null) {
                h.set("x-amz-version-id", s3ObjectMetadataVersionId);
            }
        }).headers(h -> {
            block3: {
                if (bucket.isVersioningEnabled()) {
                    try {
                        this.objectService.verifyObjectExists(bucketName, key.key(), versionId);
                    }
                    catch (S3Exception e) {
                        if (e != S3Exception.NO_SUCH_KEY_DELETE_MARKER) break block3;
                        h.set("x-amz-delete-marker", "true");
                    }
                }
            }
        }).build();
    }

    @GetMapping(value={"/{bucketName:.+}/{*key}"}, params={"!uploads", "!uploadId", "!tagging", "!legal-hold", "!retention", "!acl", "!attributes"})
    @S3Verified(year=2025)
    public ResponseEntity<StreamingResponseBody> getObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="x-amz-checksum-mode", required=false, defaultValue="DISABLED") ChecksumMode mode, @RequestHeader(value="If-Match", required=false) @Nullable List<String> match, @RequestHeader(value="If-None-Match", required=false) @Nullable List<String> noneMatch, @RequestHeader(value="If-Modified-Since", required=false) @Nullable List<Instant> ifModifiedSince, @RequestHeader(value="If-Unmodified-Since", required=false) @Nullable List<Instant> ifUnmodifiedSince, @RequestParam(value="partNumber", required=false) @Nullable String partNumber, @RequestHeader(value="Range", required=false) @Nullable HttpRange range, @RequestParam(value="versionId", required=false) @Nullable String versionId, @RequestParam Map<String, String> queryParams) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key(), versionId);
        this.objectService.verifyObjectMatching(match, noneMatch, ifModifiedSince, ifUnmodifiedSince, s3ObjectMetadata);
        if (range != null) {
            return this.getObjectWithRange(range, s3ObjectMetadata);
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(s3ObjectMetadata.etag())).header("Accept-Ranges", new String[]{RANGES_BYTES})).lastModified(s3ObjectMetadata.lastModified())).contentLength(Long.parseLong(s3ObjectMetadata.size())).contentType(HeaderUtil.mediaTypeFrom(s3ObjectMetadata.contentType())).headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).headers(h -> {
            if (s3ObjectMetadata.storeHeaders() != null) {
                h.setAll(s3ObjectMetadata.storeHeaders());
            }
        })).headers(h -> h.setAll(HeaderUtil.userMetadataHeadersFrom(s3ObjectMetadata)))).headers(h -> {
            if (s3ObjectMetadata.encryptionHeaders() != null) {
                h.setAll(s3ObjectMetadata.encryptionHeaders());
            }
        })).headers(h -> {
            if (mode == ChecksumMode.ENABLED) {
                h.setAll(HeaderUtil.checksumHeaderFrom(s3ObjectMetadata));
            }
        })).headers(h -> h.setAll(HeaderUtil.storageClassHeadersFrom(s3ObjectMetadata)))).headers(h -> h.setAll(HeaderUtil.overrideHeadersFrom(queryParams)))).body(outputStream -> Files.copy(s3ObjectMetadata.dataPath(), outputStream));
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, params={"acl"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> putObjectAcl(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="x-amz-acl", required=false) @Nullable ObjectCannedACL cannedAcl, @RequestParam(value="versionId", required=false) @Nullable String versionId, @RequestBody(required=false) @Nullable AccessControlPolicy body) {
        AccessControlPolicy policy;
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key(), versionId);
        if (body != null) {
            policy = body;
        } else if (cannedAcl != null) {
            policy = CannedAclUtil.policyForCannedAcl(cannedAcl);
        } else {
            return ResponseEntity.badRequest().build();
        }
        this.objectService.setAcl(bucketName, key.key(), versionId, policy);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).build();
    }

    @GetMapping(value={"/{bucketName:.+}/{*key}"}, params={"acl"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<AccessControlPolicy> getObjectAcl(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam(value="versionId", required=false) @Nullable String versionId) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key(), versionId);
        AccessControlPolicy acl = this.objectService.getAcl(bucketName, key.key(), versionId);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).body((Object)acl);
    }

    @GetMapping(value={"/{bucketName:.+}/{*key}"}, params={"tagging"}, produces={"application/xml", "application/xml;charset=UTF-8"})
    @S3Verified(year=2025)
    public ResponseEntity<Tagging> getObjectTagging(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam(value="versionId", required=false) @Nullable String versionId) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key(), versionId);
        Tagging tagging = null;
        if (s3ObjectMetadata.tags() != null && !s3ObjectMetadata.tags().isEmpty()) {
            tagging = new Tagging(new TagSet(s3ObjectMetadata.tags()));
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(s3ObjectMetadata.etag())).lastModified(s3ObjectMetadata.lastModified())).headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).body((Object)tagging);
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, params={"tagging"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> putObjectTagging(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam(value="versionId", required=false) @Nullable String versionId, @RequestBody Tagging body) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key(), versionId);
        this.objectService.verifyObjectTags(body.tagSet().tags());
        this.objectService.setObjectTags(bucketName, key.key(), versionId, body.tagSet().tags());
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(s3ObjectMetadata.etag())).lastModified(s3ObjectMetadata.lastModified())).headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).build();
    }

    @DeleteMapping(value={"/{bucketName:.+}/{*key}"}, params={"tagging"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> deleteObjectTagging(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam(value="versionId", required=false) @Nullable String versionId) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key(), versionId);
        this.objectService.setObjectTags(bucketName, key.key(), versionId, null);
        return ResponseEntity.noContent().headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        }).build();
    }

    @GetMapping(value={"/{bucketName:.+}/{*key}"}, params={"legal-hold"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<LegalHold> getLegalHold(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam(value="versionId", required=false) @Nullable String versionId) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketObjectLockEnabled(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectLockConfiguration(bucketName, key.key(), versionId);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).body((Object)s3ObjectMetadata.legalHold());
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, params={"legal-hold"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> putLegalHold(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam(value="versionId", required=false) @Nullable String versionId, @RequestBody LegalHold body) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketObjectLockEnabled(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key(), versionId);
        this.objectService.setLegalHold(bucketName, key.key(), versionId, body);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).build();
    }

    @GetMapping(value={"/{bucketName:.+}/{*key}"}, params={"retention"}, produces={"application/xml"})
    public ResponseEntity<Retention> getObjectRetention(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam(value="versionId", required=false) @Nullable String versionId) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketObjectLockEnabled(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectLockConfiguration(bucketName, key.key(), versionId);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).body((Object)s3ObjectMetadata.retention());
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, params={"retention"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> putObjectRetention(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam(value="versionId", required=false) @Nullable String versionId, @RequestBody Retention body) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketObjectLockEnabled(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key(), versionId);
        this.objectService.verifyRetention(body);
        this.objectService.setRetention(bucketName, key.key(), versionId, body);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).build();
    }

    @GetMapping(value={"/{bucketName:[a-z0-9.-]+}/{*key}"}, params={"attributes"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<GetObjectAttributesOutput> getObjectAttributes(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="If-Match", required=false) @Nullable List<String> match, @RequestHeader(value="If-None-Match", required=false) @Nullable List<String> noneMatch, @RequestHeader(value="If-Modified-Since", required=false) @Nullable List<Instant> ifModifiedSince, @RequestHeader(value="If-Unmodified-Since", required=false) @Nullable List<Instant> ifUnmodifiedSince, @RequestHeader(value="x-amz-object-attributes") List<String> objectAttributes, @RequestParam(value="versionId", required=false) @Nullable String versionId) {
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(bucketName, key.key(), versionId);
        this.objectService.verifyObjectMatching(match, noneMatch, ifModifiedSince, ifUnmodifiedSince, s3ObjectMetadata);
        String etag = s3ObjectMetadata.etag().replace("\"", "");
        long objectSize = Long.parseLong(s3ObjectMetadata.size());
        StorageClass storageClass = s3ObjectMetadata.storageClass() == null ? StorageClass.STANDARD : s3ObjectMetadata.storageClass();
        GetObjectAttributesOutput response = new GetObjectAttributesOutput(Checksum.from(s3ObjectMetadata), objectAttributes.contains(ObjectAttributes.ETAG.toString()) ? etag : null, null, objectAttributes.contains(ObjectAttributes.OBJECT_SIZE.toString()) ? Long.valueOf(objectSize) : null, objectAttributes.contains(ObjectAttributes.STORAGE_CLASS.toString()) ? storageClass : null);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().lastModified(s3ObjectMetadata.lastModified())).headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).body((Object)response);
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, params={"!uploadId", "!tagging", "!legal-hold", "!retention", "!acl"}, headers={"!x-amz-copy-source"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> putObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="x-amz-tagging", required=false) @Nullable List<Tag> tags, @RequestHeader(value="Content-Type", required=false) @Nullable String contentType, @RequestHeader(value="Content-MD5", required=false) @Nullable String contentMd5, @RequestHeader(value="If-Match", required=false) @Nullable List<String> match, @RequestHeader(value="If-None-Match", required=false) @Nullable List<String> noneMatch, @RequestHeader(value="x-amz-storage-class", required=false, defaultValue="STANDARD") StorageClass storageClass, @RequestHeader HttpHeaders httpHeaders, InputStream inputStream) {
        ChecksumAlgorithm algorithmFromHeader;
        String checksum = null;
        ChecksumAlgorithm checksumAlgorithm = null;
        FileChecksum tempFileAndChecksum = this.objectService.toTempFile(inputStream, httpHeaders);
        ChecksumAlgorithm algorithmFromSdk = HeaderUtil.checksumAlgorithmFromSdk(httpHeaders);
        if (algorithmFromSdk != null) {
            checksum = tempFileAndChecksum.checksum();
            checksumAlgorithm = algorithmFromSdk;
        }
        if ((algorithmFromHeader = HeaderUtil.checksumAlgorithmFromHeader(httpHeaders)) != null) {
            checksum = HeaderUtil.checksumFrom(httpHeaders);
            checksumAlgorithm = algorithmFromHeader;
        }
        BucketMetadata bucket = this.bucketService.verifyBucketExists(bucketName);
        this.objectService.verifyObjectMatching(bucketName, key.key(), match, noneMatch);
        Path tempFile = tempFileAndChecksum.path();
        this.objectService.verifyMd5(tempFile, contentMd5);
        if (checksum != null) {
            this.objectService.verifyChecksum(tempFile, checksum, checksumAlgorithm);
        }
        Owner owner = Owner.DEFAULT_OWNER;
        S3ObjectMetadata s3ObjectMetadata = this.objectService.putS3Object(bucketName, key.key(), HeaderUtil.mediaTypeFrom(contentType).toString(), HeaderUtil.storeHeadersFrom(httpHeaders), tempFile, HeaderUtil.userMetadataFrom(httpHeaders), HeaderUtil.encryptionHeadersFrom(httpHeaders), tags, checksumAlgorithm, checksum, owner, storageClass);
        FileUtils.deleteQuietly((File)tempFile.toFile());
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> {
            if (bucket.isVersioningEnabled() && s3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", s3ObjectMetadata.versionId());
            }
        })).headers(h -> h.setAll(HeaderUtil.checksumHeaderFrom(s3ObjectMetadata)))).headers(h -> {
            if (s3ObjectMetadata.encryptionHeaders() != null) {
                h.setAll(s3ObjectMetadata.encryptionHeaders());
            }
        })).header("x-amz-object-size", new String[]{s3ObjectMetadata.size()})).lastModified(s3ObjectMetadata.lastModified())).eTag(s3ObjectMetadata.etag())).build();
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, headers={"x-amz-copy-source"}, params={"!uploadId", "!tagging", "!legal-hold", "!retention", "!acl"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<CopyObjectResult> copyObject(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="x-amz-copy-source") CopySource copySource, @RequestHeader(value="x-amz-metadata-directive", defaultValue="COPY") AwsHttpHeaders.MetadataDirective metadataDirective, @RequestHeader(value="x-amz-copy-source-if-match", required=false) @Nullable List<String> match, @RequestHeader(value="x-amz-copy-source-if-none-match", required=false) @Nullable List<String> noneMatch, @RequestHeader(value="x-amz-copy-source-if-modified-since", required=false) @Nullable List<Instant> ifModifiedSince, @RequestHeader(value="x-amz-copy-source-if-unmodified-since", required=false) @Nullable List<Instant> ifUnmodifiedSince, @RequestHeader(value="x-amz-storage-class", required=false) @Nullable StorageClass storageClass, @RequestHeader HttpHeaders httpHeaders) {
        S3ObjectMetadata copyS3ObjectMetadata;
        BucketMetadata targetBucket = this.bucketService.verifyBucketExists(bucketName);
        BucketMetadata sourceBucket = this.bucketService.verifyBucketExists(copySource.bucket());
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(copySource.bucket(), copySource.key(), copySource.versionId());
        this.objectService.verifyObjectMatchingForCopy(match, noneMatch, ifModifiedSince, ifUnmodifiedSince, s3ObjectMetadata);
        Map<String, String> userMetadata = Collections.emptyMap();
        Map<String, String> storeHeaders = Collections.emptyMap();
        if (AwsHttpHeaders.MetadataDirective.REPLACE == metadataDirective) {
            userMetadata = HeaderUtil.userMetadataFrom(httpHeaders);
            storeHeaders = HeaderUtil.storeHeadersFrom(httpHeaders);
        }
        if ((copyS3ObjectMetadata = this.objectService.copyS3Object(copySource.bucket(), copySource.key(), copySource.versionId(), bucketName, key.key(), HeaderUtil.encryptionHeadersFrom(httpHeaders), storeHeaders, userMetadata, storageClass)) == null) {
            return ResponseEntity.notFound().headers(headers -> {
                if (s3ObjectMetadata.encryptionHeaders() != null) {
                    headers.setAll(s3ObjectMetadata.encryptionHeaders());
                }
            }).build();
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers -> {
            if (s3ObjectMetadata.encryptionHeaders() != null) {
                headers.setAll(s3ObjectMetadata.encryptionHeaders());
            }
        })).headers(h -> {
            if (sourceBucket.isVersioningEnabled() && copySource.versionId() != null) {
                h.set("x-amz-copy-source-version-id", copySource.versionId());
            }
        })).headers(h -> {
            if (targetBucket.isVersioningEnabled() && copyS3ObjectMetadata.versionId() != null) {
                h.set("x-amz-version-id", copyS3ObjectMetadata.versionId());
            }
        })).body((Object)new CopyObjectResult(copyS3ObjectMetadata));
    }

    private ResponseEntity<StreamingResponseBody> getObjectWithRange(HttpRange range, S3ObjectMetadata s3ObjectMetadata) {
        long fileSize = s3ObjectMetadata.dataPath().toFile().length();
        long startInclusive = range.getRangeStart(fileSize);
        long endInclusive = Math.min(fileSize - 1L, range.getRangeEnd(fileSize));
        long contentLength = endInclusive - startInclusive + 1L;
        if (contentLength < 0L || fileSize <= startInclusive) {
            throw S3Exception.INVALID_RANGE;
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.PARTIAL_CONTENT).headers(headers -> this.applyS3MetadataHeaders((HttpHeaders)headers, s3ObjectMetadata))).header("Accept-Ranges", new String[]{RANGES_BYTES})).header("Content-Range", new String[]{String.format("bytes %d-%d/%d", startInclusive, endInclusive, fileSize)})).eTag(s3ObjectMetadata.etag())).contentType(HeaderUtil.mediaTypeFrom(s3ObjectMetadata.contentType())).lastModified(s3ObjectMetadata.lastModified())).contentLength(contentLength).body(outputStream -> ObjectController.extractBytesToOutputStream(startInclusive, s3ObjectMetadata, outputStream, contentLength));
    }

    private void applyS3MetadataHeaders(HttpHeaders headers, S3ObjectMetadata metadata) {
        headers.setAll(HeaderUtil.userMetadataHeadersFrom(metadata));
        if (metadata.storeHeaders() != null) {
            headers.setAll(metadata.storeHeaders());
        }
        if (metadata.encryptionHeaders() != null) {
            headers.setAll(metadata.encryptionHeaders());
        }
    }

    private static void extractBytesToOutputStream(long startOffset, S3ObjectMetadata s3ObjectMetadata, OutputStream outputStream, long bytesToRead) throws IOException {
        block13: {
            try (InputStream fis = Files.newInputStream(s3ObjectMetadata.dataPath(), new OpenOption[0]);){
                long skipped = fis.skip(startOffset);
                if (skipped == startOffset) {
                    try (BoundedInputStream bis = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(fis)).setMaxCount(bytesToRead)).get();){
                        bis.transferTo(outputStream);
                        break block13;
                    }
                }
                throw new IllegalStateException("Could not skip exact byte range");
            }
        }
    }
}

