/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.S3Verified;
import com.adobe.testing.s3mock.dto.BucketLifecycleConfiguration;
import com.adobe.testing.s3mock.dto.CreateBucketConfiguration;
import com.adobe.testing.s3mock.dto.ListAllMyBucketsResult;
import com.adobe.testing.s3mock.dto.ListBucketResult;
import com.adobe.testing.s3mock.dto.ListBucketResultV2;
import com.adobe.testing.s3mock.dto.ListVersionsResult;
import com.adobe.testing.s3mock.dto.LocationConstraint;
import com.adobe.testing.s3mock.dto.ObjectLockConfiguration;
import com.adobe.testing.s3mock.dto.ObjectOwnership;
import com.adobe.testing.s3mock.dto.Region;
import com.adobe.testing.s3mock.dto.VersioningConfiguration;
import com.adobe.testing.s3mock.service.BucketService;
import com.adobe.testing.s3mock.store.BucketMetadata;
import org.jspecify.annotations.Nullable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@CrossOrigin(origins={"*"}, exposedHeaders={"*"})
@Controller
@RequestMapping(value={"${com.adobe.testing.s3mock.contextPath:}"})
public class BucketController {
    private final BucketService bucketService;

    public BucketController(BucketService bucketService) {
        this.bucketService = bucketService;
    }

    @GetMapping(value={"/"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<ListAllMyBucketsResult> listBuckets(@RequestParam(name="bucket-region", required=false) Region bucketRegion, @RequestParam(name="continuation-token", required=false) String continuationToken, @RequestParam(name="max-buckets", defaultValue="1000", required=false) Integer maxBuckets, @RequestParam(required=false) String prefix) {
        ListAllMyBucketsResult listAllMyBucketsResult = this.bucketService.listBuckets(bucketRegion, continuationToken, maxBuckets, prefix);
        return ResponseEntity.ok((Object)listAllMyBucketsResult);
    }

    @PutMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"!object-lock", "!lifecycle", "!versioning"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> createBucket(@PathVariable String bucketName, @RequestHeader(value="x-amz-bucket-object-lock-enabled", required=false, defaultValue="false") boolean objectLockEnabled, @RequestHeader(value="x-amz-object-ownership", required=false, defaultValue="BucketOwnerEnforced") ObjectOwnership objectOwnership, @RequestBody(required=false) @Nullable CreateBucketConfiguration createBucketRequest) {
        this.bucketService.verifyBucketNameIsAllowed(bucketName);
        this.bucketService.verifyBucketDoesNotExist(bucketName);
        this.bucketService.createBucket(bucketName, objectLockEnabled, objectOwnership, this.regionFrom(createBucketRequest), createBucketRequest != null ? createBucketRequest.bucket() : null, createBucketRequest != null ? createBucketRequest.location() : null);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("location", new String[]{"/" + bucketName})).build();
    }

    @RequestMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, method={RequestMethod.HEAD})
    @S3Verified(year=2025)
    public ResponseEntity<Void> headBucket(@PathVariable String bucketName) {
        BucketMetadata bucketMetadata = this.bucketService.verifyBucketExists(bucketName);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("x-amz-bucket-region", new String[]{bucketMetadata.bucketRegion()})).headers(h -> h.setAll(this.bucketService.bucketLocationHeaders(bucketMetadata)))).build();
    }

    @DeleteMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"!lifecycle"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> deleteBucket(@PathVariable String bucketName) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyBucketIsEmpty(bucketName);
        this.bucketService.deleteBucket(bucketName);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"versioning", "!list-type"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<VersioningConfiguration> getVersioningConfiguration(@PathVariable String bucketName) {
        this.bucketService.verifyBucketExists(bucketName);
        VersioningConfiguration configuration = this.bucketService.getVersioningConfiguration(bucketName);
        return ResponseEntity.ok((Object)configuration);
    }

    @PutMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"versioning"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> putVersioningConfiguration(@PathVariable String bucketName, @RequestBody VersioningConfiguration configuration) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.setVersioningConfiguration(bucketName, configuration);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"object-lock", "!list-type"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<ObjectLockConfiguration> getObjectLockConfiguration(@PathVariable String bucketName) {
        this.bucketService.verifyBucketExists(bucketName);
        ObjectLockConfiguration configuration = this.bucketService.getObjectLockConfiguration(bucketName);
        return ResponseEntity.ok((Object)configuration);
    }

    @PutMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"object-lock"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> putObjectLockConfiguration(@PathVariable String bucketName, @RequestBody ObjectLockConfiguration configuration) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.setObjectLockConfiguration(bucketName, configuration);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"lifecycle", "!list-type"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<BucketLifecycleConfiguration> getBucketLifecycleConfiguration(@PathVariable String bucketName) {
        this.bucketService.verifyBucketExists(bucketName);
        BucketLifecycleConfiguration configuration = this.bucketService.getBucketLifecycleConfiguration(bucketName);
        return ResponseEntity.ok((Object)configuration);
    }

    @PutMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"lifecycle"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> putBucketLifecycleConfiguration(@PathVariable String bucketName, @RequestBody BucketLifecycleConfiguration configuration) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.setBucketLifecycleConfiguration(bucketName, configuration);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"lifecycle"})
    @S3Verified(year=2025)
    public ResponseEntity<Void> deleteBucketLifecycleConfiguration(@PathVariable String bucketName) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.deleteBucketLifecycleConfiguration(bucketName);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/{bucketName:.+}"}, params={"location"})
    @S3Verified(year=2025)
    public ResponseEntity<LocationConstraint> getBucketLocation(@PathVariable String bucketName) {
        BucketMetadata bucketMetadata = this.bucketService.verifyBucketExists(bucketName);
        String bucketRegion = bucketMetadata.bucketRegion();
        return ResponseEntity.ok((Object)new LocationConstraint(bucketRegion));
    }

    @GetMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"!uploads", "!object-lock", "!list-type", "!lifecycle", "!location", "!versions", "!versioning"}, produces={"application/xml"})
    @Deprecated(since="2.12.2", forRemoval=true)
    @S3Verified(year=2025)
    public ResponseEntity<ListBucketResult> listObjects(@PathVariable String bucketName, @RequestParam(required=false) String delimiter, @RequestParam(name="encoding-type", required=false) String encodingType, @RequestParam(required=false) String marker, @RequestParam(name="max-keys", defaultValue="1000", required=false) Integer maxKeys, @RequestParam(required=false) String prefix) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyMaxKeys(maxKeys);
        this.bucketService.verifyEncodingType(encodingType);
        ListBucketResult listBucketResult = this.bucketService.listObjectsV1(bucketName, prefix, delimiter, marker, encodingType, maxKeys);
        return ResponseEntity.ok((Object)listBucketResult);
    }

    @GetMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"list-type=2"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<ListBucketResultV2> listObjectsV2(@PathVariable String bucketName, @RequestParam(name="continuation-token", required=false) String continuationToken, @RequestParam(required=false) String delimiter, @RequestParam(name="encoding-type", required=false) String encodingType, @RequestParam(name="fetch-owner", defaultValue="false") boolean fetchOwner, @RequestParam(name="max-keys", defaultValue="1000", required=false) Integer maxKeys, @RequestParam(required=false) String prefix, @RequestParam(name="start-after", required=false) String startAfter) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyMaxKeys(maxKeys);
        this.bucketService.verifyEncodingType(encodingType);
        ListBucketResultV2 listBucketResultV2 = this.bucketService.listObjectsV2(bucketName, prefix, delimiter, encodingType, startAfter, maxKeys, continuationToken, fetchOwner);
        return ResponseEntity.ok((Object)listBucketResultV2);
    }

    @GetMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"versions"}, produces={"application/xml"})
    @S3Verified(year=2025)
    public ResponseEntity<ListVersionsResult> listObjectVersions(@PathVariable String bucketName, @RequestParam(required=false) String delimiter, @RequestParam(name="encoding-type", required=false) String encodingType, @RequestParam(name="key-marker", required=false) String keyMarker, @RequestParam(name="max-keys", defaultValue="1000", required=false) Integer maxKeys, @RequestParam(required=false) String prefix, @RequestParam(name="version-id-marker", required=false) String versionIdMarker) {
        this.bucketService.verifyBucketExists(bucketName);
        this.bucketService.verifyMaxKeys(maxKeys);
        this.bucketService.verifyEncodingType(encodingType);
        ListVersionsResult listVersionsResult = this.bucketService.listVersions(bucketName, prefix, delimiter, encodingType, maxKeys, keyMarker, versionIdMarker);
        return ResponseEntity.ok((Object)listVersionsResult);
    }

    private @Nullable String regionFrom(@Nullable CreateBucketConfiguration createBucketRequest) {
        if (createBucketRequest != null) {
            return createBucketRequest.regionFrom();
        }
        return null;
    }
}

