/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.BucketStore;
import com.adobe.testing.s3mock.store.KmsKeyStore;
import com.adobe.testing.s3mock.store.MultipartStore;
import com.adobe.testing.s3mock.store.ObjectStore;
import com.adobe.testing.s3mock.store.StoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={StoreProperties.class})
public class StoreConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(StoreConfiguration.class);
    static final DateTimeFormatter S3_OBJECT_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.of("UTC"));

    @Bean
    ObjectStore objectStore(StoreProperties properties, List<String> bucketNames, BucketStore bucketStore, ObjectMapper objectMapper) {
        ObjectStore objectStore = new ObjectStore(properties.retainFilesOnExit(), S3_OBJECT_DATE_FORMAT, objectMapper);
        for (String bucketName : bucketNames) {
            BucketMetadata bucketMetadata = bucketStore.getBucketMetadata(bucketName);
            if (bucketMetadata == null) continue;
            objectStore.loadObjects(bucketMetadata, bucketMetadata.objects().values());
        }
        return objectStore;
    }

    @Bean
    BucketStore bucketStore(StoreProperties properties, File rootFolder, List<String> bucketNames, ObjectMapper objectMapper) {
        BucketStore bucketStore = new BucketStore(rootFolder, properties.retainFilesOnExit(), S3_OBJECT_DATE_FORMAT, objectMapper);
        bucketStore.loadBuckets(bucketNames);
        properties.initialBuckets().stream().filter(name -> {
            boolean partOfExistingBuckets = bucketNames.contains(name);
            if (partOfExistingBuckets) {
                LOG.info("Skip initial bucket {}, it's part of the existing buckets.", name);
            }
            return !partOfExistingBuckets;
        }).forEach(name -> {
            bucketStore.createBucket((String)name, false);
            LOG.info("Creating initial bucket {}.", name);
        });
        return bucketStore;
    }

    @Bean
    List<String> bucketNames(File rootFolder) {
        ArrayList<String> bucketNames = new ArrayList<String>();
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(rootFolder.toPath());){
            paths.forEach(path -> {
                Path resolved = path.resolve("bucketMetadata.json");
                if (resolved.toFile().exists()) {
                    bucketNames.add(path.getFileName().toString());
                } else {
                    LOG.warn("Found bucket folder {} without {}", path, (Object)"bucketMetadata.json");
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load buckets from data directory " + String.valueOf(rootFolder), e);
        }
        return bucketNames;
    }

    @Bean
    MultipartStore multipartStore(StoreProperties properties, ObjectStore objectStore) {
        return new MultipartStore(properties.retainFilesOnExit(), objectStore);
    }

    @Bean
    KmsKeyStore kmsKeyStore(StoreProperties properties) {
        return new KmsKeyStore(properties.validKmsKeys());
    }

    @Bean
    File rootFolder(StoreProperties properties) {
        File root;
        boolean createTempDir;
        boolean bl = createTempDir = properties.root() == null || properties.root().isEmpty();
        if (createTempDir) {
            Path baseTempDir = FileUtils.getTempDirectory().toPath();
            try {
                root = Files.createTempDirectory(baseTempDir, "s3mockFileStore", new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Root folder could not be created. Base temp dir: " + String.valueOf(baseTempDir), e);
            }
            LOG.info("Successfully created \"{}\" as root folder. Will retain files on exit: {}", (Object)root.getAbsolutePath(), (Object)properties.retainFilesOnExit());
        } else {
            root = new File(properties.root());
            if (root.exists()) {
                LOG.info("Using existing folder \"{}\" as root folder. Will retain files on exit: {}", (Object)root.getAbsolutePath(), (Object)properties.retainFilesOnExit());
            } else {
                if (!root.mkdir()) {
                    throw new IllegalStateException("Root folder could not be created. Path: " + root.getAbsolutePath());
                }
                LOG.info("Successfully created \"{}\" as root folder. Will retain files on exit: {}", (Object)root.getAbsolutePath(), (Object)properties.retainFilesOnExit());
            }
        }
        if (!properties.retainFilesOnExit()) {
            root.deleteOnExit();
        }
        return root;
    }
}

