/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.service;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.AccessControlPolicy;
import com.adobe.testing.s3mock.dto.Checksum;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.CopyObjectResult;
import com.adobe.testing.s3mock.dto.Delete;
import com.adobe.testing.s3mock.dto.DeleteResult;
import com.adobe.testing.s3mock.dto.DeletedS3Object;
import com.adobe.testing.s3mock.dto.Error;
import com.adobe.testing.s3mock.dto.LegalHold;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Retention;
import com.adobe.testing.s3mock.dto.S3ObjectIdentifier;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.BucketStore;
import com.adobe.testing.s3mock.store.ObjectStore;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.AwsChunkedDecodingInputStream;
import com.adobe.testing.s3mock.util.DigestUtil;
import com.adobe.testing.s3mock.util.HeaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectService {
    static final String WILDCARD_ETAG = "\"*\"";
    private static final Logger LOG = LoggerFactory.getLogger(ObjectService.class);
    private final BucketStore bucketStore;
    private final ObjectStore objectStore;

    public ObjectService(BucketStore bucketStore, ObjectStore objectStore) {
        this.bucketStore = bucketStore;
        this.objectStore = objectStore;
    }

    public CopyObjectResult copyS3Object(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey, Map<String, String> encryptionHeaders, Map<String, String> userMetadata) {
        BucketMetadata sourceBucketMetadata = this.bucketStore.getBucketMetadata(sourceBucketName);
        BucketMetadata destinationBucketMetadata = this.bucketStore.getBucketMetadata(destinationBucketName);
        UUID sourceId = sourceBucketMetadata.getID(sourceKey);
        if (sourceId == null) {
            return null;
        }
        if (sourceKey.equals(destinationKey) && sourceBucketName.equals(destinationBucketName)) {
            return this.objectStore.pretendToCopyS3Object(sourceBucketMetadata, sourceId, userMetadata);
        }
        UUID destinationId = this.bucketStore.addToBucket(destinationKey, destinationBucketName);
        try {
            return this.objectStore.copyS3Object(sourceBucketMetadata, sourceId, destinationBucketMetadata, destinationId, destinationKey, encryptionHeaders, userMetadata);
        }
        catch (Exception e) {
            this.bucketStore.removeFromBucket(destinationKey, destinationBucketName);
            throw e;
        }
    }

    public S3ObjectMetadata putS3Object(String bucketName, String key, String contentType, Map<String, String> storeHeaders, InputStream dataStream, boolean useV4ChunkedWithSigningFormat, Map<String, String> userMetadata, Map<String, String> encryptionHeaders, List<Tag> tags, ChecksumAlgorithm checksumAlgorithm, String checksum, Owner owner) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            id = this.bucketStore.addToBucket(key, bucketName);
        }
        return this.objectStore.storeS3ObjectMetadata(bucketMetadata, id, key, contentType, storeHeaders, dataStream, useV4ChunkedWithSigningFormat, userMetadata, encryptionHeaders, null, tags, checksumAlgorithm, checksum, owner);
    }

    public DeleteResult deleteObjects(String bucketName, Delete delete) {
        DeleteResult response = new DeleteResult(new ArrayList<DeletedS3Object>(), new ArrayList<Error>());
        for (S3ObjectIdentifier object : delete.objectsToDelete()) {
            try {
                this.deleteObject(bucketName, object.key());
                response.addDeletedObject(DeletedS3Object.from(object));
            }
            catch (IllegalStateException e) {
                response.addError(new Error("InternalError", object.key(), "We encountered an internal error. Please try again.", object.versionId()));
                LOG.error("Object could not be deleted!", (Throwable)e);
            }
        }
        return response;
    }

    public boolean deleteObject(String bucketName, String key) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            return false;
        }
        if (this.objectStore.deleteObject(bucketMetadata, id)) {
            return this.bucketStore.removeFromBucket(key, bucketName);
        }
        return false;
    }

    public void setObjectTags(String bucketName, String key, List<Tag> tags) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        this.objectStore.storeObjectTags(bucketMetadata, uuid, tags);
    }

    public void setLegalHold(String bucketName, String key, LegalHold legalHold) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        this.objectStore.storeLegalHold(bucketMetadata, uuid, legalHold);
    }

    public void setAcl(String bucketName, String key, AccessControlPolicy policy) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        this.objectStore.storeAcl(bucketMetadata, uuid, policy);
    }

    public AccessControlPolicy getAcl(String bucketName, String key) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        return this.objectStore.readAcl(bucketMetadata, uuid);
    }

    public void setRetention(String bucketName, String key, Retention retention) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        this.objectStore.storeRetention(bucketMetadata, uuid, retention);
    }

    public void verifyRetention(Retention retention) {
        Instant retainUntilDate = retention.retainUntilDate();
        if (Instant.now().isAfter(retainUntilDate)) {
            throw S3Exception.INVALID_REQUEST_RETAINDATE;
        }
    }

    public InputStream verifyMd5(InputStream inputStream, String contentMd5, String sha256Header) {
        InputStream inputStream2;
        block8: {
            Path tempFile = Files.createTempFile("md5Check", "", new FileAttribute[0]);
            inputStream.transferTo(Files.newOutputStream(tempFile, new OpenOption[0]));
            InputStream stream = HeaderUtil.isV4ChunkedWithSigningEnabled(sha256Header) ? new AwsChunkedDecodingInputStream(Files.newInputStream(tempFile, new OpenOption[0])) : Files.newInputStream(tempFile, new OpenOption[0]);
            try {
                this.verifyMd5(stream, contentMd5);
                inputStream2 = Files.newInputStream(tempFile, new OpenOption[0]);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw S3Exception.BAD_REQUEST_CONTENT;
                }
            }
            stream.close();
        }
        return inputStream2;
    }

    public void verifyMd5(InputStream inputStream, String contentMd5) {
        String md5;
        if (contentMd5 != null && !(md5 = DigestUtil.base64Digest(inputStream)).equals(contentMd5)) {
            LOG.error("Content-MD5 {} does not match object md5 {}", (Object)contentMd5, (Object)md5);
            throw S3Exception.BAD_REQUEST_MD5;
        }
    }

    public void verifyObjectMatchingForCopy(List<String> match, List<String> noneMatch, S3ObjectMetadata s3ObjectMetadata) {
        try {
            this.verifyObjectMatching(match, noneMatch, s3ObjectMetadata);
        }
        catch (S3Exception e) {
            if (S3Exception.NOT_MODIFIED.equals(e)) {
                throw S3Exception.PRECONDITION_FAILED;
            }
            throw e;
        }
    }

    public void verifyObjectMatching(List<String> match, List<String> noneMatch, S3ObjectMetadata s3ObjectMetadata) {
        if (s3ObjectMetadata != null) {
            String etag = s3ObjectMetadata.etag();
            if (match != null) {
                if (match.contains(WILDCARD_ETAG)) {
                    return;
                }
                if (!match.contains(etag)) {
                    throw S3Exception.PRECONDITION_FAILED;
                }
            }
            if (noneMatch != null && (noneMatch.contains(WILDCARD_ETAG) || noneMatch.contains(etag))) {
                throw S3Exception.NOT_MODIFIED;
            }
        }
    }

    public S3ObjectMetadata verifyObjectExists(String bucketName, String key) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        if (uuid == null) {
            throw S3Exception.NO_SUCH_KEY;
        }
        S3ObjectMetadata s3ObjectMetadata = this.objectStore.getS3ObjectMetadata(bucketMetadata, uuid);
        if (s3ObjectMetadata == null) {
            throw S3Exception.NO_SUCH_KEY;
        }
        return s3ObjectMetadata;
    }

    public S3ObjectMetadata verifyObjectLockConfiguration(String bucketName, String key) {
        boolean noRetention;
        S3ObjectMetadata s3ObjectMetadata = this.verifyObjectExists(bucketName, key);
        boolean noLegalHold = s3ObjectMetadata.legalHold() == null;
        boolean bl = noRetention = s3ObjectMetadata.retention() == null;
        if (noLegalHold && noRetention) {
            throw S3Exception.NOT_FOUND_OBJECT_LOCK;
        }
        return s3ObjectMetadata;
    }

    public static Checksum getChecksum(S3ObjectMetadata s3ObjectMetadata) {
        ChecksumAlgorithm checksumAlgorithm = s3ObjectMetadata.checksumAlgorithm();
        if (checksumAlgorithm != null) {
            return new Checksum(checksumAlgorithm == ChecksumAlgorithm.CRC32 ? s3ObjectMetadata.checksum() : null, checksumAlgorithm == ChecksumAlgorithm.CRC32C ? s3ObjectMetadata.checksum() : null, checksumAlgorithm == ChecksumAlgorithm.SHA1 ? s3ObjectMetadata.checksum() : null, checksumAlgorithm == ChecksumAlgorithm.SHA256 ? s3ObjectMetadata.checksum() : null);
        }
        return null;
    }
}

