/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.dto.BucketLifecycleConfiguration;
import com.adobe.testing.s3mock.dto.ObjectLockConfiguration;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import software.amazon.awssdk.services.s3.model.ObjectOwnership;

public record BucketMetadata(String name, String creationDate, ObjectLockConfiguration objectLockConfiguration, BucketLifecycleConfiguration bucketLifecycleConfiguration, ObjectOwnership objectOwnership, Path path, Map<String, UUID> objects) {
    public BucketMetadata(String name, String creationDate, ObjectLockConfiguration objectLockConfiguration, BucketLifecycleConfiguration bucketLifecycleConfiguration, ObjectOwnership objectOwnership, Path path) {
        this(name, creationDate, objectLockConfiguration, bucketLifecycleConfiguration, objectOwnership, path, new HashMap<String, UUID>());
    }

    public BucketMetadata withObjectLockConfiguration(ObjectLockConfiguration objectLockConfiguration) {
        return new BucketMetadata(this.name(), this.creationDate(), objectLockConfiguration, this.bucketLifecycleConfiguration(), this.objectOwnership(), this.path());
    }

    public BucketMetadata withBucketLifecycleConfiguration(BucketLifecycleConfiguration bucketLifecycleConfiguration) {
        return new BucketMetadata(this.name(), this.creationDate(), this.objectLockConfiguration(), bucketLifecycleConfiguration, this.objectOwnership(), this.path());
    }

    public boolean doesKeyExist(String key) {
        return this.getID(key) != null;
    }

    public UUID addKey(String key) {
        if (this.doesKeyExist(key)) {
            return this.getID(key);
        }
        UUID uuid = UUID.randomUUID();
        this.objects.put(key, uuid);
        return uuid;
    }

    public boolean removeKey(String key) {
        UUID removed = this.objects.remove(key);
        return removed != null;
    }

    public UUID getID(String key) {
        return this.objects.get(key);
    }
}

