/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.service;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.util.AbstractAwsInputStream;
import com.adobe.testing.s3mock.util.AwsChunkedDecodingChecksumInputStream;
import com.adobe.testing.s3mock.util.AwsUnsignedChunkedDecodingChecksumInputStream;
import com.adobe.testing.s3mock.util.DigestUtil;
import com.adobe.testing.s3mock.util.HeaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.HttpHeaders;

abstract class ServiceBase {
    ServiceBase() {
    }

    public void verifyChecksum(Path path, String checksum, ChecksumAlgorithm checksumAlgorithm) {
        String checksumFor = DigestUtil.checksumFor(path, checksumAlgorithm.toAlgorithm());
        if (!checksum.equals(checksumFor)) {
            switch (checksumAlgorithm) {
                case SHA1: {
                    throw S3Exception.BAD_CHECKSUM_SHA1;
                }
                case SHA256: {
                    throw S3Exception.BAD_CHECKSUM_SHA256;
                }
                case CRC32: {
                    throw S3Exception.BAD_CHECKSUM_CRC32;
                }
                case CRC32C: {
                    throw S3Exception.BAD_CHECKSUM_CRC32C;
                }
            }
            throw S3Exception.BAD_DIGEST;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pair<Path, String> toTempFile(InputStream inputStream, HttpHeaders httpHeaders) {
        try {
            Path tempFile = Files.createTempFile("ObjectService", "toTempFile", new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);){
                InputStream wrappedStream = this.wrapStream(inputStream, httpHeaders);
                wrappedStream.transferTo(os);
                ChecksumAlgorithm algorithmFromSdk = HeaderUtil.checksumAlgorithmFromSdk(httpHeaders);
                if (algorithmFromSdk != null && wrappedStream instanceof AbstractAwsInputStream) {
                    AbstractAwsInputStream awsInputStream = (AbstractAwsInputStream)wrappedStream;
                    Pair pair2 = Pair.of((Object)tempFile, (Object)awsInputStream.getChecksum());
                    return pair2;
                }
                Pair pair = Pair.of((Object)tempFile, null);
                return pair;
            }
        }
        catch (IOException e) {
            throw S3Exception.BAD_REQUEST_CONTENT;
        }
    }

    private InputStream wrapStream(InputStream dataStream, HttpHeaders headers) {
        long length;
        String lengthHeader = headers.getFirst("x-amz-decoded-content-length");
        long l = length = lengthHeader == null ? -1L : Long.parseLong(lengthHeader);
        if (HeaderUtil.isChunkedAndV4Signed(headers)) {
            return new AwsChunkedDecodingChecksumInputStream(dataStream, length);
        }
        if (HeaderUtil.isChunked(headers)) {
            return new AwsUnsignedChunkedDecodingChecksumInputStream(dataStream, length);
        }
        return dataStream;
    }
}

