/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

abstract class StoreBase {
    StoreBase() {
    }

    File inputPathToFile(Path inputPath, Path filePath, boolean retainFilesOnExit) {
        File targetFile = filePath.toFile();
        try {
            if (targetFile.createNewFile() && !retainFilesOnExit) {
                targetFile.deleteOnExit();
            }
            try (InputStream is = Files.newInputStream(inputPath, new OpenOption[0]);
                 OutputStream os = Files.newOutputStream(targetFile.toPath(), new OpenOption[0]);){
                is.transferTo(os);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write object binary-file.", e);
        }
        return targetFile;
    }
}

