/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class KmsKeyStore {
    private static final Pattern VALID_KMS_KEY_ARN = Pattern.compile("arn:aws:kms:([a-zA-Z]+)-([a-zA-Z]+)-([0-9]+):([0-9]+):key/.*");
    private final Map<String, String> kmsKeysIdToARN = new ConcurrentHashMap<String, String>();

    public KmsKeyStore(Set<String> validKmsKeys) {
        validKmsKeys.forEach(this::registerKMSKeyRef);
    }

    public void registerKMSKeyRef(String validKeyRef) {
        if (VALID_KMS_KEY_ARN.matcher(validKeyRef).matches()) {
            String[] kmsKey = validKeyRef.split("/");
            this.kmsKeysIdToARN.put(kmsKey[1], validKeyRef);
        }
    }

    public boolean validateKeyId(String keyId) {
        return this.kmsKeysIdToARN.containsKey(keyId);
    }
}

