/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.dto.BucketLifecycleConfiguration;
import com.adobe.testing.s3mock.dto.ObjectLockConfiguration;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class BucketMetadata {
    private String name;
    private String creationDate;
    private ObjectLockConfiguration objectLockConfiguration;
    private BucketLifecycleConfiguration bucketLifecycleConfiguration;
    private Path path;
    private Map<String, UUID> objects = new HashMap<String, UUID>();

    public BucketLifecycleConfiguration getBucketLifecycleConfiguration() {
        return this.bucketLifecycleConfiguration;
    }

    public void setBucketLifecycleConfiguration(BucketLifecycleConfiguration bucketLifecycleConfiguration) {
        this.bucketLifecycleConfiguration = bucketLifecycleConfiguration;
    }

    public ObjectLockConfiguration getObjectLockConfiguration() {
        return this.objectLockConfiguration;
    }

    public void setObjectLockConfiguration(ObjectLockConfiguration objectLockConfiguration) {
        this.objectLockConfiguration = objectLockConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public Map<String, UUID> getObjects() {
        return this.objects;
    }

    public void setObjects(Map<String, UUID> objects) {
        this.objects = objects;
    }

    public boolean doesKeyExist(String key) {
        return this.getID(key) != null;
    }

    public UUID addKey(String key) {
        if (this.doesKeyExist(key)) {
            return this.getID(key);
        }
        UUID uuid = UUID.randomUUID();
        this.objects.put(key, uuid);
        return uuid;
    }

    public boolean removeKey(String key) {
        UUID removed = this.objects.remove(key);
        return removed != null;
    }

    public UUID getID(String key) {
        return this.objects.get(key);
    }

    public String toString() {
        return "BucketMetadata{name='" + this.name + '\'' + ", creationDate='" + this.creationDate + '\'' + ", path=" + this.path + ", objects=" + this.objects + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketMetadata that = (BucketMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.objectLockConfiguration, that.objectLockConfiguration) && Objects.equals(this.path, that.path) && Objects.equals(this.objects, that.objects);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.creationDate, this.objectLockConfiguration, this.path, this.objects);
    }
}

