/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.service;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadResult;
import com.adobe.testing.s3mock.dto.CompletedPart;
import com.adobe.testing.s3mock.dto.CopyPartResult;
import com.adobe.testing.s3mock.dto.InitiateMultipartUploadResult;
import com.adobe.testing.s3mock.dto.ListMultipartUploadsResult;
import com.adobe.testing.s3mock.dto.ListPartsResult;
import com.adobe.testing.s3mock.dto.MultipartUpload;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Part;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.BucketStore;
import com.adobe.testing.s3mock.store.MultipartStore;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRange;

public class MultipartService {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartService.class);
    static final Long MINIMUM_PART_SIZE = 0x500000L;
    private final BucketStore bucketStore;
    private final MultipartStore multipartStore;

    public MultipartService(BucketStore bucketStore, MultipartStore multipartStore) {
        this.bucketStore = bucketStore;
        this.multipartStore = multipartStore;
    }

    public String putPart(String bucketName, String key, String uploadId, String partNumber, InputStream inputStream, boolean useV4ChunkedWithSigningFormat, Map<String, String> encryptionHeaders) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        if (uuid == null) {
            return null;
        }
        return this.multipartStore.putPart(bucketMetadata, uuid, uploadId, partNumber, inputStream, useV4ChunkedWithSigningFormat, encryptionHeaders);
    }

    public CopyPartResult copyPart(String bucketName, String key, HttpRange copyRange, String partNumber, String destinationBucket, String destinationKey, String uploadId, Map<String, String> encryptionHeaders) {
        BucketMetadata sourceBucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        BucketMetadata destinationBucketMetadata = this.bucketStore.getBucketMetadata(destinationBucket);
        UUID sourceId = sourceBucketMetadata.getID(key);
        if (sourceId == null) {
            return null;
        }
        UUID destinationId = this.bucketStore.addToBucket(destinationKey, destinationBucket);
        try {
            String partEtag = this.multipartStore.copyPart(sourceBucketMetadata, sourceId, copyRange, partNumber, destinationBucketMetadata, destinationId, uploadId, encryptionHeaders);
            return CopyPartResult.from(new Date(), "\"" + partEtag + "\"");
        }
        catch (Exception e) {
            LOG.error("Could not copy part. sourceBucket={}, destinationBucket={}, key={}, sourceId={}, destinationId={}, uploadId={}", new Object[]{sourceBucketMetadata, destinationBucketMetadata, key, sourceId, destinationId, uploadId, e});
            this.bucketStore.removeFromBucket(destinationKey, destinationBucket);
            throw e;
        }
    }

    public ListPartsResult getMultipartUploadParts(String bucketName, String key, String uploadId) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            return null;
        }
        List<Part> parts = this.multipartStore.getMultipartUploadParts(bucketMetadata, id, uploadId);
        return new ListPartsResult(bucketName, key, uploadId, parts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortMultipartUpload(String bucketName, String key, String uploadId) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        try {
            this.multipartStore.abortMultipartUpload(bucketMetadata, id, uploadId);
        }
        finally {
            this.bucketStore.removeFromBucket(key, bucketName);
        }
    }

    public CompleteMultipartUploadResult completeMultipartUpload(String bucketName, String key, String uploadId, List<CompletedPart> parts, Map<String, String> encryptionHeaders, String location) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            return null;
        }
        String etag = this.multipartStore.completeMultipartUpload(bucketMetadata, key, id, uploadId, parts, encryptionHeaders);
        return new CompleteMultipartUploadResult(location, bucketName, key, etag);
    }

    public InitiateMultipartUploadResult prepareMultipartUpload(String bucketName, String key, String contentType, Map<String, String> storeHeaders, String uploadId, Owner owner, Owner initiator, Map<String, String> userMetadata, Map<String, String> encryptionHeaders) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = this.bucketStore.addToBucket(key, bucketName);
        try {
            this.multipartStore.prepareMultipartUpload(bucketMetadata, key, id, contentType, storeHeaders, uploadId, owner, initiator, userMetadata, encryptionHeaders);
            return new InitiateMultipartUploadResult(bucketName, key, uploadId);
        }
        catch (Exception e) {
            LOG.error("Could prepare Multipart Upload. bucket={}, key={}, id={}, uploadId={}", new Object[]{bucketMetadata, key, id, uploadId, e});
            this.bucketStore.removeFromBucket(key, bucketName);
            throw e;
        }
    }

    public ListMultipartUploadsResult listMultipartUploads(String bucketName, String prefix) {
        List<MultipartUpload> multipartUploads = this.multipartStore.listMultipartUploads(bucketName, prefix);
        int maxUploads = Math.max(1000, multipartUploads.size());
        boolean isTruncated = false;
        String uploadIdMarker = null;
        String nextUploadIdMarker = null;
        String keyMarker = null;
        String nextKeyMarker = null;
        String delimiter = null;
        List<String> commonPrefixes = Collections.emptyList();
        return new ListMultipartUploadsResult(bucketName, keyMarker, delimiter, prefix, uploadIdMarker, maxUploads, isTruncated, nextKeyMarker, nextUploadIdMarker, multipartUploads, commonPrefixes);
    }

    public void verifyPartNumberLimits(String partNumberString) {
        try {
            int partNumber = Integer.parseInt(partNumberString);
            if (partNumber < 1 || partNumber > 10000) {
                LOG.error("Multipart part number invalid. partNumber={}", (Object)partNumberString);
                throw S3Exception.INVALID_PART_NUMBER;
            }
        }
        catch (NumberFormatException nfe) {
            LOG.error("Multipart part number invalid. partNumber={}", (Object)partNumberString, (Object)nfe);
            throw S3Exception.INVALID_PART_NUMBER;
        }
    }

    public void verifyMultipartParts(String bucketName, String key, String uploadId, List<CompletedPart> requestedParts) throws S3Exception {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            throw S3Exception.INVALID_PART;
        }
        this.verifyMultipartParts(bucketName, id, uploadId);
        List<Part> uploadedParts = this.multipartStore.getMultipartUploadParts(bucketMetadata, id, uploadId);
        Map<Integer, String> uploadedPartsMap = uploadedParts.stream().collect(Collectors.toMap(CompletedPart::getPartNumber, CompletedPart::getETag));
        Integer prevPartNumber = 0;
        for (CompletedPart part : requestedParts) {
            if (!uploadedPartsMap.containsKey(part.getPartNumber()) || !uploadedPartsMap.get(part.getPartNumber()).equals(part.getETag())) {
                LOG.error("Multipart part not valid. bucket={}, id={}, uploadId={}, partNumber={}", new Object[]{bucketMetadata, id, uploadId, part.getPartNumber()});
                throw S3Exception.INVALID_PART;
            }
            if (part.getPartNumber() < prevPartNumber) {
                LOG.error("Multipart parts order invalid. bucket={}, id={}, uploadId={}, partNumber={}", new Object[]{bucketMetadata, id, uploadId, part.getPartNumber()});
                throw S3Exception.INVALID_PART_ORDER;
            }
            prevPartNumber = part.getPartNumber();
        }
    }

    public void verifyMultipartParts(String bucketName, UUID id, String uploadId) throws S3Exception {
        this.verifyMultipartUploadExists(uploadId);
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        List<Part> uploadedParts = this.multipartStore.getMultipartUploadParts(bucketMetadata, id, uploadId);
        if (uploadedParts.size() > 0) {
            for (int i = 0; i < uploadedParts.size() - 1; ++i) {
                Part part = uploadedParts.get(i);
                if (part.getSize() >= MINIMUM_PART_SIZE) continue;
                LOG.error("Multipart part size too small. bucket={}, id={}, uploadId={}, size={}", new Object[]{bucketMetadata, id, uploadId, part.getSize()});
                throw S3Exception.ENTITY_TOO_SMALL;
            }
        }
    }

    public void verifyMultipartUploadExists(String uploadId) throws S3Exception {
        try {
            this.multipartStore.getMultipartUpload(uploadId);
        }
        catch (IllegalArgumentException e) {
            throw S3Exception.NO_SUCH_UPLOAD_MULTIPART;
        }
    }
}

